/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataEvent;
import com.klg.jclass.chart.ChartDataListener;
import com.klg.jclass.chart.ChartDataManageable;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.DataHandler;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDrawableColorHandler;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ChartDataView
implements Changeable,
ChartDataListener,
Serializable {
    protected Vector series = new Vector();
    public static final int PICK_FOCUS_LOCAL = -1;
    public static final int PICK_FOCUS_XY = 0;
    public static final int PICK_FOCUS_X = 1;
    public static final int PICK_FOCUS_Y = 2;
    public static final String ERRMSG_INVALID_SERIES_INDEX = "Invalid ChartDataViewSeries index";
    private double[] xvalues = null;
    protected boolean batched = false;
    protected boolean fastUpdate = false;
    protected boolean bufferPlotData = true;
    protected double holeValue = Double.MAX_VALUE;
    protected int chartType = 0;
    protected String name = null;
    protected int drawingOrder = -1;
    protected boolean drawFrontPlane = true;
    protected ChartDataModel dataSource = null;
    protected transient DataHandler dataHandler;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    protected List pointLabels = new Vector();
    private transient Object transientData = null;
    protected boolean inverted = false;
    protected int pickFocus = 0;
    protected boolean visibleInLegend = true;
    private Vector styles = new Vector();
    protected boolean autoLabel = false;
    protected JCDrawableColorHandler colorHandler;
    protected JCLineStyle outlineStyle = null;
    protected boolean visible = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected boolean allowPick = true;
    protected double step = 1.0;
    protected JCChart chart = null;
    protected MinMax xLimits;
    protected MinMax yLimits;
    public static final String[] format_class_names = new String[]{null, null, "com.klg.jclass.chart.JCPolarRadarChartFormat", "com.klg.jclass.chart.JCPolarRadarChartFormat", "com.klg.jclass.chart.JCPolarRadarChartFormat", "com.klg.jclass.chart.JCHiloChartFormat", "com.klg.jclass.chart.JCHLOCChartFormat", "com.klg.jclass.chart.JCCandleChartFormat", "com.klg.jclass.chart.JCAreaChartFormat", "com.klg.jclass.chart.JCBarChartFormat", "com.klg.jclass.chart.JCBarChartFormat", "com.klg.jclass.chart.JCPieChartFormat", "com.klg.jclass.chart.JCAreaChartFormat"};
    protected Hashtable formatClassHashtable = new Hashtable();
    protected static int dataViewNum = 0;

    ChartDataView(JCChart jCChart) {
        this.setChartType(0);
        this.setParent(jCChart);
        this.name = JCChartBundle.string("com.klg.jclass.chart.Key26") + ++dataViewNum;
    }

    public ChartDataView() {
        this.setChartType(0);
        this.name = JCChartBundle.string("com.klg.jclass.chart.Key26") + ++dataViewNum;
    }

    public void setParent(JCChart jCChart) {
        this.chart = jCChart;
        if (this.chart != null && this.chart.getChartArea() != null) {
            if (this.xaxis == null || !this.chart.getChartArea().getXAxes().contains(this.xaxis)) {
                this.xaxis = this.chart.getChartArea().getXAxis(0);
            }
            if (this.yaxis == null || !this.chart.getChartArea().getYAxes().contains(this.yaxis)) {
                this.yaxis = this.chart.getChartArea().getYAxis(0);
            }
        }
        this.setChanged(true, 2, false);
    }

    public JCChart getParent() {
        return this.chart;
    }

    void draw(Graphics graphics) {
    }

    boolean editPoint(ChartDataViewSeries chartDataViewSeries, int n, double d) {
        if (this.dataSource == null) {
            return true;
        }
        if (!(this.dataSource instanceof EditableChartDataModel)) {
            return false;
        }
        int n2 = this.series.indexOf(chartDataViewSeries);
        if (n2 == -1) {
            throw new RuntimeException("Bad row in editPoint!");
        }
        return this.getDataHandler().editPoint(n2, n, d);
    }

    public void chartDataChange(ChartDataEvent chartDataEvent) {
        if (chartDataEvent == null) {
            return;
        }
        switch (chartDataEvent.getType()) {
            case 0: {
                this.getDataHandler().reloadPoint(chartDataEvent.getSeriesIndex(), chartDataEvent.getPointIndex());
                break;
            }
            case 1: {
                this.getDataHandler().reloadSeries(chartDataEvent.getSeriesIndex());
                break;
            }
            case 2: {
                this.getDataHandler().addSeries();
                break;
            }
            case 3: {
                this.getDataHandler().insertSeries(chartDataEvent.getSeriesIndex());
                break;
            }
            case 5: {
                this.getDataHandler().removeSeries(chartDataEvent.getSeriesIndex());
                break;
            }
            case 6: {
                this.getDataHandler().reloadAllPointLabels();
                break;
            }
            case 7: {
                this.getDataHandler().reloadPointLabel(chartDataEvent.getPointIndex());
                break;
            }
            case 8: {
                this.getDataHandler().reloadAllSeriesLabels();
                break;
            }
            case 9: {
                this.getDataHandler().reloadSeriesLabel(chartDataEvent.getSeriesIndex());
                break;
            }
            case 10: {
                this.getDataHandler().reloadDataSourceName();
                break;
            }
            case 15: {
                this.getDataHandler().reloadHoleValue();
                break;
            }
            case 11: {
                boolean bl;
                this.getDataHandler().appendData();
                int n = this.getChartType();
                if (!this.fastUpdate || !this.chart.isDisplayable() || n != 0 && n != 1 && n != 8 || !this.checkNewPoints(chartDataEvent.getSeriesIndex()) || !(bl = this.doFastUpdate(chartDataEvent.getPointIndex(), chartDataEvent.getSeriesIndex()))) break;
                return;
            }
            case 12: {
                this.getDataHandler().reset();
                break;
            }
            case 13: {
                this.getDataHandler().reload();
                break;
            }
            case 14: {
                this.getDataHandler().changeChartType(chartDataEvent.getSeriesIndex());
                break;
            }
            default: {
                throw new RuntimeException("Unkwown event type: " + chartDataEvent.getType());
            }
        }
        this.setChanged(true, 34);
    }

    public boolean doFastUpdate(int n, int n2) {
        boolean bl = false;
        ChartDraw chartDraw = this.chart.getChartArea().getDrawable(this);
        if (chartDraw != null) {
            Graphics graphics = null;
            try {
                chartDraw.recalc(n, n + n2 - 1);
                graphics = this.chart.getChartArea().getGraphics();
                Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
                graphics.translate(rectangle.x, rectangle.y);
                Rectangle rectangle2 = this.chart.getChartArea().clipForDrawing();
                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                chartDraw.draw(graphics, n, n + n2 - 1);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.chart.firePaint();
        }
        return bl;
    }

    public boolean checkNewPoints(int n) {
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = this.getSeries(n2);
            int n3 = chartDataViewSeries.maxIndex();
            int n4 = n3 - n + 1;
            while (n4 <= n3) {
                double d = chartDataViewSeries.getX(n4);
                if (d != this.holeValue && (this.xaxis.getMaxIsDefault() && d > this.xaxis.getMax() || this.xaxis.getMinIsDefault() && d < this.xaxis.getMin())) {
                    return false;
                }
                double d2 = chartDataViewSeries.getY(n4);
                if (d2 != this.holeValue && (this.yaxis.getMaxIsDefault() && d2 > this.yaxis.getMax() || this.yaxis.getMinIsDefault() && d2 < this.yaxis.getMin())) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    public void setHoleValue(double d) {
        this.holeValue = d;
        this.setChanged(true, 130);
    }

    public boolean isBatched() {
        return this.batched;
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!this.batched) {
            this.propagateChange();
        }
    }

    public boolean getFastUpdate() {
        return this.fastUpdate;
    }

    public void setFastUpdate(boolean bl) {
        if (this.fastUpdate == bl) {
            return;
        }
        this.fastUpdate = bl;
    }

    public boolean getBufferPlotData() {
        return this.bufferPlotData;
    }

    public void setBufferPlotData(boolean bl) {
        if (this.bufferPlotData == bl) {
            return;
        }
        this.bufferPlotData = bl;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int n) {
        if (this.chartType == n) {
            return;
        }
        if (this.xaxis != null) {
            this.xaxis.annotationMethod = this.xaxis.savedXAxisAnnotationMethod;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid chart type");
            }
        }
        switch (this.chartType) {
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                if (this.yaxis != null) {
                    this.yaxis.setVisible(true);
                    this.yaxis.setChanged(true, 2, false);
                }
                if (this.xaxis == null) break;
                this.xaxis.setVisible(true);
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 9: 
            case 10: {
                if (this.xaxis == null) break;
                this.xaxis.setChanged(true, 2, false);
            }
        }
        this.chartType = n;
        this.getChartFormat(this.chartType);
        switch (this.chartType) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                if (this.yaxis == null || this.xaxis == null) break;
                boolean bl = false;
                if (this.yaxis.getOriginPlacementIsDefault() && this.yaxis.originPlacement.value != 0) {
                    this.yaxis.originPlacement.value = 0;
                    bl = true;
                }
                if (this.yaxis.getPlacementIsDefault() && this.yaxis.placement.value != 0) {
                    this.yaxis.placement.value = 0;
                    bl = true;
                }
                if (bl) {
                    this.yaxis.setChanged(true, 2, false);
                }
                if (!this.xaxis.getPlacementIsDefault() || this.xaxis.placement.value == 0) break;
                this.xaxis.placement.value = 0;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 9: 
            case 10: {
                int n2;
                if (this.yaxis == null || this.xaxis == null) break;
                this.xaxis.savedXAxisAnnotationMethod = this.xaxis.annotationMethod;
                this.xaxis.placementAxis = this.yaxis;
                boolean bl = true;
                if (this.chart != null) {
                    n2 = 0;
                    while (n2 < this.chart.getChartArea().getXAxes().size()) {
                        if (this.chart.getChartArea().getXAxis((int)n2).annotationMethod != 0) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    this.xaxis.annotationMethod = 3;
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.setChanged(true, 2, false);
                n2 = 0;
                if (this.yaxis.getPlacementIsDefault()) {
                    this.yaxis.placement.value = 1;
                    n2 = 1;
                }
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    n2 = 1;
                }
                if (n2 == 0) break;
                this.yaxis.setChanged(true, 2, false);
                break;
            }
            case 8: 
            case 12: {
                if (this.yaxis == null || this.xaxis == null) break;
                boolean bl = false;
                if (this.yaxis.getPlacementIsDefault()) {
                    this.yaxis.placement.value = 1;
                    bl = true;
                }
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    bl = true;
                }
                if (bl) {
                    this.yaxis.setChanged(true, 2, false);
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.placementAxis = this.yaxis;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
        }
        if (this.chart != null) {
            this.chart.getChartArea().removeDrawable(this);
        }
        this.transientData = null;
        this.setChanged(true, 34);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name != null && this.name.equals(string)) {
            return;
        }
        if (string != null) {
            this.name = string;
        }
        this.setChanged(true, 33);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public void setDrawingOrder(int n) {
        if (n < 0 || this.chart != null && n >= this.chart.getOriginalDataView().size()) {
            throw new IllegalArgumentException("DrawingOrder property for ChartDataView is out of range");
        }
        this.drawingOrder = n;
        this.setChanged(true, 17);
    }

    public boolean getDrawFrontPlane() {
        return this.drawFrontPlane;
    }

    public void setDrawFrontPlane(boolean bl) {
        this.drawFrontPlane = bl;
        this.setChanged(true, 2);
    }

    public ChartDataModel getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ChartDataModel chartDataModel) {
        boolean bl = false;
        if (this.dataSource instanceof ChartDataManageable) {
            ((ChartDataManageable)((Object)this.dataSource)).getChartDataManager().removeChartDataListener(this);
        }
        this.dataSource = chartDataModel;
        if (this.dataSource == null) {
            this.series = new Vector();
            if (this.autoLabel && this.chart != null) {
                this.chart.getChartLabelManager().clearAutoLabels(this);
            }
            this.setX(null);
            this.setChanged(true, 162);
            return;
        }
        bl = this.isBatched();
        this.setBatched(true);
        this.getDataHandler().reset();
        this.getDataHandler().reloadAllPointLabels();
        this.getDataHandler().reloadAllSeriesLabels();
        this.getDataHandler().reloadDataSourceName();
        if (chartDataModel instanceof ChartDataManageable) {
            ((ChartDataManageable)((Object)chartDataModel)).getChartDataManager().addChartDataListener(this);
        }
        if (!(this.dataSource instanceof EditableChartDataModel) && !(this.dataSource instanceof ChartDataManageable)) {
            this.dataSource = null;
        }
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().generateAutoLabels(this);
        }
        this.setChanged(true, 162, false);
        this.setBatched(bl);
    }

    public String getPointLabel(int n) {
        if (n < 0 || n >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        return (String)this.pointLabels.get(n);
    }

    public void setPointLabel(int n, String string) {
        if (n < 0 || n >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        this.pointLabels.set(n, string);
        this.setChanged(true, 130);
    }

    public List getPointLabels() {
        return this.pointLabels;
    }

    public int getNumPointLabels() {
        return this.pointLabels.size();
    }

    public void setPointLabels(List list) {
        this.pointLabels = list;
        this.setChanged(true, 130);
    }

    public List getSeries() {
        return new Vector(this.series);
    }

    public ChartDataViewSeries getSeries(int n) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX);
        }
        return (ChartDataViewSeries)this.series.get(n);
    }

    public void setSeries(List list) {
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().removeAutoLabels(this);
        }
        this.series = list == null ? new Vector() : new Vector(list);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().generateAutoLabels(this);
        }
        if (this.chart != null) {
            if (this.chartType == 11) {
                ((JCPieChartFormat)this.getChartFormat()).getOtherStyle();
            }
            int n = 0;
            while (n < this.series.size()) {
                this.getChartStyle(n);
                ++n;
            }
        }
        this.setChanged(true, 162);
    }

    public void setSeries(int n, ChartDataViewSeries chartDataViewSeries) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX);
        }
        this.series.set(n, chartDataViewSeries);
        if (this.autoLabel && this.chart != null) {
            int n2 = 0;
            while (n2 <= chartDataViewSeries.maxIndex()) {
                this.chart.getChartLabelManager().setAutoLabelText(this, n, n2);
                ++n2;
            }
        }
        this.setChanged(true, 162);
    }

    public ChartDataViewSeries addSeries(int n) {
        ChartDataViewSeries chartDataViewSeries = null;
        if (n < 0) {
            n = 0;
        }
        if (n > this.series.size()) {
            n = this.series.size();
        }
        chartDataViewSeries = new ChartDataViewSeries();
        chartDataViewSeries.init(null, null, this);
        chartDataViewSeries.setDrawingOrder(n);
        this.series.add(n, chartDataViewSeries);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().addAutoLabels(this, n, -1);
        }
        this.setChanged(true, 2);
        return chartDataViewSeries;
    }

    public void addSeries(ChartDataViewSeries chartDataViewSeries) {
        chartDataViewSeries.setDrawingOrder(this.series.size());
        this.series.add(chartDataViewSeries);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().addAutoLabels(this, this.series.size() - 1, -1);
        }
        this.setChanged(true, 2);
    }

    public void removeSeries(int n) {
        if (n < 0 || n >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX);
        }
        this.series.remove(n);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().removeAutoLabels(this, n, -1);
        }
        this.setChanged(true, 2);
    }

    public int getSeriesIndex(String string) {
        try {
            int n = 0;
            while (n < this.series.size()) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n);
                if (string.equals(chartDataViewSeries.getName())) {
                    return n;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public int getSeriesIndex(ChartDataViewSeries chartDataViewSeries) {
        return this.series.indexOf(chartDataViewSeries);
    }

    public JCChartTypeFormat getChartFormat() {
        return this.getChartFormat(this.chartType);
    }

    public JCChartTypeFormat getChartFormat(int n) {
        JCChartTypeFormat jCChartTypeFormat = this.getExistingChartFormat(n);
        if (jCChartTypeFormat != null) {
            return jCChartTypeFormat;
        }
        if (n == 10) {
            n = 9;
        } else if (n == 12) {
            n = 8;
        }
        if (n <= 0 || n >= format_class_names.length) {
            return null;
        }
        String string = format_class_names[n];
        if (string != null) {
            try {
                jCChartTypeFormat = (JCChartTypeFormat)Class.forName(string).newInstance();
                jCChartTypeFormat.setParent(this);
                this.formatClassHashtable.put(new Integer(n), jCChartTypeFormat);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jCChartTypeFormat;
    }

    public JCChartTypeFormat getExistingChartFormat(int n) {
        if (n == 10) {
            n = 9;
        } else if (n == 12) {
            n = 8;
        }
        if (n < 0 || n >= format_class_names.length) {
            return null;
        }
        if (format_class_names[n] != null) {
            return (JCChartTypeFormat)this.formatClassHashtable.get(new Integer(n));
        }
        return null;
    }

    public JCAxis getXAxis() {
        return this.xaxis;
    }

    public void setXAxis(JCAxis jCAxis) {
        this.xaxis = jCAxis;
        this.setChanged(true, 130);
    }

    public JCAxis getYAxis() {
        return this.yaxis;
    }

    public void setYAxis(JCAxis jCAxis) {
        this.yaxis = jCAxis;
        this.setChanged(true, 130);
    }

    public JCDataCoord map(int n, int n2) {
        Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
        Point point = this.chart.getChartArea().getLocation();
        n -= rectangle.x + point.x;
        n2 -= rectangle.y + point.y;
        JCDataCoord jCDataCoord = new JCDataCoord(this.holeValue, this.holeValue);
        if (this.chartType == 2) {
            if (this.yaxis != null) {
                JCDataCoord jCDataCoord2 = this.yaxis.toDataPolar(n, n2);
                jCDataCoord.x = jCDataCoord2.getX();
                jCDataCoord.y = jCDataCoord2.getY();
            }
        } else {
            if (this.xaxis != null) {
                double d = jCDataCoord.x = this.xaxis.vertical ? this.xaxis.toData(n2) : this.xaxis.toData(n);
            }
            if (this.yaxis != null) {
                jCDataCoord.y = this.yaxis.vertical ? this.yaxis.toData(n2) : this.yaxis.toData(n);
            }
        }
        return jCDataCoord;
    }

    public Point unmap(double d, double d2) {
        Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
        Point point = this.chart.getChartArea().getLocation();
        Point point2 = new Point(rectangle.x + point.x, rectangle.y + point.y);
        if (this.chartType == 2) {
            if (this.yaxis != null) {
                Point point3 = this.yaxis.toPixelPolar(d, d2, true);
                point2.x += point3.x;
                point2.y += point3.y;
            }
        } else {
            if (this.xaxis != null) {
                if (this.xaxis.vertical) {
                    point2.y += this.xaxis.toPixel(d);
                } else {
                    point2.x += this.xaxis.toPixel(d);
                }
            }
            if (this.yaxis != null) {
                if (this.yaxis.vertical) {
                    point2.y += this.yaxis.toPixel(d2);
                } else {
                    point2.x += this.yaxis.toPixel(d2);
                }
            }
        }
        return point2;
    }

    public JCDataCoord coordToDataCoord(int n, int n2) {
        return this.map(n, n2);
    }

    public Point dataCoordToCoord(double d, double d2) {
        return this.unmap(d, d2);
    }

    public Point dataIndexToCoord(JCDataIndex jCDataIndex) {
        Point point = this.chart.unpick(this, jCDataIndex.point, jCDataIndex.seriesIndex);
        return point;
    }

    public JCDataIndex coordToDataIndex(int n, int n2, int n3) {
        Point point = this.chart.getChartArea().getLocation();
        return this.chart.getChartArea().pick(new Point(n - point.x, n2 - point.y), this, n3);
    }

    public boolean is3DChartType() {
        return this.chartType == 9 || this.chartType == 10;
    }

    public int getNumSeries() {
        return this.series == null ? 0 : this.series.size();
    }

    public String toString() {
        String string = this.getName();
        return string == null ? JCChartBundle.string("com.klg.jclass.chart.Key142") : string;
    }

    void calcXMinMax(MinMax minMax) {
        this.step = Double.MAX_VALUE;
        int n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n);
            if (chartDataViewSeries.isIncluded()) {
                chartDataViewSeries.getXMinMax(minMax);
                chartDataViewSeries.calcStep(this);
            }
            ++n;
        }
        if (this.step != Double.MAX_VALUE && this.step != 0.0 && this.step < this.xaxis.step) {
            this.xaxis.step = this.step;
        }
        if (this.xaxis.step == Double.MAX_VALUE) {
            this.xaxis.step = 1.0;
        }
    }

    void calcYMinMax(MinMax minMax) {
        int n = 0;
        while (n < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n);
            if (chartDataViewSeries.isIncluded()) {
                chartDataViewSeries.getYMinMax(minMax);
            }
            ++n;
        }
    }

    private void calcYMinMaxOfTotals(MinMax minMax) {
        Point point = this.getFirstLast();
        if (point == null) {
            return;
        }
        int n = this.series.size();
        MinMax minMax2 = new MinMax();
        int n2 = point.x;
        while (n2 <= point.y) {
            MinMax minMax3 = new MinMax(0.0, 0.0);
            int n3 = 0;
            while (n3 < n) {
                double d;
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n3);
                if (chartDataViewSeries.isIncluded() && (d = chartDataViewSeries.getY(n2)) != this.holeValue) {
                    if (d >= 0.0) {
                        minMax3.max += d;
                    } else {
                        minMax3.min += d;
                    }
                }
                ++n3;
            }
            minMax2.union(minMax3);
            ++n2;
        }
        minMax.union(minMax2);
    }

    void getDataBounds(MinMax minMax, MinMax minMax2) {
        boolean bl;
        boolean bl2 = this.chartType == 2;
        boolean bl3 = this.chartType == 3 || this.chartType == 4;
        boolean bl4 = bl2 || bl3;
        boolean bl5 = bl = this.chartType == 6 || this.chartType == 7;
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            this.calcXMinMax(minMax);
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            this.calcYMinMax(minMax2);
        }
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            minMax.min = -1.7976931348623157E308;
            minMax.max = Double.MAX_VALUE;
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            minMax2.min = -1.7976931348623157E308;
            minMax2.max = Double.MAX_VALUE;
        }
        if (bl) {
            double d = JCChartUtil.abs(this.xaxis.getTickSpacing());
            minMax.min -= d;
            minMax.max += d;
        }
        if (!this.xaxis.min.isDefault && this.xaxis.min.value > minMax.min || this.xaxis.formula != null && this.xaxis.formula.getOriginator() != null && this.xaxis.min.value > minMax.min || bl4) {
            minMax.min = this.xaxis.min.value;
        }
        if (!this.xaxis.max.isDefault && this.xaxis.max.value < minMax.max || this.xaxis.formula != null && this.xaxis.formula.getOriginator() != null && this.xaxis.max.value < minMax.max || bl4) {
            minMax.max = this.xaxis.max.value;
        }
        if (!this.yaxis.min.isDefault && this.yaxis.min.value > minMax2.min || this.yaxis.formula != null && this.yaxis.formula.getOriginator() != null && this.yaxis.min.value > minMax2.min || bl4) {
            minMax2.min = this.yaxis.min.value;
        }
        if (bl2 && minMax2.min < 0.0) {
            if (JCChartUtil.abs(minMax2.min) > minMax2.max) {
                minMax2.max = JCChartUtil.abs(minMax2.min);
            }
            minMax2.min = 0.0;
        }
        if (!this.yaxis.max.isDefault && this.yaxis.max.value < minMax2.max || this.yaxis.formula != null && this.yaxis.formula.getOriginator() != null && this.yaxis.max.value < minMax2.max || bl4) {
            minMax2.max = this.yaxis.max.value;
        }
    }

    DoubleCoord getOrigin(MinMax minMax, MinMax minMax2, boolean bl) {
        DoubleCoord doubleCoord = new DoubleCoord(minMax.min, minMax2.min);
        if (!bl) {
            return doubleCoord;
        }
        int n = this.chart.getChartArea().getAngleUnit();
        if (this.xaxis.origin.isDefault) {
            if (this.chartType == 2 || this.chartType == 3 || this.chartType == 4) {
                switch (n) {
                    case 1: {
                        doubleCoord.x = 90.0;
                        break;
                    }
                    case 2: {
                        doubleCoord.x = 1.5707963267948966;
                        break;
                    }
                    case 3: {
                        doubleCoord.x = 100.0;
                    }
                }
            } else {
                switch (this.xaxis.originPlacement.value) {
                    case 3: {
                        doubleCoord.x = 0.0;
                        break;
                    }
                    case 1: {
                        doubleCoord.x = minMax.min;
                        break;
                    }
                    case 2: {
                        doubleCoord.x = minMax.max;
                        break;
                    }
                    case 0: {
                        doubleCoord.x = minMax.min <= 0.0 && minMax.max >= 0.0 ? 0.0 : minMax.min;
                    }
                }
            }
        } else {
            doubleCoord.x = JCChartUtil.boundAngle(n, this.xaxis.origin.value);
        }
        if (this.chartType == 10 || this.chartType == 12) {
            doubleCoord.y = this.yaxis.logarithmic ? JCChartUtil.max(minMax2.min, 0.0) : 0.0;
        } else if (this.chartType == 2 || this.chartType == 3 || this.chartType == 4) {
            doubleCoord.y = this.yaxis.reversed ? minMax2.min : minMax2.max;
        } else if (this.yaxis.origin.isDefault) {
            switch (this.yaxis.originPlacement.value) {
                case 3: {
                    doubleCoord.y = 0.0;
                    break;
                }
                case 1: {
                    doubleCoord.y = minMax2.min;
                    break;
                }
                case 2: {
                    doubleCoord.y = minMax2.max;
                    break;
                }
                case 0: {
                    doubleCoord.y = (this.chartType == 9 || this.chartType == 8) && !this.yaxis.logarithmic ? 0.0 : (minMax2.min <= 0.0 && minMax2.max >= 0.0 ? 0.0 : minMax2.min);
                }
            }
        } else {
            doubleCoord.y = this.yaxis.origin.value;
        }
        return doubleCoord;
    }

    void clearLimits() {
        if (this.xaxis != null) {
            this.xaxis.clearLimits();
        }
        if (this.yaxis != null) {
            this.yaxis.clearLimits();
        }
        this.xLimits = null;
        this.yLimits = null;
        this.xaxis.step = Double.MAX_VALUE;
        this.yaxis.step = Double.MAX_VALUE;
    }

    void calcLimits() {
        if (this.xaxis != null) {
            this.xLimits = new MinMax();
            this.calcXMinMax(this.xLimits);
            this.xaxis.setLimits(this.xLimits);
        }
        if (this.yaxis != null) {
            this.yLimits = new MinMax();
            boolean bl = false;
            switch (this.chartType) {
                case 10: {
                    bl = ((JCBarChartFormat)this.getChartFormat()).is100Percent();
                    break;
                }
                case 12: {
                    bl = ((JCAreaChartFormat)this.getChartFormat()).is100Percent();
                }
            }
            if (this.chartType == 10 || this.chartType == 12) {
                this.calcYMinMaxOfTotals(this.yLimits);
                if (bl) {
                    this.yLimits.min = this.yLimits.min < 0.0 ? -100.0 : 0.0;
                    this.yLimits.max = this.yLimits.max > 0.0 ? 100.0 : 0.0;
                }
            } else {
                this.calcYMinMax(this.yLimits);
            }
            this.yaxis.setLimits(this.yLimits);
        }
    }

    public MinMax getXLimits() {
        return this.xLimits;
    }

    public MinMax getYLimits() {
        return this.yLimits;
    }

    void getDataBoundValues(MinMax minMax, MinMax minMax2) {
        if (this.xLimits != null) {
            minMax.reset(this.xLimits);
        }
        if (this.yLimits != null) {
            minMax2.reset(this.yLimits);
        }
    }

    public boolean isChanged() {
        return this.getChanged();
    }

    public boolean isChanged(int n) {
        return this.getChanged(n);
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n) {
        return (this.changedFlag & n) == n;
    }

    protected void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void setChanged(boolean bl, int n) {
        this.changed = bl;
        if (!this.changed) {
            this.changedFlag = n;
            return;
        }
        this.changedFlag |= n;
        this.markAsChanged(n);
        this.propagateChange();
    }

    private void propagateChange() {
        if (!this.changed) {
            return;
        }
        if (this.isBatched()) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.chart.isBatched()) {
            return;
        }
        this.chart.update();
        this.setChanged(false, 0);
    }

    private void markAsChanged(int n) {
        int n2 = 0;
        if ((n & 0x80) > 0) {
            n2 |= 2;
        } else if ((n & 0x40) > 0) {
            n2 |= 1;
        }
        if (n2 != 0) {
            if (this.xaxis != null) {
                this.xaxis.setChanged(true, n2, false);
            }
            if (this.yaxis != null) {
                this.yaxis.setChanged(true, n2, false);
            }
        }
        if (this.chart != null && this.chart.getChartArea() != null) {
            this.chart.getChartArea().setChanged(true, n & 3, false);
        }
        int n3 = 0;
        if ((n & 0x20) > 0) {
            n3 |= 2;
        } else if ((n & 0x10) > 0) {
            n3 |= 1;
        }
        if (n3 != 0 && this.chart != null && this.chart.getLegend() != null) {
            this.chart.getLegend().setChanged(true, n3, false);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (this.changed == bl && (this.changedFlag & n) == n) {
            return;
        }
        if (bl2) {
            this.setChanged(bl, n);
        } else {
            this.changed = bl;
            if (this.changed) {
                this.changedFlag |= n;
                this.markAsChanged(n);
            } else {
                this.changedFlag = n;
            }
        }
    }

    public Point getFirstLast() {
        if (this.series == null) {
            return null;
        }
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n4);
            if (chartDataViewSeries.isVisible()) {
                int n5;
                if (n < chartDataViewSeries.getFirstPoint()) {
                    n = chartDataViewSeries.getFirstPoint();
                }
                if (n2 > chartDataViewSeries.getLastPoint()) {
                    n2 = chartDataViewSeries.getLastPoint();
                }
                if (n3 > (n5 = chartDataViewSeries.maxIndex())) {
                    n3 = n5;
                }
            }
            ++n4;
        }
        if (n3 == Integer.MAX_VALUE) {
            return null;
        }
        if (n > n3) {
            return null;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            return null;
        }
        return new Point(n, n2);
    }

    public int getVisibleDataSeries() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n2);
            if (chartDataViewSeries.isVisible()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void calcTransientData() {
        ChartDraw chartDraw;
        boolean bl;
        boolean bl2 = bl = this.getChartType() == 11;
        if (bl && (chartDraw = this.chart.getChartArea().getDrawable(this)) != null) {
            chartDraw.calcTransientData();
        }
    }

    public void setInverted(boolean bl) {
        int n = 0;
        if (this.inverted == bl) {
            return;
        }
        this.inverted = bl;
        if (this.xaxis != null) {
            this.xaxis.vertical = bl;
        }
        if (this.yaxis != null) {
            this.yaxis.vertical = !bl;
        }
        n = 130;
        if (this.chartType == 5 || this.chartType == 6 || this.chartType == 7) {
            n |= 0x20;
        }
        this.setChanged(true, n);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setPickFocus(int n) {
        this.pickFocus = n;
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.visibleInLegend) {
            return;
        }
        this.visibleInLegend = bl;
        this.setChanged(true, 32);
    }

    public boolean getAutoLabel() {
        return this.autoLabel;
    }

    public void setAutoLabel(boolean bl) {
        if (this.autoLabel == bl) {
            return;
        }
        this.autoLabel = bl;
        if (this.chart != null) {
            if (this.autoLabel) {
                this.chart.getChartLabelManager().generateAutoLabels(this);
            } else {
                this.chart.getChartLabelManager().removeAutoLabels(this);
            }
        }
        this.setChanged(true, 2);
    }

    public Color getOutlineColor() {
        if (this.outlineStyle == null) {
            if (this.chart != null && this.chart.getChartArea() != null) {
                return this.chart.getChartArea().getForeground();
            }
            return null;
        }
        return this.outlineStyle.getColor();
    }

    public void setOutlineColor(Color color) {
        if (this.outlineStyle == null) {
            this.outlineStyle = new JCLineStyle(1, color, 1);
        } else {
            if (this.outlineStyle.getColor() == color) {
                return;
            }
            this.outlineStyle.setColor(color);
        }
        this.setChanged(true, 34);
    }

    public int getOutlineWidth() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getWidth();
        }
        return 1;
    }

    public void setOutlineWidth(int n) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(n, color, 1);
        } else {
            if (this.outlineStyle.getWidth() == n) {
                return;
            }
            this.outlineStyle.setWidth(n);
        }
        this.setChanged(true, 34);
    }

    public int getOutlinePattern() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getPattern();
        }
        return 1;
    }

    public void setOutlinePattern(int n) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, n);
        } else {
            if (this.outlineStyle.getPattern() == n) {
                return;
            }
            this.outlineStyle.setPattern(n);
        }
        this.setChanged(true, 34);
    }

    public int getOutlineJoin() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getJoin();
        }
        return 0;
    }

    public void setOutlineJoin(int n) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, 1, 0, n);
        } else {
            if (this.outlineStyle.getJoin() == n) {
                return;
            }
            this.outlineStyle.setJoin(n);
        }
        this.setChanged(true, 34);
    }

    public int getOutlineCap() {
        if (this.outlineStyle != null) {
            return this.outlineStyle.getCap();
        }
        return 0;
    }

    public void setOutlineCap(int n) {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, 1, n, 0);
        } else {
            if (this.outlineStyle.getCap() == n) {
                return;
            }
            this.outlineStyle.setCap(n);
        }
        this.setChanged(true, 34);
    }

    public JCLineStyle getOutlineStyle() {
        if (this.outlineStyle == null) {
            Color color = Color.black;
            if (this.chart != null && this.chart.getChartArea() != null) {
                color = this.chart.getChartArea().getForeground();
            }
            this.outlineStyle = new JCLineStyle(1, color, 1);
        }
        return this.outlineStyle;
    }

    public void setOutlineStyle(JCLineStyle jCLineStyle) {
        this.outlineStyle = jCLineStyle;
        this.setChanged(true, 34);
    }

    public void setChartStyle(int n, JCChartStyle jCChartStyle) {
        if (n < 0 || n > this.styles.size()) {
            throw new IllegalArgumentException("Invalid ChartStyle index in ChartDataView.");
        }
        jCChartStyle.addParent(this);
        if (n < this.styles.size()) {
            this.styles.set(n, jCChartStyle);
        } else {
            this.styles.add(n, jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public JCChartStyle getChartStyle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("ChartStyle index must be positive");
        }
        if (n >= this.styles.size()) {
            while (n >= this.styles.size()) {
                this.styles.add(null);
            }
        }
        JCChartStyle[] jCChartStyleArray = new JCChartStyle[]{(JCChartStyle)this.styles.get(n)};
        if (jCChartStyleArray[0] == null) {
            JCChartStyle jCChartStyle = new JCChartStyle();
            jCChartStyleArray[0] = JCChartStyle.makeDefault(this.chart, this);
            this.styles.set(n, jCChartStyleArray[0]);
            jCChartStyle = null;
        }
        return jCChartStyleArray[0];
    }

    public List getChartStyle() {
        if (this.styles == null || this.styles.size() == 0) {
            return null;
        }
        return new Vector(this.styles);
    }

    public void setChartStyle(List list) {
        this.styles = new Vector();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JCChartStyle jCChartStyle = (JCChartStyle)iterator.next();
            jCChartStyle.addParent(this);
            this.styles.add(jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public void setColorHandler(JCDrawableColorHandler jCDrawableColorHandler) {
        if (this.colorHandler == jCDrawableColorHandler) {
            return;
        }
        this.colorHandler = jCDrawableColorHandler;
        this.setChanged(true, 33);
    }

    public JCDrawableColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public double[] getXArrayCopy() {
        if (this.xvalues == null) {
            return null;
        }
        double[] dArray = new double[this.xvalues.length];
        System.arraycopy(this.xvalues, 0, dArray, 0, this.xvalues.length);
        return dArray;
    }

    double[] getX() {
        return this.xvalues;
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.dataSource != null && this.dataSource instanceof ChartDataManageable) {
                ((ChartDataManageable)((Object)this.dataSource)).getChartDataManager().addChartDataListener(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    Object getTransientData() {
        return this.transientData;
    }

    void setTransientData(Object object) {
        this.transientData = object;
        if (this.chart != null && this.chart.getLegend() != null) {
            this.chart.getLegend().setChanged(true, 2, false);
        }
    }

    public int getNumSeriesPerData() {
        int n = 1;
        switch (this.chartType) {
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 7: {
                n = 4;
            }
        }
        return n;
    }

    public void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.setVisibleInLegend(bl);
        this.visible = bl;
        this.setChanged(true, 2);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void outputData(OutputStream outputStream) {
        String string = ChartDataSourceUtil.buildDataSourceString(this.getDataSource());
        if (string != null) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeBytes(string);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        this.changed = true;
        int n = this.changedFlag;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n;
    }

    protected DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new DataHandler(this);
        }
        return this.dataHandler;
    }

    protected static int[] getFirstLastPoints(ChartDataView chartDataView) {
        List list;
        if (chartDataView != null && (list = chartDataView.getSeries()) != null) {
            ChartDataViewSeries chartDataViewSeries = null;
            int n = Integer.MIN_VALUE;
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            while (n3 < list.size()) {
                chartDataViewSeries = (ChartDataViewSeries)list.get(n3);
                if (chartDataViewSeries != null && chartDataViewSeries.isVisible()) {
                    int n4 = chartDataViewSeries.getFirstPoint();
                    if (n4 > n) {
                        n = n4;
                    }
                    if ((n4 = chartDataViewSeries.getLastPoint()) < n2) {
                        n2 = n4;
                    }
                }
                ++n3;
            }
            int[] nArray = new int[]{n, n2};
            return nArray;
        }
        return null;
    }

    public boolean isUsingDoublePixels() {
        if (this.chart != null && this.chartType == 0 || this.chartType == 1) {
            return this.chart.isUsingDoublePixels();
        }
        return false;
    }
}

