/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.JCChart;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;

public class ChartRegion
extends JComponent
implements Changeable,
Serializable {
    protected boolean updateParent = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected Dimension preferredSize = null;
    protected CellRendererPane cellRendererPane = null;

    public ChartRegion() {
        this.cellRendererPane = new CellRendererPane();
        this.add(this.cellRendererPane);
    }

    public ChartRegion(JCChart jCChart) {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cellRendererPane = new CellRendererPane();
        this.add(this.cellRendererPane);
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.isOpaque()) {
            if (!graphics.getColor().equals(this.getBackground())) {
                graphics.setColor(this.getBackground());
            }
            Rectangle rectangle = this.getBounds();
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        rectangle.setBounds(insets.left, insets.top, Math.max(0, dimension.width - (insets.left + insets.right)), Math.max(0, dimension.height - (insets.top + insets.bottom)));
    }

    public CellRendererPane getCellRendererPane() {
        return this.cellRendererPane;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n) {
        return (this.changedFlag & n) == n;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n) {
        return this.getChanged(n);
    }

    public void setChanged(boolean bl, int n) {
        if (bl != this.getChanged() || !this.getChanged(n)) {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n) : n;
        }
        if (bl && this.getParent() != null && this.updateParent) {
            this.updateParent(n);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n);
        } else {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n) : n;
        }
    }

    public void updateParent(int n) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null) {
            if ((n & 2) > 0 || (n & 8) > 0) {
                jCChart.invalidate();
                if (!jCChart.isBatched()) {
                    jCChart.validate();
                    jCChart.repaint();
                }
            } else if ((n & 1) > 0 && !jCChart.isBatched()) {
                jCChart.repaint();
            }
        }
    }

    public boolean isBatched() {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        int n = this.changedFlag;
        this.changed = true;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n;
    }
}

