/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

class LogAxisHandler
extends AxisHandler {
    LogAxisHandler() {
    }

    double toData(int n) {
        if (this.parent.vertical) {
            n = this.parent.getHeight() - n;
        }
        return Math.pow(10.0, ((double)n - this.shift) / this.scale);
    }

    protected JCDataCoord toDataPolar(int n, int n2) {
        double d = (double)n - this.parent.polarAxisParams.xCenter;
        double d2 = (double)n2 - this.parent.polarAxisParams.yCenter;
        JCAxis jCAxis = this.getRadialAxis();
        if (jCAxis == null) {
            return null;
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Double.MAX_VALUE;
        d4 = jCAxis.isReversed() ? JCChartUtil.log10(jCAxis.max.value) - d3 / -this.scale : d3 / this.scale + JCChartUtil.log10(jCAxis.min.value);
        double d5 = Math.pow(10.0, d4);
        double d6 = this.calcThetaAngle(d, d2);
        return new JCDataCoord(d6, d5);
    }

    int toPixel(double d) {
        if (d <= 0.0) {
            d = this.parent.min.value;
        }
        int n = JCChartUtil.ifloor(this.scale * JCChartUtil.log10(d) + this.shift + 0.5);
        return this.parent.vertical ? this.parent.getHeight() - n : n;
    }

    double toPixelDouble(double d) {
        if (d <= 0.0) {
            d = this.parent.min.value;
        }
        double d2 = this.scale * JCChartUtil.log10(d) + this.shift;
        return this.parent.vertical ? (double)this.parent.getHeight() - d2 : d2;
    }

    protected Point toPixelPolar(double d, double d2, boolean bl) {
        JCDataCoord jCDataCoord;
        double d3;
        JCAxis jCAxis;
        if (bl) {
            JCAxis jCAxis2 = jCAxis = this.parent.vertical ? this.parent : this.parent.otherAxis;
            d2 = jCAxis.isReversed() ? (d2 > 0.0 && jCAxis.max.value > 0.0 ? JCChartUtil.log10(jCAxis.max.value) - JCChartUtil.log10(d2) : 0.0) : (d2 > 0.0 && jCAxis.min.value > 0.0 ? JCChartUtil.log10(d2) - JCChartUtil.log10(jCAxis.min.value) : 0.0);
        }
        JCAxis jCAxis3 = jCAxis = this.parent.vertical ? this.parent.otherAxis : this.parent;
        if (jCAxis.isReversed()) {
            d *= -1.0;
        }
        int n = (d3 = (jCDataCoord = this.toScreenLocationPolar(d, d2, bl)).getX()) < this.parent.polarAxisParams.xCenter ? (int)Math.ceil(d3) : (int)Math.round(d3);
        d3 = jCDataCoord.getY();
        int n2 = d3 < this.parent.polarAxisParams.yCenter ? (int)Math.ceil(d3) : (int)Math.round(d3);
        return new Point(n, n2);
    }

    void calcParams() {
        if ((this.parent.isPolar() || this.parent.isRadar()) && !this.parent.vertical) {
            return;
        }
        double d = this.parent.dataLimits == null ? 1.0 : this.parent.dataLimits.min;
        double d2 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        d = this.parent.min.isDefault ? d : this.parent.min.value;
        d2 = this.parent.max.isDefault ? d2 : this.parent.max.value;
        n = JCChartUtil.ifloor(JCChartUtil.log10(d));
        n2 = JCChartUtil.iceil(JCChartUtil.log10(d2));
        do {
            this.calcPrecision();
        } while (this.fixBounds());
        if (this.parent.vertical) {
            if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
                if (this.parent.chartType == 9 || this.parent.chartType == 10 || this.parent.chartType == 12 || this.parent.chartType == 8) {
                    --n;
                }
            } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
                n5 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
                if (n5 < n && this.parent.min.isDefault) {
                    n = n5;
                }
                if (n5 > n2 && this.parent.max.isDefault) {
                    n2 = n5;
                }
            }
        } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
            n5 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
            if (n5 < n && this.parent.min.isDefault) {
                n = n5;
            }
            if (n5 > n2 && this.parent.max.isDefault) {
                n2 = n5;
            }
        }
        int n7 = 0;
        Dimension dimension = new Dimension();
        int n8 = this.parent.isPolar() || this.parent.isRadar() ? (int)Math.round(this.parent.polarAxisParams.radius) : this.parent.pixelLength();
        n6 = 1;
        while (n6 <= 5) {
            n3 = n;
            n4 = n2;
            boolean bl = JCChartUtil.abs(n4) > JCChartUtil.abs(n3);
            while ((n4 - n3) % n6 != 0) {
                if (bl) {
                    ++n4;
                } else {
                    --n3;
                }
                boolean bl2 = bl = !bl;
            }
            this.getAnnoExtent(dimension, n4, this.parent.getPrecision());
            this.getAnnoExtent(dimension, n3, this.parent.getPrecision());
            if (this.parent.vertical) {
                n7 = this.parent.annotationRotation == 0 ? dimension.height * 2 : dimension.width + dimension.width / 2;
            } else {
                int n9 = n7 = this.parent.annotationRotation == 0 ? dimension.width + dimension.width / 2 : dimension.height * 2;
            }
            if ((n4 - n3) / n6 * n7 < n8) break;
            ++n6;
        }
        if (n6 <= 5) {
            this.parent.logIncrement = n6;
        } else {
            n3 = n;
            n4 = n2;
            this.parent.logIncrement = Math.max(n4 - n3, 1);
        }
        if (this.parent.min.isDefault) {
            this.parent.min.value = JCChartUtil.pow10(n3);
        }
        if (this.parent.max.isDefault) {
            this.parent.max.value = JCChartUtil.pow10(n4);
        }
        if (this.parent.vertical && (this.parent.chartType == 2 || this.parent.chartType == 3 || this.parent.chartType == 4)) {
            this.parent.origin.value = this.parent.max.value;
        } else if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
            switch (this.parent.originPlacement.value) {
                case 2: {
                    this.parent.origin.value = this.parent.max.value;
                    break;
                }
                case 0: 
                case 1: 
                case 3: {
                    this.parent.origin.value = this.parent.min.value;
                }
            }
        }
        if (this.parent.vertical) {
            this.parent.setSize(n7 + 1 + this.parent.tickLength / 2, this.parent.getHeight());
        } else {
            this.parent.setSize(this.parent.getWidth(), dimension.height + 1 + this.parent.tickLength / 2);
        }
    }

    void calcPrecision() {
        if (this.parent.precision.isDefault) {
            if (this.parent.annotationMethod == 2 || this.parent.dataLimits == null) {
                this.parent.precision.value = 0;
            } else {
                double d;
                double d2 = JCChartUtil.log10(this.parent.min.isDefault ? this.parent.dataLimits.min : this.parent.min.value);
                if (d2 == Double.NEGATIVE_INFINITY) {
                    d2 = 0.0;
                }
                if ((d = JCChartUtil.log10(this.parent.max.isDefault ? this.parent.dataLimits.max : this.parent.max.value)) == Double.NEGATIVE_INFINITY) {
                    d = 0.0;
                }
                this.parent.precision.value = d <= d2 ? JCChartUtil.nicePrecision(Math.abs(d)) : JCChartUtil.nicePrecision(d - d2);
            }
        }
        int n = JCChartUtil.clamp(this.parent.getPrecision(), -this.parent.getMaxPrecision(), this.parent.getMaxPrecision());
        this.parent.setPrecisionInternal(n);
    }

    void calcTransformation() {
        int n = this.parent.isPolarRadar() && this.parent.vertical ? (int)Math.rint(this.parent.polarAxisParams.radius) : this.parent.pixelLength();
        int n2 = this.parent.pixelStart();
        double d = JCChartUtil.log10(this.parent.min.value);
        double d2 = JCChartUtil.log10(this.parent.max.value);
        double d3 = JCChartUtil.calcError(this.parent.getPrecision());
        if (this.parent.reversed) {
            n = -n;
        }
        if (Math.abs(d2 - d) < d3) {
            this.scale = 1.0;
            this.shift = 0.0;
            return;
        }
        this.scale = (double)n / (d2 - d);
        this.shift = n < 0 ? (double)n2 - d2 * this.scale : (double)n2 - d * this.scale;
    }

    boolean fixBounds() {
        String string;
        boolean bl = super.fixBounds();
        if (!this.parent.max.isDefault && this.parent.max.value <= 0.0) {
            string = JCChartBundle.string("com.klg.jclass.chart.Key104");
            string = string + JCChartBundle.string("com.klg.jclass.chart.Key130");
            ErrorDialog.raise(this.parent, string);
            this.parent.max.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && this.parent.min.value <= 0.0) {
            string = JCChartBundle.string("com.klg.jclass.chart.Key106");
            string = string + JCChartBundle.string("com.klg.jclass.chart.Key132");
            ErrorDialog.raise(this.parent, string);
            this.parent.min.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && !this.parent.max.isDefault) {
            double d = JCChartUtil.log10(this.parent.min.value);
            double d2 = JCChartUtil.log10(this.parent.max.value);
            if (d2 - d < Double.MIN_VALUE) {
                string = JCChartBundle.string("com.klg.jclass.chart.Key7");
                string = string + JCChartBundle.string("com.klg.jclass.chart.Key130");
                ErrorDialog.raise(this.parent, string);
                this.parent.max.isDefault = true;
                bl = true;
            }
        }
        return bl;
    }

    void drawTicks(Graphics graphics) {
        if (this.parent.annotationMethod != 0 && this.parent.tickSpacing.isDefault) {
            super.drawTicks(graphics);
            return;
        }
        int n = this.parent.linePosition();
        double d = this.parent.max.value;
        double d2 = this.parent.min.value;
        if (d <= 0.0) {
            d = 1.0;
            d2 = 0.1;
        } else {
            d2 = this.parent.min.value > 0.0 ? this.parent.min.value : d / 10.0;
        }
        int n2 = JCChartUtil.ifloor(JCChartUtil.log10(d2));
        int n3 = JCChartUtil.iceil(JCChartUtil.log10(d));
        int n4 = n2;
        while (n4 <= n3) {
            double d3 = JCChartUtil.pow10(n4);
            int n5 = 1;
            while (n5 < 10) {
                double d4 = (double)n5 * d3;
                if (!(d4 < this.parent.min.value) && !(d4 > this.parent.max.value)) {
                    this.drawTickMark(graphics, d4, n);
                }
                ++n5;
            }
            ++n4;
        }
    }

    String format(double d, int n) {
        return JCChartUtil.logFormat((int)d);
    }

    double range() {
        int n = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.min.value));
        int n2 = JCChartUtil.iceil(JCChartUtil.log10(this.parent.max.value));
        return n2 - n;
    }

    void translate(double d) {
        double d2 = JCChartUtil.log10(this.parent.min.value);
        double d3 = JCChartUtil.log10(this.parent.max.value);
        if (this.parent.reversed) {
            d = -d;
        }
        this.parent.min.value = Math.pow(10.0, d2 + d);
        this.parent.max.value = Math.pow(10.0, d3 + d);
    }
}

