/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaChartDraw;
import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDrawUtil;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class SAreaChartDraw
extends AreaChartDraw {
    double[] ytotal;
    double[] ysum;
    double[] ysum_neg;
    double[][] ywork;
    JCAreaChartFormat areaFormat;
    boolean editInverted = false;

    public void recalc(int n, int n2, int n3) {
        this.areaFormat = (JCAreaChartFormat)this.dataObject.getChartFormat();
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.yaxis = this.dataObject.getYAxis();
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        int n4 = this.seriesList.size();
        if (n4 == 0 || this.firstLast == null) {
            return;
        }
        int n5 = this.firstLast.y - this.firstLast.x + 1;
        this.ytotal = new double[n5];
        this.ysum = new double[n5];
        this.ysum_neg = new double[n5];
        this.ywork = new double[n4][n5];
        ChartDrawUtil.calcStackingInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.seriesList, this.areaFormat.is100Percent(), this.holeValue, this.yaxis.dataLimits, this.yaxis);
        super.recalc(n, n2, n3);
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        return this.ywork[chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries)];
    }

    public void draw(Graphics graphics, int n, int n2, boolean bl) {
        super.draw(graphics, n, n2, false);
    }

    public JCDataIndex pick(Point point, int n) {
        return this.pick(point, n, true);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        this.editInverted = jCDataIndex.dataView.getXAxis().vertical;
        super.startEdit(jCDataIndex);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        int n3 = this.yaxis.toPixel(jCDataIndex.series.getY(jCDataIndex.point), this.drawFront);
        int n4 = this.yaxis.toPixel(this.ywork[jCDataIndex.series.getDrawingOrder()][jCDataIndex.point - this.firstLast.x], this.drawFront);
        int n5 = this.editInverted ? n - this.r.x - n4 : n4 - (n2 - this.r.y);
        int n6 = this.editInverted ? n3 + n5 : n3 - n5;
        return n6;
    }

    protected void defineAreaShapes(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, boolean bl, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        int n = (areaPolygon.endPoint - areaPolygon.startPoint + 1) * 2;
        int n2 = areaPolygon.startPoint;
        while (n2 < areaPolygon.endPoint) {
            Polygon polygon;
            int n3;
            double d;
            int n4;
            int n5;
            double d2;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            if (!bl) {
                n11 = areaPolygon.poly.xpoints[n2 - areaPolygon.startPoint + 1];
                n10 = areaPolygon.poly.ypoints[n2 - areaPolygon.startPoint + 1];
                n9 = areaPolygon.poly.xpoints[n2 - areaPolygon.startPoint + 2];
                n8 = areaPolygon.poly.ypoints[n2 - areaPolygon.startPoint + 2];
                n7 = areaPolygon.poly.ypoints[n - (n2 - areaPolygon.startPoint)];
                n6 = areaPolygon.poly.ypoints[n - (n2 - areaPolygon.startPoint) - 1];
                d2 = (double)(n8 - n10) / (double)(n9 - n11);
                n5 = n11 + (int)((double)(n9 - n11) / 2.0);
                n4 = n10 - (int)(d2 * (double)(n11 - n5));
                d = (double)(n6 - n7) / (double)(n9 - n11);
                n3 = n7 - (int)(d * (double)(n11 - n5));
                polygon = new Polygon();
                polygon.addPoint(n11, n7);
                polygon.addPoint(n11, n10);
                polygon.addPoint(n5, n4);
                polygon.addPoint(n5, n3);
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
                polygon = new Polygon();
                polygon.addPoint(n5, n3);
                polygon.addPoint(n5, n4);
                polygon.addPoint(n9, n8);
                polygon.addPoint(n9, n6);
                defineShape.beginShape(new JCDataIndex(n2 + 1, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
            } else {
                n11 = areaPolygon.poly.xpoints[n2 - areaPolygon.startPoint + 1];
                n10 = areaPolygon.poly.ypoints[n2 - areaPolygon.startPoint + 1];
                n9 = areaPolygon.poly.xpoints[n2 - areaPolygon.startPoint + 2];
                n8 = areaPolygon.poly.ypoints[n2 - areaPolygon.startPoint + 2];
                n7 = areaPolygon.poly.xpoints[n - (n2 - areaPolygon.startPoint)];
                n6 = areaPolygon.poly.xpoints[n - (n2 - areaPolygon.startPoint) - 1];
                d2 = (double)(n9 - n11) / (double)(n8 - n10);
                n5 = n10 + (int)((double)(n8 - n10) / 2.0);
                n4 = n11 - (int)(d2 * (double)(n10 - n5));
                d = (double)(n6 - n7) / (double)(n8 - n10);
                n3 = n7 - (int)(d * (double)(n10 - n5));
                polygon = new Polygon();
                polygon.addPoint(n7, n10);
                polygon.addPoint(n11, n10);
                polygon.addPoint(n4, n5);
                polygon.addPoint(n3, n5);
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
                polygon = new Polygon();
                polygon.addPoint(n3, n5);
                polygon.addPoint(n4, n5);
                polygon.addPoint(n9, n8);
                polygon.addPoint(n6, n8);
                defineShape.beginShape(new JCDataIndex(n2 + 1, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
            }
            ++n2;
        }
    }
}

