/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.swing.encode.JCEncodeComponent;
import com.klg.jclass.util.swing.encode.JPEGEncoder;
import java.awt.Graphics;
import java.awt.Image;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JPanel;

public class ServerJPanel
extends JPanel
implements ServerRenderable {
    private Graphics prevSetGraphics = null;

    public void addNotify() {
        super.addNotify();
    }

    public void snapshot(Image image) {
        ServerRenderer.snapshot(this, image);
    }

    public FileOutputStream createFileStream(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return fileOutputStream;
    }

    public void encodeToGIFFile(String string) {
        FileOutputStream fileOutputStream = this.createFileStream(string);
        if (fileOutputStream != null) {
            this.encodeAsGIF(fileOutputStream);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void encodeToPNGFile(String string) {
        FileOutputStream fileOutputStream = this.createFileStream(string);
        if (fileOutputStream != null) {
            this.encodeAsPNG(fileOutputStream);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void encodeToJPEGFile(String string) {
        FileOutputStream fileOutputStream = this.createFileStream(string);
        if (fileOutputStream != null) {
            this.encodeAsJPEG(fileOutputStream);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void encodeToJPEGFile(String string, float f) {
        FileOutputStream fileOutputStream = this.createFileStream(string);
        if (fileOutputStream != null) {
            this.encodeAsJPEG(fileOutputStream, f);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void encodeAsGIF(OutputStream outputStream) {
        this.encode(JCEncodeComponent.GIF, outputStream);
    }

    public void encodeAsPNG(OutputStream outputStream) {
        this.encode(JCEncodeComponent.PNG, outputStream);
    }

    public void encodeAsJPEG(OutputStream outputStream) {
        this.encode(JCEncodeComponent.JPEG, outputStream);
    }

    public void encodeAsJPEG(OutputStream outputStream, float f) {
        Image image = this.snapshot();
        JPEGEncoder jPEGEncoder = new JPEGEncoder();
        jPEGEncoder.setQuality(f);
        try {
            jPEGEncoder.saveImage(image, outputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void encode(JCEncodeComponent.Encoding encoding, OutputStream outputStream) {
        Image image = this.snapshot();
        this.encodeImage(encoding, image, outputStream);
    }

    public void encodeImage(JCEncodeComponent.Encoding encoding, Image image, OutputStream outputStream) {
        try {
            JCEncodeComponent.encode(encoding, image, outputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Image snapshot() {
        return this.snapshot(2);
    }

    public Image snapshot(int n) {
        Image image = ServerRenderer.createNewImage(this, n);
        ServerRenderer.snapshot(this, image);
        return image;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void serverPaint(Graphics graphics) {
        ServerRenderer.paintTopLevelContainer(graphics, this);
    }

    public void setUsingDoublePixels(boolean bl) {
    }

    public boolean isUsingDoublePixels() {
        return false;
    }
}

