/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.swing.JCElastic;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;

public class JCElasticLayout
implements LayoutManager2,
Serializable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final JCElastic HORIZONTALLY_ELASTIC_CONSTRAINT = new Elastic(1, 0);
    public static final JCElastic VERTICALLY_ELASTIC_CONSTRAINT = new Elastic(0, 1);
    public static final JCElastic COMPLETELY_ELASTIC_CONSTRAINT = new Elastic(1, 1);
    public static final String HORIZONTALLY_ELASTIC_TAG = "HorizontallyElastic";
    public static final String VERTICALLY_ELASTIC_TAG = "VerticallyElastic";
    public static final String COMPLETELY_ELASTIC_TAG = "CompletelyElastic";
    protected static final int NOT_ELASTIC = 0;
    protected static final int VERTICALLY_ELASTIC = 1;
    protected static final int HORIZONTALLY_ELASTIC = 2;
    protected int alignment;
    protected int orientation;
    protected HashMap constraintMap = new HashMap();
    protected static HashMap constraintCache = null;

    public static JCElastic createElasticConstraint(int n, int n2) {
        Elastic elastic;
        if (constraintCache == null) {
            constraintCache = new HashMap();
        }
        if (constraintCache.containsKey(elastic = new Elastic(n, n2))) {
            return (JCElastic)constraintCache.get(elastic);
        }
        constraintCache.put(elastic, elastic);
        return elastic;
    }

    public JCElasticLayout(int n) {
        this(n, n == 1 ? 2 : 1);
    }

    public JCElasticLayout(int n, int n2) {
        this.orientation = n;
        if (n2 != 2 && n2 != 1 && n2 != 0 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("Incorrect value; use one of: SwingConstants.LEFT, SwingConstants.CENTER, SwingConstants.RIGHT");
        }
        this.alignment = n2;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals(HORIZONTALLY_ELASTIC_TAG)) {
            this.addLayoutComponent(component, HORIZONTALLY_ELASTIC_CONSTRAINT);
        } else if (string.equals(VERTICALLY_ELASTIC_TAG)) {
            this.addLayoutComponent(component, VERTICALLY_ELASTIC_CONSTRAINT);
        } else if (string.equals(COMPLETELY_ELASTIC_TAG)) {
            this.addLayoutComponent(component, COMPLETELY_ELASTIC_CONSTRAINT);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.constraintMap.containsKey(component)) {
            this.constraintMap.remove(component);
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        this.getPreferredLayoutSize(container, dimension);
        return dimension;
    }

    protected int getPreferredLayoutSize(Container container, Dimension dimension) {
        int n;
        int n2 = container.getComponentCount();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.orientation == 1) {
            n = 0;
            while (n < n2) {
                Component component = container.getComponent(n);
                Dimension dimension2 = component.getPreferredSize();
                n3 = Math.max(n3, dimension2.width);
                n4 += dimension2.height;
                n5 = this.getElasticity(component);
                if (n5 != 0) {
                    n6 += n5;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < n2) {
                Component component = container.getComponent(n);
                Dimension dimension3 = component.getPreferredSize();
                n4 = Math.max(n4, dimension3.height);
                n3 += dimension3.width;
                n5 = this.getElasticity(component);
                if (n5 != 0) {
                    n6 += n5;
                }
                ++n;
            }
        }
        Insets insets = container.getInsets();
        n3 = n3 + insets.right + insets.left;
        n4 = n4 + insets.top + insets.bottom;
        if (dimension != null) {
            dimension.width = n3;
            dimension.height = n4;
        }
        return n6;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        if (this.orientation == 1) {
            int n4 = 0;
            while (n4 < n) {
                Component component = container.getComponent(n4);
                Dimension dimension = component.getMinimumSize();
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                Component component = container.getComponent(n5);
                Dimension dimension = component.getMinimumSize();
                n3 = Math.max(n3, dimension.height);
                n2 += dimension.width;
                ++n5;
            }
        }
        return new Dimension(n2, n3);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        Dimension dimension = new Dimension();
        int n4 = this.getPreferredLayoutSize(container, dimension);
        Dimension dimension2 = container.getSize();
        Insets insets = container.getInsets();
        dimension2.height -= insets.bottom;
        dimension2.width -= insets.right;
        dimension.height -= insets.bottom;
        dimension.width -= insets.right;
        if (this.orientation == 1) {
            n3 = dimension2.height - dimension.height;
            n2 = insets.left;
            n = insets.top;
        } else {
            n3 = dimension2.width - dimension.width;
            n2 = insets.top;
            n = insets.left;
        }
        int n5 = 0;
        int n6 = 0;
        if (n4 > 0) {
            n5 = n3 / n4;
            n6 = n3 % n4;
        }
        int n7 = container.getComponentCount();
        int n8 = n;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n7) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            Component component = container.getComponent(n10);
            int n16 = 0;
            if (this.orientation == 1) {
                n15 = dimension2.width - n2;
                n14 = dimension2.height - n;
                n13 = component.getMaximumSize().width;
                if (n13 < 0) {
                    n13 = component.getPreferredSize().width;
                }
                n12 = component.getPreferredSize().height;
            } else {
                n15 = dimension2.height - n2;
                n14 = dimension2.width - n;
                n13 = component.getMaximumSize().height;
                if (n13 < 0) {
                    n13 = component.getPreferredSize().height;
                }
                n12 = component.getPreferredSize().width;
            }
            n16 = Math.min(n15, n13);
            int n17 = n2;
            if (n16 != n15) {
                if (this.isDim1Elastic(component)) {
                    n17 = 0;
                    n16 = n15;
                } else if (this.alignment == 2 || this.alignment == 1) {
                    n17 = 0;
                } else if (this.alignment == 0) {
                    n17 = (n15 - n16) / 2;
                } else if (this.alignment == 4 || this.alignment == 3) {
                    n17 = n15 - n16;
                }
            }
            if ((n11 = this.getElasticity(component)) > 0) {
                int n18 = this.calcStretch(n5, n11, n9, n6);
                if (this.orientation == 1) {
                    component.setBounds(n17, n8, n16, n12 + n18);
                } else {
                    component.setBounds(n8, n17, n12 + n18, n16);
                }
                n9 += n11;
                n8 += n12 + n18;
            } else {
                if (this.orientation == 1) {
                    component.setBounds(n17, n8, n16, n12);
                } else {
                    component.setBounds(n8, n17, n12, n16);
                }
                n8 += n12;
            }
            ++n10;
        }
    }

    protected int calcStretch(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3;
        while (n6 < n3 + n2) {
            n5 += n + (n6 < n4 ? 1 : 0);
            ++n6;
        }
        return n5;
    }

    protected boolean isDim1Elastic(Component component) {
        if (this.orientation == 1) {
            return this.isHorizontallyElastic(component);
        }
        return this.isVerticallyElastic(component);
    }

    protected JCElastic getElastic(Component component) {
        JCElastic jCElastic = null;
        if (component instanceof JCElastic) {
            jCElastic = (JCElastic)((Object)component);
        } else {
            Object v = this.constraintMap.get(component);
            if (v != null && v instanceof JCElastic) {
                jCElastic = (JCElastic)v;
            }
        }
        return jCElastic;
    }

    protected boolean isVerticallyElastic(Component component) {
        JCElastic jCElastic = this.getElastic(component);
        return jCElastic != null && jCElastic.getVerticalElasticity() != 0;
    }

    protected boolean isHorizontallyElastic(Component component) {
        JCElastic jCElastic = this.getElastic(component);
        return jCElastic != null && jCElastic.getHorizontalElasticity() != 0;
    }

    protected int getElasticity(Component component) {
        int n = 0;
        JCElastic jCElastic = this.getElastic(component);
        if (jCElastic != null) {
            if (this.orientation == 0) {
                n = jCElastic.getHorizontalElasticity();
            } else if (this.orientation == 1) {
                n = jCElastic.getVerticalElasticity();
            }
        }
        return n;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof JCElastic)) {
            throw new IllegalArgumentException("constraint must be null or an instance of JCElastic");
        }
        this.constraintMap.put(component, object);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getMaximumSize();
            if (this.orientation == 1) {
                n2 = Math.max(n2, dimension.width);
                n3 += dimension.height;
            } else {
                n3 = Math.max(n3, dimension.height);
                n2 += dimension.width;
            }
            ++n4;
        }
        return new Dimension(n2, n3);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void invalidateLayout(Container container) {
    }

    static class Elastic
    implements JCElastic,
    Serializable {
        protected int horizontal;
        protected int vertical;

        public Elastic(int n, int n2) {
            this.horizontal = n;
            this.vertical = n2;
        }

        public int getHorizontalElasticity() {
            return this.horizontal;
        }

        public int getVerticalElasticity() {
            return this.vertical;
        }
    }
}

