/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.JCSpinBoxEditor;
import com.klg.jclass.util.value.AbstractValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class JCSpinNumberBox
extends AbstractSpinBox {
    public static final int INTEGER = 1;
    public static final int FLOATING_POINT = 2;
    protected int operation = 1;
    protected NumberFormat format = NumberFormat.getNumberInstance();
    protected Number step = new Integer(1);
    protected Number max = new Long(Long.MAX_VALUE);
    protected Number min = new Long(Long.MIN_VALUE);
    static /* synthetic */ Class class$java$lang$Number;

    public JCSpinNumberBox() {
        this.setEditor(new NumberEditor());
        this.setValueModel(new NumberModel());
    }

    public void setOperation(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("operation must be one of INTEGER or FLOATING_POINT");
        }
        if (this.operation == n) {
            return;
        }
        int n2 = this.operation;
        this.operation = n;
        this.firePropertyChange("operation", n2, n);
    }

    public int getOperation() {
        return this.operation;
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setSpinStep(Number number) {
        this.step = number;
    }

    public Number getSpinStep() {
        return this.step;
    }

    public void setValue(Number number) {
        if (number != null && (this.compare(number, this.max) > 0 || this.compare(number, this.min) < 0)) {
            return;
        }
        Number number2 = (Number)this.valueModel.getValue();
        if (number2 != null && this.compare(number, number2) == 0) {
            return;
        }
        this.valueModel.setValue(number);
    }

    public Number getValue() {
        return (Number)this.valueModel.getValue();
    }

    public void setValueRange(Number number, Number number2) {
        if (this.compare(number, number2) > 0) {
            throw new IllegalArgumentException("Min must be less than Max");
        }
        this.max = number2;
        this.min = number;
    }

    public void setValueRange(Range range) {
        this.setValueRange(range.min, range.max);
    }

    public Number getMaximumValue() {
        return this.max;
    }

    public Number getMinimumValue() {
        return this.min;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("NumberFormat must be non-null");
        }
        this.format = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    protected void checkArrowButtons() {
        Number number = (Number)this.valueModel.getValue();
        Number number2 = (Number)this.spinUp();
        if (this.compare(number2, this.max) > 0) {
            this.setArrowEnabled(this.upArrow, false);
        } else {
            this.setArrowEnabled(this.upArrow, true);
        }
        number2 = (Number)this.spinDown();
        if (this.compare(number2, this.min) < 0) {
            this.setArrowEnabled(this.downArrow, false);
        } else {
            this.setArrowEnabled(this.downArrow, true);
        }
    }

    protected String format(Number number) {
        if (number == null) {
            return "";
        }
        String string = "";
        string = this.operation == 1 ? this.format.format(number.longValue()) : this.format.format(number.doubleValue());
        return string;
    }

    protected Number parse(String string) {
        Number number = null;
        if (this.operation == 1) {
            this.format.setParseIntegerOnly(true);
        } else {
            this.format.setParseIntegerOnly(false);
        }
        try {
            number = this.format.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return number;
    }

    protected int preferredWidthOfView() {
        int n = 0;
        if (this.isEditable()) {
            Component component = this.editor.getEditorComponent();
            this.editor.setItem(this.max);
            n = component.getPreferredSize().width;
            this.editor.setItem(this.min);
            n = Math.max(n, component.getPreferredSize().width);
            if (this.operation == 2) {
                this.editor.setItem(new Double(this.min.doubleValue() + this.step.doubleValue()));
                n = Math.max(n, component.getPreferredSize().width);
                this.editor.setItem(new Double(this.max.doubleValue() - this.step.doubleValue()));
                n = Math.max(n, component.getPreferredSize().width);
            }
            this.editor.setItem(this.getValue());
        } else {
            Component component = this.renderer.getComponent(this, this.max);
            n = component.getPreferredSize().width;
            this.renderer.getComponent(this, this.min);
            n = Math.max(n, component.getPreferredSize().width);
            if (this.operation == 2) {
                this.renderer.getComponent(this, new Double(this.min.doubleValue() + this.step.doubleValue()));
                n = Math.max(n, component.getPreferredSize().width);
                this.renderer.getComponent(this, new Double(this.max.doubleValue() - this.step.doubleValue()));
                n = Math.max(n, component.getPreferredSize().width);
            }
            this.renderer.getComponent(this, this.getValue());
        }
        return n += JCEnvironment.isWorking("MotifPreferedWidthAjustment");
    }

    protected Object spinUp() {
        Number number = (Number)this.valueModel.getValue();
        Number number2 = null;
        if (number == null) {
            number2 = this.step;
        } else if (this.operation == 1) {
            long l = number.longValue() + this.step.longValue();
            number2 = new Long(l);
        } else {
            double d = number.doubleValue() + this.step.doubleValue();
            number2 = new Double(d);
        }
        return number2;
    }

    protected Object spinDown() {
        Number number = (Number)this.valueModel.getValue();
        Number number2 = null;
        if (number == null) {
            number2 = this.step;
        } else if (this.operation == 1) {
            long l = number.longValue() - this.step.longValue();
            number2 = new Long(l);
        } else {
            double d = number.doubleValue() - this.step.doubleValue();
            number2 = new Double(d);
        }
        return number2;
    }

    protected void processValueChanged(JCValueEvent jCValueEvent) {
        this.editor.setItem(jCValueEvent.getNewValue());
        this.renderer.getComponent(this, jCValueEvent.getNewValue());
        super.processValueChanged(jCValueEvent);
    }

    protected int compare(Number number, Number number2) {
        double d;
        if (number == null) {
            if (number2 == null) {
                return 0;
            }
            return -1;
        }
        if (number2 == null) {
            return 1;
        }
        if (this.operation == 1) {
            long l;
            long l2 = number.longValue();
            return l2 < (l = number2.longValue()) ? -1 : (l2 == l ? 0 : 1);
        }
        double d2 = number.doubleValue();
        return d2 < (d = number2.doubleValue()) ? -1 : (d2 == d ? 0 : 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class NumberModel
    extends AbstractValueModel
    implements JCValueModel,
    Serializable {
        NumberModel() {
        }

        public Class getValueClass() {
            return class$java$lang$Number == null ? (class$java$lang$Number = JCSpinNumberBox.class$("java.lang.Number")) : class$java$lang$Number;
        }
    }

    class NumberEditor
    extends JTextField
    implements JCSpinBoxEditor {
        NumberEditor() {
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            if (object == null) {
                this.setText("");
            } else {
                this.setText(JCSpinNumberBox.this.format((Number)object));
            }
        }

        public Object getItem() {
            return JCSpinNumberBox.this.parse(this.getText());
        }
    }

    public static class Range
    implements Serializable {
        public Number min;
        public Number max;

        public Range(Number number, Number number2) {
            this.max = number2;
            this.min = number;
        }
    }
}

