/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class JPEGEncoder
extends AbstractImageEncoder {
    public float quality = 1.0f;

    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        Object object;
        BufferedImage bufferedImage;
        if (image == null) {
            this.error("JPEG encoding error: Image is NULL.");
        }
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() != 2) {
            bufferedImage = (BufferedImage)image;
        } else {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            object = bufferedImage.createGraphics();
            ((Graphics)object).drawImage(image, 0, 0, null);
        }
        try {
            object = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
            JPEGEncodeParam jPEGEncodeParam = object.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(this.quality, false);
            object.setJPEGEncodeParam(jPEGEncodeParam);
            object.encode(bufferedImage);
        }
        catch (Exception exception) {
            this.error("JPEG encoding error : " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.quality = f;
    }
}

