/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego;

import com.openit.lego.logging.Logger;
import java.util.StringTokenizer;
import java.util.Vector;

public final class StringUtils {
    public static String[] split(String inString) {
        return StringUtils.split(inString, " \t\r\n\f");
    }

    public static String[] split(String inString, char delim) {
        return StringUtils.split(inString, "" + delim);
    }

    public static String[] split(String inString, String delim) {
        Logger.trace("Splitting String: '" + inString + "'; using delimiter: '" + delim + "'");
        if (inString == null) {
            return null;
        }
        StringTokenizer parser = new StringTokenizer(inString, delim);
        String[] splitStrings = new String[parser.countTokens()];
        int i = 0;
        while (parser.hasMoreTokens()) {
            splitStrings[i] = parser.nextToken();
            ++i;
        }
        return splitStrings;
    }

    public static final int[] splitToInt(String inString) {
        return StringUtils.splitToInt(inString, ',');
    }

    public static final Integer[] splitToInteger(String inString) {
        if (inString == null) {
            return null;
        }
        int[] temp = StringUtils.splitToInt(inString);
        Integer[] newArray = new Integer[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            newArray[i] = new Integer(temp[i]);
        }
        return newArray;
    }

    public static final int[] splitToInt(String inString, char delimiter) {
        if (inString == null) {
            return null;
        }
        String[] temp = StringUtils.split(inString, delimiter);
        int[] list = new int[temp.length];
        int j = 0;
        for (int i = 0; i < temp.length; ++i) {
            try {
                list[j++] = Integer.parseInt(temp[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return list;
    }

    public static final String deURLify(String hexified) {
        int now;
        String search = hexified.replace('+', ' ');
        StringBuffer dehexified = new StringBuffer();
        int prev = 0;
        while ((now = search.indexOf(37, prev)) >= 0) {
            dehexified.append(search.substring(prev, now));
            String hexChar = search.substring(now + 1, now + 3);
            dehexified.append((char)Integer.parseInt(hexChar, 16));
            prev = now + 3;
        }
        dehexified.append(search.substring(prev));
        return dehexified.toString();
    }

    public static final boolean isStringInVector(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final String join(char separator, Object[] items) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                str.append(separator);
            }
            str.append(items[i].toString());
        }
        return str.toString();
    }

    public static final String join(Object[] items) {
        return StringUtils.join(',', items);
    }

    public static final String merge(char indexSeparator, Object[] items1, char mergeSeparator, Object[] items2) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < items1.length; ++i) {
            if (i > 0) {
                str.append(indexSeparator);
            }
            if (items1[i] == null || items2[i] == null) continue;
            str.append(items1[i].toString());
            str.append(mergeSeparator);
            str.append(items2[i].toString());
        }
        return str.toString();
    }

    public static boolean isDouble(String string) {
        if (string == "") {
            return false;
        }
        try {
            new Double(string);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

