/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.net;

import com.openit.lego.logging.Logger;
import com.openit.lego.net.CGIUtils;
import java.applet.Applet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class CGIThread
extends Thread {
    public static int GET = CGIUtils.GET;
    public static int POST = CGIUtils.POST;
    protected Hashtable parameters = new Hashtable();

    public CGIThread(String string) {
        super(string);
    }

    public static final String escapeHTMLMarkupChars(String name) {
        return CGIUtils.escapeHTMLMarkupChars(name);
    }

    public static final String deEscapeHTMLMarkupChars(String name) {
        return CGIUtils.deEscapeHTMLMarkupChars(name);
    }

    public final String buildURLArg(String name, int value) {
        return this.buildURLArg(name, String.valueOf(value));
    }

    public final String buildURLArg(String name, String value) {
        return CGIUtils.buildURLArg(name, value);
    }

    public String callCGI(String script, String cmd, int method, Applet applet) {
        try {
            String parametersAsString = "";
            Iterator parameterKeys = (Iterator)((Object)this.parameters.keys());
            while (parameterKeys.hasNext()) {
                String currentKey = (String)parameterKeys.next();
                String currentValue = this.parameters.get(currentKey).toString();
                parametersAsString = parametersAsString + this.buildURLArg(currentKey, currentValue);
            }
            cmd = cmd + parametersAsString;
            return CGIUtils.callCGI(script, cmd, method, applet);
        }
        catch (ClassCastException cce) {
            Logger.error(cce.getMessage());
            cce.printStackTrace();
            return null;
        }
    }

    public String callCGI(String script, String cmd, Applet applet) {
        return this.callCGI(script, cmd, GET, applet);
    }

    public String callCGI(String script, Applet applet) {
        return this.callCGI(script, "", GET, applet);
    }

    public static final String buildDebugVerboseFlags(String cmd) {
        return CGIUtils.buildDebugVerboseFlags(cmd);
    }

    public abstract void run();

    protected void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    protected void addParameter(String key, int value) {
        this.addParameter(key, Integer.toString(value));
    }

    protected void addParameterMap(Map parameterMap) {
        this.parameters.putAll(parameterMap);
    }

    public String toString() {
        String parametersAsString = "";
        Iterator parameterKeys = (Iterator)((Object)this.parameters.keys());
        while (parameterKeys.hasNext()) {
            String currentKey = (String)parameterKeys.next();
            String currentValue = this.parameters.get(currentKey).toString();
            parametersAsString = parametersAsString + currentKey + "=" + currentValue + " ";
        }
        return this.getName() + " " + parametersAsString;
    }
}

