/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnoBoundsInfo;
import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.DerivedString;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxisFormula;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.LogAxisHandler;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;

public class JCAxis
extends ChartInteriorRegion
implements Serializable {
    protected int gap = 3;
    protected JCAxisTitle title = null;
    protected DerivedDouble min = new DerivedDouble(0.0, true);
    protected DerivedDouble max = new DerivedDouble(0.0, true);
    protected DerivedDouble origin = new DerivedDouble(0.0, true);
    protected DerivedInt originPlacement = new DerivedInt(0, true);
    protected DerivedInt placement = new DerivedInt(0, true);
    protected JCChartStyle gridStyle;
    protected DerivedDouble gridSpacing = new DerivedDouble(0.0, true);
    protected boolean gridVisible = false;
    protected JCAxisFormula formula = null;
    protected boolean editable = true;
    protected boolean logarithmic = false;
    protected boolean reversed = false;
    protected boolean vertical = false;
    protected int annotationRotation = 0;
    protected JCAxis placementAxis = null;
    protected double placementLocation = 0.0;
    protected JCLabelGenerator labelGenerator = null;
    protected boolean decimalPadded = true;
    protected int savedXAxisAnnotationMethod;
    protected long timeUnit = 1000L;
    protected Date timeBase = null;
    protected DerivedString timeFormat = new DerivedString("", true);
    protected Polygon sideplane;
    protected int tickLength = 4;
    protected JCChartArea chartArea = null;
    protected double step = 1.0;
    public static final long SECONDS = 1000L;
    public static final long MINUTES = 60000L;
    public static final long HOURS = 3600000L;
    public static final long DAYS = 86400000L;
    public static final long WEEKS = 604800000L;
    public static final long MONTHS = 2678400000L;
    public static final long YEARS = 31536000000L;
    protected MinMax dataLimits = null;
    protected DerivedInt precision = new DerivedInt(1, true);
    protected DerivedInt radianPrecision = new DerivedInt(2, true);
    protected DerivedInt degreeGradPrecision = new DerivedInt(0, true);
    protected static final int MAX_PRECISION = 14;
    protected int maximumPrecision = 14;
    protected DerivedDouble numSpacing = new DerivedDouble(0.0, true);
    protected int logIncrement = 1;
    protected DerivedDouble tickSpacing = new DerivedDouble(0.0, true);
    public static final int AUTOMATIC = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int ZERO = 3;
    public static final int VALUE_ANCHORED = 4;
    public static final int ORIGIN = 5;
    public static final int VALUE = 0;
    public static final int VALUE_LABELS = 1;
    public static final int TIME_LABELS = 2;
    public static final int POINT_LABELS = 3;
    protected int annotationMethod = 0;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    protected transient int chartType;
    protected transient boolean isPrimary;
    protected transient JCAxis otherAxis;
    private transient AxisHandler axisHandler = null;
    protected AnnotationHandler annoHandler = new AnnotationHandler(this);
    private boolean axisDrawn = false;
    private static int axisNum = 0;
    private boolean hasBar = false;
    boolean frontPlane = true;
    protected PolarAxisParams polarAxisParams = null;
    protected boolean usingDoublePixels = false;
    static final int TROUGH_TOP = 1;
    static final int TROUGH_BOTTOM = 2;
    static final int TROUGH_LEFT = 1;
    static final int TROUGH_RIGHT = 2;

    private void init() {
        this.setTitle(new JCAxisTitle());
        this.setName(JCChartBundle.string("com.klg.jclass.chart.Key6") + " " + ++axisNum);
    }

    public JCAxis(JCChartArea jCChartArea, boolean bl, int n) {
        this.vertical = bl;
        this.annotationMethod = n;
        this.chartArea = jCChartArea;
        this.init();
        if (this.chartArea != null) {
            this.polarAxisParams = this.chartArea.polarAxisParams;
        }
    }

    public JCAxis() {
        this.init();
    }

    public void setParentChart(JCChart jCChart) {
        if (this.parentChart == jCChart) {
            return;
        }
        super.setParentChart(jCChart);
        if (jCChart != null) {
            this.chartArea = jCChart.getChartArea();
        }
        if (this.chartArea != null) {
            this.polarAxisParams = this.chartArea.polarAxisParams;
        }
        this.setParentRegion(this.chartArea);
        if (this.title != null) {
            this.title.setParentAxis(this);
            this.title.setParentChart(jCChart);
            this.title.setParentRegion(this.chartArea);
        }
        if (this.annoHandler != null) {
            this.annoHandler.setValueLabelParent(jCChart);
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        if (bl == this.gridVisible) {
            return;
        }
        this.gridVisible = bl;
        this.setChanged(true, 2);
    }

    public double getGridSpacing() {
        return this.gridSpacing.value;
    }

    public void setGridSpacing(double d) {
        this.gridSpacing.value = d;
        this.gridSpacing.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setGridSpacingIsDefault(boolean bl) {
        if (this.gridSpacing.isDefault == bl) {
            return;
        }
        this.gridSpacing.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getGridSpacingIsDefault() {
        return this.gridSpacing.isDefault;
    }

    public JCChartStyle getGridStyle() {
        if (this.gridStyle == null) {
            this.gridStyle = new JCChartStyle();
            this.gridStyle.setLineStyle(new JCLineStyle(1, this.getForeground(), 1));
            this.gridStyle.addParent(this);
        }
        return this.gridStyle;
    }

    public void setGridStyle(JCChartStyle jCChartStyle) {
        if (jCChartStyle == this.gridStyle) {
            return;
        }
        this.gridStyle = jCChartStyle;
        this.setChanged(true, 2);
    }

    public void setLogarithmic(boolean bl) {
        if (this.logarithmic == bl) {
            return;
        }
        this.logarithmic = bl;
        this.axisHandler = null;
        this.setChanged(true, 2);
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDecimalPadded(boolean bl) {
        this.decimalPadded = bl;
    }

    public boolean isDecimalPadded() {
        return this.decimalPadded;
    }

    public void setMin(double d) {
        this.min.value = d;
        this.min.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getMin() {
        return this.min.value;
    }

    public void setMinIsDefault(boolean bl) {
        if (this.min.isDefault == bl) {
            return;
        }
        this.min.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public void setMax(double d) {
        this.max.value = d;
        this.max.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getMax() {
        return this.max.value;
    }

    public void setMaxIsDefault(boolean bl) {
        if (this.max.isDefault == bl) {
            return;
        }
        this.max.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public void setOrigin(double d) {
        this.origin.value = d;
        this.origin.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getOrigin() {
        return this.origin.value;
    }

    public void setOriginIsDefault(boolean bl) {
        if (this.origin.isDefault == bl) {
            return;
        }
        this.origin.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getOriginIsDefault() {
        return this.origin.isDefault;
    }

    public void setOriginPlacement(int n) {
        if (this.originPlacement.value == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.originPlacement.value = n;
                this.originPlacement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid OriginPlacement in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public int getOriginPlacement() {
        return this.originPlacement.value;
    }

    public void setOriginPlacementIsDefault(boolean bl) {
        if (this.originPlacement.isDefault == bl) {
            return;
        }
        this.originPlacement.isDefault = bl;
        if (bl) {
            this.originPlacement.value = 0;
        }
        this.setChanged(true, 2);
    }

    public boolean getOriginPlacementIsDefault() {
        return this.originPlacement.isDefault;
    }

    public JCAxisTitle getTitle() {
        if (this.title == null) {
            this.title = new JCAxisTitle();
            this.title.setParentAxis(this);
            this.title.setParentChart(this.parentChart);
            this.title.setParentRegion(this.chartArea);
        }
        return this.title;
    }

    public void setTitle(JCAxisTitle jCAxisTitle) {
        if (jCAxisTitle == null) {
            return;
        }
        this.title = jCAxisTitle;
        this.title.setParentAxis(this);
        this.title.setParentChart(this.parentChart);
        this.title.setParentRegion(this.chartArea);
        this.setChanged(true, 2);
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.setChanged(true, 2);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public JCAxisFormula getFormula() {
        if (this.formula == null) {
            this.formula = new JCAxisFormula(this);
        }
        return this.formula;
    }

    public void setAnnotationRotation(int n) {
        if (n == this.annotationRotation) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.annotationRotation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AnnotationRotation value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public int getAnnotationRotation() {
        return this.annotationRotation;
    }

    public void setPlacement(int n) {
        if (this.placement.value == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.placement.value = n;
                this.placement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Placement value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public void setPlacement(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setPlacement(5);
    }

    public void setPlacement(JCAxis jCAxis, double d) {
        this.placementAxis = jCAxis;
        this.placementLocation = d;
        this.setPlacement(4);
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        if (bl) {
            this.placement.value = 0;
        }
        this.setChanged(true, 2);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    public void setPlacementAxis(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setChanged(true, 2);
    }

    public JCAxis getPlacementAxis() {
        return this.placementAxis;
    }

    public void setPlacementLocation(double d) {
        this.placementLocation = d;
        this.setChanged(true, 2);
    }

    public double getPlacementLocation() {
        return this.placementLocation;
    }

    public void setAnnotationMethod(int n) {
        if (n == this.annotationMethod) {
            this.savedXAxisAnnotationMethod = this.annotationMethod;
            return;
        }
        switch (n) {
            case 3: {
                if (this.chartArea != null && !this.chartArea.isXAxis(this)) {
                    throw new IllegalArgumentException("Only X axes can use point labels");
                }
            }
            case 0: 
            case 1: {
                this.savedXAxisAnnotationMethod = this.annotationMethod = n;
                break;
            }
            case 2: {
                if (this.isRadar() && !this.vertical) {
                    return;
                }
                this.savedXAxisAnnotationMethod = this.annotationMethod = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AnnotationMethod value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public void setPrecision(int n) {
        DerivedInt derivedInt = this.getPrecisionObject();
        derivedInt.value = n;
        derivedInt.isDefault = false;
        this.setChanged(true, 2);
    }

    protected void setPrecisionInternal(int n) {
        DerivedInt derivedInt = this.getPrecisionObject();
        derivedInt.value = n;
    }

    public int getPrecision() {
        int n = this.getPrecisionObject().value;
        return n;
    }

    public void setPrecisionIsDefault(boolean bl) {
        DerivedInt derivedInt = this.getPrecisionObject();
        derivedInt.isDefault = bl;
        this.setChanged(true, 2);
    }

    private DerivedInt getPrecisionObject() {
        DerivedInt derivedInt = this.precision;
        if (this.isPolar() && !this.vertical) {
            int n = this.chartArea.getAngleUnit();
            switch (n) {
                case 2: {
                    derivedInt = this.radianPrecision;
                    break;
                }
                case 1: 
                case 3: {
                    derivedInt = this.degreeGradPrecision;
                    break;
                }
            }
        }
        return derivedInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPrecision(int n) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.maximumPrecision = n;
        }
        this.setChanged(true, 2);
    }

    public int getMaxPrecision() {
        return this.maximumPrecision;
    }

    public boolean getPrecisionIsDefault() {
        DerivedInt derivedInt = this.getPrecisionObject();
        return derivedInt.isDefault;
    }

    public void setNumSpacing(double d) {
        this.numSpacing.value = d;
        this.numSpacing.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getNumSpacing() {
        return this.numSpacing.value;
    }

    public void setNumSpacingIsDefault(boolean bl) {
        this.numSpacing.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getNumSpacingIsDefault() {
        return this.numSpacing.isDefault;
    }

    public double getTickSpacing() {
        return this.tickSpacing.value;
    }

    public void setTickSpacing(double d) {
        this.tickSpacing.value = d;
        this.tickSpacing.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setTickSpacingIsDefault(boolean bl) {
        this.tickSpacing.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getTickSpacingIsDefault() {
        return this.tickSpacing.isDefault;
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        if (this.labelGenerator == jCLabelGenerator) {
            return;
        }
        this.labelGenerator = jCLabelGenerator;
        this.numberLocalization = false;
        this.setChanged(true, 2);
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setTimeUnit(long l) {
        if (this.timeUnit == l) {
            return;
        }
        if (l != 1000L && l != 60000L && l != 3600000L && l != 86400000L && l != 604800000L && l != 2678400000L && l != 31536000000L) {
            throw new IllegalArgumentException("Invalid TimeUnit value in JCAxis");
        }
        this.timeUnit = l;
        this.setChanged(true, 2);
    }

    public long getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeBase(Date date) {
        if (date == null) {
            return;
        }
        if (this.timeBase != null && this.timeBase.equals(date)) {
            return;
        }
        this.timeBase = date;
        this.setChanged(true, 2);
    }

    public Date getTimeBase() {
        if (this.timeBase == null) {
            this.timeBase = new Date();
        }
        return this.timeBase;
    }

    public String timeBaseToString(boolean bl) {
        return bl ? this.annoHandler.getDateFormatter().timeLabel(this.timeFormat.value, this.getTimeBase()) : this.annoHandler.getDateFormatter().timeLabel(this.getTimeBase());
    }

    public void setTimeFormat(String string) {
        this.setTimeFormat(string, true);
    }

    public void setTimeFormat(String string, boolean bl) {
        if (this.timeFormat.value != null && this.timeFormat.value.equals(string)) {
            return;
        }
        this.timeFormat.value = string;
        this.timeFormat.isDefault = false;
        if (bl) {
            this.setChanged(true, 2);
        }
    }

    public String getTimeFormat() {
        return this.timeFormat.value;
    }

    public void setTimeFormatIsDefault(boolean bl) {
        this.setTimeFormatIsDefault(bl, true);
    }

    public void setTimeFormatIsDefault(boolean bl, boolean bl2) {
        if (this.timeFormat.isDefault == bl) {
            return;
        }
        this.timeFormat.isDefault = bl;
        if (bl2) {
            this.setChanged(true, 2);
        }
    }

    public boolean getTimeFormatIsDefault() {
        return this.timeFormat.isDefault;
    }

    public void setVertical(boolean bl) {
        if (this.vertical == bl) {
            return;
        }
        this.vertical = bl;
        this.setChanged(true, 2);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setGap(int n) {
        if (this.gap == n) {
            return;
        }
        this.gap = n;
        this.setChanged(true, 2);
    }

    public int getGap() {
        return this.gap;
    }

    public JCValueLabel getValueLabel(double d) {
        JCValueLabel jCValueLabel = null;
        int n = 0;
        while (n < this.annoHandler.userValueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n);
            if (d == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n;
        }
        return jCValueLabel;
    }

    public JCValueLabel getGeneratedValueLabel(double d) {
        JCValueLabel jCValueLabel = null;
        int n = 0;
        while (n < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            if (d == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n;
        }
        return jCValueLabel;
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.annoHandler.userValueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n3);
            if (jCValueLabel2.value > jCValueLabel.value && n2 < 0) {
                n2 = n3;
                break;
            }
            if (jCValueLabel2.value == jCValueLabel.value) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n >= 0) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n);
        } else if (n2 >= 0) {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n2);
        } else {
            this.annoHandler.userValueLabels.addElement(jCValueLabel);
        }
        jCValueLabel.setParent(this);
        this.setChanged(true, 2);
    }

    public JCValueLabel[] getValueLabels() {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.userValueLabels.size()];
        int n = 0;
        while (n < jCValueLabelArray.length) {
            jCValueLabelArray[n] = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n);
            ++n;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel[] getGeneratedValueLabels() {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.valueLabels.size()];
        int n = 0;
        while (n < jCValueLabelArray.length) {
            jCValueLabelArray[n] = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
            ++n;
        }
        return jCValueLabelArray;
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        this.annoHandler.userValueLabels = new Vector();
        if (jCValueLabelArray == null) {
            return;
        }
        int n = 0;
        while (n < jCValueLabelArray.length) {
            if (jCValueLabelArray[n] != null) {
                jCValueLabelArray[n].setParent(this);
            }
            this.annoHandler.userValueLabels.addElement(jCValueLabelArray[n]);
            ++n;
        }
        this.annoHandler.sortValueLabels();
        this.setChanged(true, 2);
    }

    public JCValueLabel getValueLabels(int n) {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jCValueLabel;
    }

    public JCValueLabel getGeneratedValueLabels(int n) {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jCValueLabel;
    }

    public void setValueLabels(int n, JCValueLabel jCValueLabel) {
        if (this.annoHandler.userValueLabels == null) {
            this.annoHandler.userValueLabels = new Vector();
        }
        if (n < 0 || n > this.annoHandler.userValueLabels.size()) {
            throw new IllegalArgumentException("Invalid ValueLabels index in JCAxis");
        }
        if (jCValueLabel != null) {
            jCValueLabel.setParent(this);
        }
        if (n < this.annoHandler.userValueLabels.size()) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n);
        } else {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n);
        }
        this.setChanged(true, 2);
    }

    public void setTimeAnnotationLocale(Locale locale) {
        if (this.annotationMethod == 2) {
            this.annoHandler.getDateFormatter().setLocale(locale);
            this.setChanged(true, 1);
        }
    }

    public String toString() {
        String string = this.getName();
        return string == null ? JCChartBundle.string("com.klg.jclass.chart.Key141") + (this.vertical ? JCChartBundle.string("com.klg.jclass.chart.Key147") : JCChartBundle.string("com.klg.jclass.chart.Key44")) + " " + JCChartBundle.string("com.klg.jclass.chart.Key6") : string;
    }

    public int toPixel(double d) {
        return this.getAxisHandler().toPixel(d);
    }

    public double toPixelDouble(double d) {
        return this.getAxisHandler().toPixelDouble(d);
    }

    public Point toPixelPolar(double d, double d2, boolean bl) {
        Point point = null;
        if (this.vertical) {
            point = this.getAxisHandler().toPixelPolar(d, d2, bl);
        } else if (this.otherAxis != null) {
            point = this.otherAxis.getAxisHandler().toPixelPolar(d, d2, bl);
        }
        return point;
    }

    protected double applyDataToPixelScaling(double d) {
        double d2 = Double.MAX_VALUE;
        if (this.vertical) {
            d2 = this.getAxisHandler().scale * d;
        } else if (this.otherAxis != null) {
            d2 = this.otherAxis.getAxisHandler().scale * d;
        }
        return d2;
    }

    protected double applyPixelToDataScaling(double d) {
        double d2 = Double.MAX_VALUE;
        if (this.vertical) {
            d2 = d / this.getAxisHandler().scale;
        } else if (this.otherAxis != null) {
            d2 = d / this.otherAxis.getAxisHandler().scale;
        }
        return d2;
    }

    public int toPixel(double d, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toPixel(d) + (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX());
        }
        if (!this.frontPlane && bl) {
            return this.toPixel(d) - (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX());
        }
        return this.toPixel(d);
    }

    public double toPixelDouble(double d, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toPixelDouble(d) + (double)(this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX());
        }
        if (!this.frontPlane && bl) {
            return this.toPixelDouble(d) - (double)(this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX());
        }
        return this.toPixelDouble(d);
    }

    public double toData(int n) {
        return this.getAxisHandler().toData(n);
    }

    public double toData(int n, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toData(n - (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX()));
        }
        if (!this.frontPlane && bl) {
            return this.toData(n + (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX()));
        }
        return this.toData(n);
    }

    public JCDataCoord toDataPolar(int n, int n2) {
        JCDataCoord jCDataCoord = null;
        if (this.vertical) {
            jCDataCoord = this.getAxisHandler().toDataPolar(n, n2);
        } else if (this.otherAxis != null) {
            jCDataCoord = this.otherAxis.getAxisHandler().toDataPolar(n, n2);
        }
        return jCDataCoord;
    }

    public void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (graphics == null) {
            return;
        }
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
            defineShape.beginShape();
        }
        this.axisDrawn = false;
        this.axisDrawn = this.vertical ? this.drawVertical(graphics) : this.drawHorizontal(graphics);
        if (defineShape != null) {
            defineShape.endShape(true);
        }
    }

    void drawAnnotationsAndTitle(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics graphics2 = graphics.create();
        if (this.axisDrawn) {
            this.annoHandler.draw(graphics2);
            if (this.title != null && !this.isPolar() && !this.isRadar()) {
                this.title.draw(graphics2);
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.getLeft() == n && this.getTop() == n2 && this.getWidth() == n3 && this.getHeight() == n4) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.setChanged(true, 2, false);
        this.calcTransformation();
    }

    public void recalc() {
        this.setChanged(false, 0, false);
    }

    public double dateToValue(Date date) {
        this.getTimeBase();
        return this.annoHandler.timeToData(date, this.timeUnit);
    }

    public Date valueToDate(double d) {
        this.getTimeBase();
        return this.annoHandler.dataToTime(d, this.timeUnit);
    }

    void preDrawCalc() {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            int[] nArray = new int[5];
            int[] nArray2 = new int[5];
            if (this.vertical) {
                nArray[0] = nArray[1] = this.linePosition();
                nArray2[0] = this.getTop() + this.getHeight();
                nArray2[1] = this.getTop();
                nArray[3] = nArray[2] = nArray[1] + this.chartArea.getDeltaX();
                nArray2[2] = nArray2[1] + this.chartArea.getDeltaY();
                nArray2[3] = nArray2[0] + this.chartArea.getDeltaY();
            } else {
                nArray[0] = this.getLeft() + this.getWidth();
                nArray[1] = this.getLeft();
                nArray2[0] = nArray2[1] = this.linePosition();
                nArray[2] = nArray[1] + this.chartArea.getDeltaX();
                nArray2[2] = nArray2[3] = nArray2[1] + this.chartArea.getDeltaY();
                nArray[3] = nArray[0] + this.chartArea.getDeltaX();
            }
            nArray[4] = nArray[0];
            nArray2[4] = nArray2[0];
            this.sideplane = new Polygon();
            int n = 0;
            while (n < 5) {
                this.sideplane.addPoint(nArray[n], nArray2[n]);
                ++n;
            }
        }
    }

    void preDraw(Graphics graphics, boolean bl, boolean bl2) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            boolean bl3;
            Serializable serializable;
            Color color = null;
            if (this.chartArea.isOpaque()) {
                color = this.chartArea.getPlotArea().getBackground();
            } else {
                serializable = this.chartArea.getParent();
                while (serializable != null && serializable instanceof JComponent && !((JComponent)serializable).isOpaque()) {
                    serializable = ((Component)serializable).getParent();
                }
                if (serializable != null && serializable instanceof JComponent && ((JComponent)serializable).isOpaque()) {
                    color = ((Component)serializable).getBackground();
                } else if (serializable != null && !(serializable instanceof JComponent)) {
                    color = ((Component)serializable).getBackground();
                }
            }
            if (color == null) {
                return;
            }
            serializable = new JCFillStyle(color, 1);
            boolean bl4 = bl3 = this.isPrimary && this.vertical || !this.isPrimary && !this.vertical;
            if (bl) {
                if (!this.vertical && this.chartArea.getDeltaY() <= 0 || this.vertical && this.chartArea.getDeltaX() <= 0) {
                    ((JCFillStyle)serializable).fillPolygonHighlight(graphics, this.sideplane);
                } else {
                    ((JCFillStyle)serializable).fillPolygonShadow(graphics, this.sideplane);
                }
            } else {
                int n = this.otherAxis.linePosition();
                if (bl2) {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.vertical) {
                        polygon.ypoints[1] = n;
                        polygon.ypoints[2] = n + this.chartArea.getDeltaY();
                    } else {
                        polygon.xpoints[0] = n;
                        polygon.xpoints[4] = n;
                        polygon.xpoints[3] = n + this.chartArea.getDeltaX();
                    }
                    if (!this.vertical && this.chartArea.getDeltaY() <= 0 || this.vertical && this.chartArea.getDeltaX() <= 0) {
                        ((JCFillStyle)serializable).fillPolygonHighlight(graphics, polygon);
                    } else {
                        ((JCFillStyle)serializable).fillPolygonShadow(graphics, polygon);
                    }
                } else {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.vertical) {
                        polygon.ypoints[0] = n;
                        polygon.ypoints[4] = n;
                        polygon.ypoints[3] = n + this.chartArea.getDeltaY();
                    } else {
                        polygon.xpoints[1] = n;
                        polygon.xpoints[2] = n + this.chartArea.getDeltaX();
                    }
                    if (!this.vertical && this.chartArea.getDeltaY() <= 0 || this.vertical && this.chartArea.getDeltaX() <= 0) {
                        ((JCFillStyle)serializable).fillPolygonHighlight(graphics, polygon);
                    } else {
                        ((JCFillStyle)serializable).fillPolygonShadow(graphics, polygon);
                    }
                }
            }
        }
    }

    void preDrawOutlineTrough(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            jCFillStyle.drawOutlinePolygon(graphics, this.sideplane, this.getForeground());
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void postDrawOutlineTrough(Graphics graphics, int n) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D() && this.sideplane != null) {
            boolean bl;
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            boolean bl2 = bl = this.isPrimary && this.vertical || !this.isPrimary && !this.vertical;
            if (!bl && !this.reversed && (n & 1) != 0 || !bl && this.reversed && (n & 2) != 0 || bl && !this.reversed && (n & 2) != 0 || bl && this.reversed && (n & 1) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 1, 2, this.getForeground());
            }
            if (!bl && !this.reversed && (n & 2) != 0 || !bl && this.reversed && (n & 1) != 0 || bl && !this.reversed && (n & 1) != 0 || bl && this.reversed && (n & 2) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 3, 4, this.getForeground());
            }
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void clearLimits() {
        this.dataLimits = null;
    }

    void setLimits(MinMax minMax) {
        if (this.dataLimits == null) {
            this.dataLimits = new MinMax();
        }
        this.dataLimits.union(minMax);
        if (this.dataLimits.min > this.dataLimits.max) {
            this.dataLimits = null;
        }
    }

    void setInitialSize() {
        if (this.vertical) {
            this.setBounds(0, 0, 30, this.chartArea.getSize().height);
        } else {
            this.setBounds(0, this.chartArea.getSize().height - 30, this.chartArea.getSize().width, 30);
        }
    }

    void calcAxisParams(boolean bl) {
        boolean bl2;
        this.setInitialSize();
        this.chartType = -1;
        JCAxis jCAxis = this;
        boolean bl3 = bl2 = this.formula != null && this.formula.getOriginator() != null;
        if (bl2) {
            jCAxis = this.formula.getOriginator();
        }
        this.hasBar = false;
        boolean bl4 = false;
        Iterator iterator = this.getParentChart().getOriginalDataView().iterator();
        while (iterator.hasNext()) {
            int n;
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            this.usingDoublePixels = chartDataView.isUsingDoublePixels();
            if (chartDataView.getXAxis() == jCAxis) {
                n = chartDataView.getChartType();
                if (!bl4) {
                    this.chartType = n;
                    this.isPrimary = !bl2;
                    this.otherAxis = chartDataView.getYAxis();
                    bl4 = true;
                }
                if (!(bl2 || n != 9 && n != 10)) {
                    this.hasBar = true;
                }
            }
            if (chartDataView.getYAxis() != jCAxis) continue;
            n = chartDataView.getChartType();
            if (!bl4) {
                this.chartType = n;
                this.isPrimary = false;
                this.otherAxis = chartDataView.getXAxis();
                bl4 = true;
            }
            if (bl2 || n != 9 && n != 10) continue;
            this.hasBar = true;
        }
        this.frontPlane = this.hasBar || !this.is3D();
        this.getAxisHandler().calcParams();
        this.recalc();
    }

    void checkAnnotations() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.checkAnnotations();
    }

    void calcAnchors() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.calcAnchor();
        if (this.title.visible) {
            this.title.recalc(true);
            this.title.fixPlacement(this);
        }
    }

    void calcAnnotationExtents() {
        this.annoHandler.calcAnnotationExtents();
    }

    protected boolean isRightSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return this.vertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    protected boolean isLeftSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return this.vertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    protected boolean isBottomSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return !this.vertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    protected boolean isTopSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return !this.vertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    void adjustForOrthoExtent() {
        if (!this.visible) {
            return;
        }
        if (this.annoHandler.realPlacement == 1 || this.annoHandler.realPlacement == 2) {
            return;
        }
        if (this.placementAxis == null) {
            return;
        }
        Rectangle rectangle = this.chartArea.getPlotRect();
        Rectangle rectangle2 = this.chartArea.getChartAreaRect();
        if (this.vertical) {
            int n = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n < this.placementAxis.getLeft() || n > this.placementAxis.getLeft() + this.placementAxis.getWidth()) {
                return;
            }
            if (n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getLeftIsDefault()) {
                    int n2 = this.annoHandler.extents.ortho - n;
                    rectangle.width -= n2;
                    rectangle.x += n2;
                }
                this.setSize(this.annoHandler.extents.ortho, this.getHeight());
            } else if (rectangle2.width - n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getRightIsDefault()) {
                    int n3 = this.annoHandler.extents.ortho - (rectangle2.width - n);
                    rectangle.width -= n3;
                }
                this.setSize(this.annoHandler.extents.ortho, this.getHeight());
            }
        } else {
            int n = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n < this.placementAxis.getTop() || n > this.placementAxis.getTop() + this.placementAxis.getHeight()) {
                return;
            }
            if (rectangle2.height - n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getBottomIsDefault()) {
                    int n4 = this.annoHandler.extents.ortho - (rectangle2.height - n);
                    rectangle.height -= n4;
                }
                this.setSize(this.getWidth(), this.annoHandler.extents.ortho);
            } else if (n < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getTopIsDefault()) {
                    int n5 = this.annoHandler.extents.ortho - n;
                    rectangle.height -= n5;
                    rectangle.y += n5;
                }
                this.setSize(this.getWidth(), this.annoHandler.extents.ortho);
            }
        }
    }

    protected void setPolarAxisParams(PolarAxisParams polarAxisParams) {
        this.polarAxisParams = polarAxisParams;
    }

    protected void layoutPolarAxis() {
        if (this.isPolar() || this.isRadar()) {
            Rectangle rectangle = this.chartArea.getPlotRect();
            double d = rectangle.width;
            double d2 = rectangle.height;
            double d3 = 0.95 * Math.min(d, d2) / 2.0;
            if (Math.abs(this.polarAxisParams.radius - d3) < 1.0) {
                return;
            }
            this.polarAxisParams.radius = d3;
            this.polarAxisParams.xCenter = (double)rectangle.x + d / 2.0;
            this.polarAxisParams.yCenter = (double)rectangle.y + d2 / 2.0;
            this.chartArea.recalc();
        }
    }

    protected void adjustCenterAndRadius(int n, int n2, int n3) {
        this.polarAxisParams.xCenter += (double)n;
        this.polarAxisParams.yCenter += (double)n2;
        this.polarAxisParams.radius += (double)n3;
        this.getAxisHandler().calcTransformation();
    }

    protected AnnoBoundsInfo getPolarAnnotationBounds() {
        return this.getAnnotationHandler().getPolarAnnotationBounds();
    }

    protected int getThetaAxisLabelOffset() {
        if (this.vertical) {
            return this.otherAxis.getAnnotationHandler().thetaAxisLabelOffset;
        }
        return this.getAnnotationHandler().thetaAxisLabelOffset;
    }

    void layoutAxis(boolean bl) {
        int n;
        int n2 = Math.max(-this.chartArea.getDeltaX(), 0);
        int n3 = Math.max(-this.chartArea.getDeltaY(), 0);
        int n4 = this.chartArea.getDeltaX();
        int n5 = this.chartArea.getDeltaY();
        int n6 = n = bl ? 1 : 0;
        if (this.vertical) {
            if (!this.isPolar() && !this.isRadar()) {
                if (!this.is3D()) {
                    this.setBounds(this.getLeft(), this.chartArea.getPlotRect().y, this.getWidth(), this.chartArea.getPlotRect().height);
                } else if (this.isBar()) {
                    if (this.getLeft() < this.chartArea.getPlotRect().x) {
                        this.setBounds(this.getLeft() + n2 * n, this.chartArea.getPlotRect().y + n3, this.getWidth(), this.chartArea.getPlotRect().height - JCChartUtil.abs(n5));
                    } else {
                        n2 = Math.max(this.chartArea.getDeltaX(), 0);
                        this.setBounds(this.getLeft() - n2 * n, this.chartArea.getPlotRect().y + n3, this.getWidth(), this.chartArea.getPlotRect().height - JCChartUtil.abs(n5));
                    }
                } else {
                    n3 = Math.max(this.chartArea.getDeltaY(), 0);
                    if (this.getLeft() <= this.chartArea.getPlotRect().x) {
                        n2 = Math.max(this.chartArea.getDeltaX(), 0);
                        this.setBounds(this.chartArea.getPlotRect().x + n2 * n - this.getWidth(), this.chartArea.getPlotRect().y + n3, this.getWidth(), this.chartArea.getPlotRect().height - JCChartUtil.abs(n5));
                    } else {
                        this.setBounds(this.chartArea.getPlotRect().x + this.chartArea.getPlotRect().width - n2 * n, this.chartArea.getPlotRect().y + n3, this.getWidth(), this.chartArea.getPlotRect().height - JCChartUtil.abs(n5));
                    }
                }
            }
        } else if (this.isPolar() || this.isRadar()) {
            this.layoutPolarAxis();
        } else if (!this.is3D()) {
            this.setBounds(this.chartArea.getPlotRect().x, this.getTop(), this.chartArea.getPlotRect().width, this.getHeight());
        } else if (this.isBar()) {
            if (this.getTop() <= this.chartArea.getPlotRect().y) {
                this.setBounds(this.chartArea.getPlotRect().x + n2, this.getTop() + n3 * n, this.chartArea.getPlotRect().width - JCChartUtil.abs(n4), this.getHeight());
            } else {
                n3 = Math.max(this.chartArea.getDeltaY(), 0);
                this.setBounds(this.chartArea.getPlotRect().x + n2, this.getTop() - n3 * n, this.chartArea.getPlotRect().width - JCChartUtil.abs(n4), this.getHeight());
            }
        } else {
            n2 = Math.max(this.chartArea.getDeltaX(), 0);
            if (this.getTop() <= this.chartArea.getPlotRect().y) {
                n3 = Math.max(this.chartArea.getDeltaY(), 0);
                this.setBounds(this.chartArea.getPlotRect().x + n2, this.chartArea.getPlotRect().y + n3 * n - this.getHeight(), this.chartArea.getPlotRect().width - JCChartUtil.abs(n4), this.getHeight());
            } else {
                this.setBounds(this.chartArea.getPlotRect().x + n2, this.chartArea.getPlotRect().y + this.chartArea.getPlotRect().height - n3 * n, this.chartArea.getPlotRect().width - JCChartUtil.abs(n4), this.getHeight());
            }
        }
    }

    void layoutOrigin() {
        if (this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4) {
            return;
        }
        if (this.placementAxis == null) {
            this.placementAxis = this.otherAxis;
        }
        if (this.placementAxis == null) {
            return;
        }
        double d = this.annoHandler.realPlacement == 4 ? this.placementLocation : this.placementAxis.origin.value;
        int n = this.placementAxis.toPixel(d);
        if (this.vertical) {
            if (this.annoHandler.anchor == 1) {
                this.setLocation(n, this.getTop());
            } else {
                this.setLocation(n - this.getWidth(), this.getTop());
            }
        } else if (this.annoHandler.anchor == 16) {
            this.setLocation(this.getLeft(), n - this.getHeight());
        } else {
            this.setLocation(this.getLeft(), n);
        }
    }

    void layoutAnnotations() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.layout();
        if (this.title != null) {
            this.title.layout();
        }
    }

    int pixelLength() {
        int n = (this.isPolar() || this.isRadar()) && this.vertical ? (int)Math.round(this.polarAxisParams.radius) : (this.vertical ? this.getHeight() : this.getWidth());
        return n;
    }

    int pixelStart() {
        return this.vertical ? -this.getTop() : this.getLeft();
    }

    void calcTransformation() {
        this.getAxisHandler().calcTransformation();
    }

    int linePosition() {
        int n = this.vertical ? (this.annoHandler.anchor == 2 ? this.getLeft() + this.getWidth() : (this.annoHandler.anchor == 1 ? this.getLeft() : this.getLeft() + this.getWidth() / 2)) : (this.annoHandler.anchor == 16 ? this.getTop() + this.getHeight() : (this.annoHandler.anchor == 32 ? this.getTop() : this.getTop() + this.getHeight() / 2));
        return n;
    }

    void makeAnnotations() {
        this.annoHandler.makeAnnotations();
    }

    AxisHandler getAxisHandler() {
        if (this.axisHandler == null || (this.isPolar() || this.isRadar()) && !this.vertical && this.axisHandler instanceof LogAxisHandler || this.logarithmic && !(this.axisHandler instanceof LogAxisHandler) || !this.logarithmic && this.axisHandler instanceof LogAxisHandler) {
            this.axisHandler = AxisHandler.makeAxisHandler(this);
        }
        return this.axisHandler;
    }

    Extents getExtents() {
        return this.annoHandler.extents;
    }

    Vector getAnnotations() {
        return this.annoHandler.valueLabels;
    }

    int getAdjustedRealPlacement() {
        if (this.otherAxis != null && this.otherAxis.reversed) {
            if (this.annoHandler.realPlacement == 1) {
                return 2;
            }
            return 1;
        }
        return this.annoHandler.realPlacement;
    }

    double getRealPlacementLocation() {
        switch (this.annoHandler.realPlacement) {
            case 1: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMin();
            }
            case 2: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMax();
            }
            case 5: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getOrigin();
            }
            case 4: {
                return this.getPlacementLocation();
            }
        }
        return Double.MAX_VALUE;
    }

    int getAnnotationAnchor() {
        return this.annoHandler.anchor;
    }

    double firstGridInc(double d) {
        double d2 = this.firstInc(d);
        double d3 = d2 - this.min.value;
        if (d3 >= d) {
            d2 -= d * Math.floor(d3 / d);
        }
        return d2;
    }

    double firstInc(double d) {
        double d2 = this.min.value;
        if (d == 0.0) {
            return d2;
        }
        d2 = JCChartUtil.precCorrect(this.getPrecision(), d2);
        int n = (int)Math.ceil((this.min.value - d2) / d);
        if (n < 0) {
            return d2;
        }
        double d3 = d2 + d * (double)n;
        d3 = JCChartUtil.precCorrect(this.getPrecision(), d3);
        if (d3 > this.max.value) {
            return d2;
        }
        return d3;
    }

    double range() {
        return this.getAxisHandler().range();
    }

    void translate(double d) {
        this.getAxisHandler().translate(d);
        this.setChanged(true, 2, false);
    }

    public boolean isPolar() {
        return this.chartType == 2;
    }

    public boolean isRadar() {
        return this.chartType == 3 || this.chartType == 4;
    }

    public boolean isPolarRadar() {
        return this.chartType == 2 || this.chartType == 3 || this.chartType == 4;
    }

    protected boolean isBar() {
        return this.hasBar;
    }

    private boolean is3D() {
        return this.chartArea != null && this.chartArea.getDraw3D();
    }

    private double dataLength() {
        return this.max.value - this.min.value;
    }

    void drawGrid(Graphics graphics) {
        if (!this.gridVisible) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
        } else {
            this.drawLinearGridLines(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
        }
    }

    void drawGridInTrough(Graphics graphics, double d, double d2) {
        if (!this.gridVisible) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, true, d, d2);
        } else {
            this.drawLinearGridLines(graphics, true, d, d2);
        }
    }

    protected double[] getGridLineList() {
        if (!this.gridVisible) {
            return null;
        }
        if (this.gridSpacing.isDefault) {
            return this.getGridLinesAtLabelsList();
        }
        return this.getLinearGridLinesList();
    }

    private void drawGridLine(Graphics graphics, JCLineStyle jCLineStyle, double d) {
        double d2 = this.usingDoublePixels ? this.toPixelDouble(d) : (double)this.toPixel(d);
        Rectangle rectangle = this.chartArea.getPlotRect();
        int n = this.chartArea.getDeltaX();
        int n2 = this.chartArea.getDeltaY();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.vertical) {
            if (this.isPolar() || this.isRadar()) {
                double d3 = this.getAxisHandler().scale;
                double d4 = 0.0;
                if (this.reversed) {
                    if (this.isLogarithmic()) {
                        if (this.max.value > 0.0 && d > 0.0) {
                            d4 = -d3 * (JCChartUtil.log10(this.max.value) - JCChartUtil.log10(d));
                        }
                    } else {
                        d4 = -d3 * (this.max.value - d);
                    }
                } else if (this.isLogarithmic()) {
                    if (this.min.value > 0.0 && d > 0.0) {
                        d4 = d3 * (JCChartUtil.log10(d) - JCChartUtil.log10(this.min.value));
                    }
                } else {
                    d4 = d3 * (d - this.min.value);
                }
                if (this.isPolar() && (!this.otherAxis.visible || d4 != Math.rint(this.polarAxisParams.radius)) || this.isRadar() && this.polarAxisParams.circularGridLines) {
                    jCLineStyle.drawCircle(graphics, (int)Math.round(this.polarAxisParams.xCenter), (int)Math.round(this.polarAxisParams.yCenter), (int)Math.round(d4));
                } else if (this.isRadar() && !this.polarAxisParams.circularGridLines) {
                    int n3 = this.otherAxis.annoHandler.valueLabels.size();
                    this.drawWebLine(graphics, jCLineStyle, d4, n3);
                }
            } else {
                int n4 = this.toPixel(this.max.value);
                int n5 = this.toPixel(this.min.value);
                Rectangle rectangle2 = graphics.getClipBounds();
                graphics.clipRect(rectangle2.x, Math.min(n4, n5) + n2, rectangle2.width, Math.abs(n4 - n5));
                if (this.is3D()) {
                    if (!this.frontPlane) {
                        n2 = 0;
                    }
                    if (n < 0) {
                        graphics2D.draw(new Line2D.Double(rectangle.x, d2 + (double)n2, rectangle.x + rectangle.width + n, d2 + (double)n2));
                    } else {
                        graphics2D.draw(new Line2D.Double(rectangle.x + n, d2 + (double)n2, rectangle.x + rectangle.width, d2 + (double)n2));
                    }
                } else {
                    graphics2D.draw(new Line2D.Double(rectangle.x, d2, rectangle.x + rectangle.width, d2));
                }
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        } else if (this.isPolar() || this.isRadar()) {
            double d5 = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d);
            if (d5 != Math.PI * 2) {
                this.drawRadialGridLine(graphics, d5);
            }
        } else {
            int n6 = this.toPixel(this.max.value);
            int n7 = this.toPixel(this.min.value);
            Rectangle rectangle3 = graphics.getClipBounds();
            graphics.clipRect(Math.min(n6, n7) + n, rectangle3.y, Math.abs(n6 - n7), rectangle3.height);
            if (this.is3D()) {
                if (!this.frontPlane) {
                    n = 0;
                }
                if (n2 < 0) {
                    graphics2D.draw(new Line2D.Double((double)n + d2, rectangle.y, (double)n + d2, rectangle.y + rectangle.height + n2));
                } else {
                    graphics2D.draw(new Line2D.Double((double)n + d2, rectangle.y + n2, (double)n + d2, rectangle.y + rectangle.height));
                }
            } else {
                graphics2D.draw(new Line2D.Double(d2, rectangle.y, d2, rectangle.y + rectangle.height));
            }
            graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    protected void drawRadialGridLine(Graphics graphics, double d) {
        Point point = this.getAxisHandler().toPixelPolar(d, 0.0, false);
        Point point2 = this.getAxisHandler().toPixelPolar(d, this.polarAxisParams.radius, false);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    protected void drawGridLineInTrough(Graphics graphics, JCLineStyle jCLineStyle, double d) {
        double d2 = this.usingDoublePixels ? this.toPixelDouble(d) : (double)this.toPixel(d);
        Rectangle rectangle = this.chartArea.getPlotRect();
        int n = this.chartArea.getDeltaX();
        int n2 = this.chartArea.getDeltaY();
        if (this.vertical) {
            if (this.is3D() && this.isBar() && n != 0) {
                int n3 = this.linePosition();
                int n4 = this.toPixel(this.min.value);
                int n5 = this.toPixel(this.max.value);
                jCLineStyle.updateGraphics(graphics);
                ((Graphics2D)graphics).draw(new Line2D.Double(n3, d2, n3 + n, d2 + (double)n2));
                jCLineStyle.resetGraphics(graphics);
            }
        } else if (this.is3D() && this.isBar() && n2 != 0) {
            int n6 = this.linePosition();
            int n7 = this.toPixel(this.min.value);
            int n8 = this.toPixel(this.max.value);
            jCLineStyle.updateGraphics(graphics);
            ((Graphics2D)graphics).draw(new Line2D.Double(d2, n6, d2 + (double)n, n6 + n2));
            jCLineStyle.resetGraphics(graphics);
        }
    }

    private void drawLinearGridLines(Graphics graphics, boolean bl, double d, double d2) {
        double d3 = this.gridSpacing.value;
        int n = this.pixelLength();
        double d4 = this.dataLength();
        double d5 = d3 / 2.0;
        if (d5 < 0.0) {
            d5 = -d5;
        }
        if (d3 * (double)n / d4 + 0.5 < 2.0) {
            if (d3 <= 0.0) {
                this.setGridVisible(false);
                this.setGridSpacingIsDefault(true);
            } else {
                ErrorDialog.raise(this, JCChartBundle.string("com.klg.jclass.chart.Key123"));
            }
            return;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        if (!jCLineStyle.updateGraphics(graphics)) {
            return;
        }
        double d6 = this.firstGridInc(d3);
        while (d6 <= this.max.value) {
            if (bl) {
                if (d == Double.MAX_VALUE || d6 >= d && d6 <= d2) {
                    this.drawGridLineInTrough(graphics, jCLineStyle, d6);
                }
            } else {
                this.drawGridLine(graphics, jCLineStyle, d6);
            }
            d6 += d3;
        }
        jCLineStyle.resetGraphics(graphics);
    }

    private double[] getLinearGridLinesList() {
        double d = this.gridSpacing.value;
        int n = this.pixelLength();
        double d2 = this.dataLength();
        double d3 = d / 2.0;
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if (d * (double)n / d2 + 0.5 < 2.0) {
            if (d <= 0.0) {
                this.setGridVisible(false);
                this.setGridSpacingIsDefault(true);
            } else {
                ErrorDialog.raise(this, JCChartBundle.string("com.klg.jclass.chart.Key123"));
            }
            return null;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        double[] dArray = new double[(int)Math.ceil((this.max.value + d3 - this.min.value) / d)];
        int n2 = 0;
        double d4 = this.firstGridInc(d);
        while (d4 < this.max.value + d3) {
            dArray[n2] = d4;
            ++n2;
            d4 += d;
        }
        return dArray;
    }

    private void drawGridLinesAtLabels(Graphics graphics, boolean bl, double d, double d2) {
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        if (!jCLineStyle.updateGraphics(graphics)) {
            return;
        }
        int n = this.annoHandler.valueLabels.size();
        int n2 = 0;
        while (n2 < n) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.visible) {
                if (bl) {
                    if (d == Double.MAX_VALUE || jCValueLabel.value >= d && jCValueLabel.value <= d2) {
                        this.drawGridLineInTrough(graphics, jCLineStyle, jCValueLabel.value);
                    }
                } else if (this.isRadar() && !this.vertical) {
                    double d3 = JCChartUtil.getRadarAngle(this.chartArea.getAngleUnit(), n, n2, this.isReversed());
                    this.drawGridLine(graphics, jCLineStyle, d3);
                } else {
                    this.drawGridLine(graphics, jCLineStyle, jCValueLabel.value);
                }
            }
            ++n2;
        }
        jCLineStyle.resetGraphics(graphics);
    }

    private double[] getGridLinesAtLabelsList() {
        double[] dArray = new double[this.annoHandler.valueLabels.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.visible) {
                dArray[n] = jCValueLabel.value;
                ++n;
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < this.annoHandler.valueLabels.size()) {
            dArray[n3] = Double.MAX_VALUE;
            ++n3;
        }
        return dArray;
    }

    private boolean drawVertical(Graphics graphics) {
        int n = this.getHeight();
        int n2 = this.getTop();
        int n3 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n3 <= this.chartArea.getPlotRect().x + this.chartArea.getPlotRect().width && n3 >= this.chartArea.getPlotRect().x)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        if (this.isPolar()) {
            this.drawRadialGridLine(graphics, this.polarAxisParams.rAxisAngle);
        } else if (!this.isRadar()) {
            graphics.drawLine(n3, n2, n3, n2 + n);
        }
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    private boolean drawHorizontal(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getLeft();
        int n3 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n3 <= this.chartArea.getPlotRect().y + this.chartArea.getPlotRect().height && n3 >= this.chartArea.getPlotRect().y)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        if (this.isPolar()) {
            int n4 = (int)Math.round(this.polarAxisParams.radius);
            int n5 = 2 * n4;
            int n6 = (int)Math.round(this.polarAxisParams.xCenter) - n4;
            int n7 = (int)Math.round(this.polarAxisParams.yCenter) - n4;
            graphics.drawArc(n6, n7, n5, n5, 0, 360);
        } else if (!this.isRadar()) {
            graphics.drawLine(n2, n3, n2 + n, n3);
        }
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    private Point drawWebSegment(Graphics graphics, JCLineStyle jCLineStyle, double d, double d2, Point point) {
        if (point == null) {
            point = this.toPixelPolar(0.0, d, false);
        }
        Point point2 = this.toPixelPolar(d2, d, false);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.draw(new Line2D.Double(point.x, point.y, point2.x, point2.y));
        return point2;
    }

    protected void drawWebLine(Graphics graphics, JCLineStyle jCLineStyle, double d, int n) {
        double d2 = JCChartUtil.getRadarAngle(2, n, 1, false);
        Point point = null;
        int n2 = 0;
        while (n2 < n) {
            point = this.drawWebSegment(graphics, jCLineStyle, d, (double)n2 * d2, point);
            ++n2;
        }
        this.drawWebSegment(graphics, jCLineStyle, d, 0.0, point);
    }

    private Graphics clipToExtents(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Extents extents = this.getExtents();
        if (this.vertical) {
            graphics2.clipRect(0, Math.max(0, this.getTop() - extents.minor), this.chartArea.getDrawingArea().width + 1, Math.min(this.chartArea.getDrawingArea().height, this.getHeight() + extents.major + extents.minor) + 1);
        } else {
            graphics2.clipRect(Math.max(0, this.getLeft() - extents.minor), 0, Math.min(this.chartArea.getDrawingArea().width, this.getWidth() + extents.major + extents.minor) + 1, this.chartArea.getDrawingArea().height + 1);
        }
        return graphics2;
    }

    public Color getForeground() {
        return this.foreground == null ? (this.chartArea == null ? (this.parentChart == null ? null : this.parentChart.getForeground()) : this.chartArea.getForeground()) : this.foreground;
    }

    public Color getBackground() {
        return this.chartArea == null ? (this.parentChart == null ? null : (this.parentChart.isOpaque() ? this.parentChart.getBackground() : null)) : (this.chartArea.isOpaque() ? this.chartArea.getBackground() : null);
    }

    public Font getFont() {
        return this.font == null ? (this.chartArea == null ? (this.parentChart == null ? null : this.parentChart.getFont()) : this.chartArea.getFont()) : this.font;
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    public AnnotationHandler getAnnotationHandler() {
        return this.annoHandler;
    }

    public void setYAxisAngle(int n, double d) {
        this.polarAxisParams.setRadialAxisAngle(n, d);
        this.setChanged(true, 2);
    }

    public double getYAxisAngle(int n) {
        return this.polarAxisParams.getRadialAxisAngle(n);
    }

    public void setOriginBase(int n, double d) {
        this.polarAxisParams.setOriginBase(n, d);
        this.setChanged(true, 2);
    }

    public double getOriginBase(int n) {
        return this.polarAxisParams.getOriginBase(n);
    }

    public void setHalfRange(boolean bl) {
        this.polarAxisParams.setPolarHalfRange(bl);
        this.setChanged(true, 2);
    }

    public boolean isHalfRange() {
        return this.polarAxisParams.isPolarHalfRange();
    }

    public void setRadarCircularGrid(boolean bl) {
        this.polarAxisParams.setCircularGrid(bl);
        this.setChanged(true, 2);
    }

    public boolean isRadarCircularGrid() {
        return this.polarAxisParams.isCircularGrid();
    }

    public Point2D.Double getPolarRadarCenter() {
        return new Point2D.Double(this.polarAxisParams.xCenter, this.polarAxisParams.yCenter);
    }

    public double getPolarRadarRadius() {
        return this.polarAxisParams.radius;
    }
}

