/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.CachedSeriesProps;
import com.klg.jclass.chart.CachedViewProps;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCCandleChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCHLOCChartFormat;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.PieChartInfo;
import com.klg.jclass.chart.PieData;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class JCChartLegendManager
implements JCLegendPopulator,
JCLegendRenderer,
Serializable {
    protected List legendItems = null;
    protected transient CachedViewProps[] cachedView = null;
    protected JCChart chart;

    public JCChartLegendManager(JCChart jCChart) {
        this.chart = jCChart;
    }

    public List getLegendItems(FontMetrics fontMetrics) {
        this.legendItems = new Vector();
        int n = this.chart.getOriginalDataView().size();
        int n2 = 0;
        while (n2 < n) {
            this.legendItems.add(new Vector());
            ++n2;
        }
        JCLegend jCLegend = this.chart.getLegend();
        this.cachedView = new CachedViewProps[n];
        int n3 = 0;
        while (n3 < n) {
            List list = (List)this.legendItems.get(n3);
            ChartDataView chartDataView = (ChartDataView)this.chart.getOriginalDataView().get(n3);
            List list2 = chartDataView.getSeries();
            this.cachedView[n3] = new CachedViewProps();
            this.cacheViewProperties(this.cachedView[n3], chartDataView, list2);
            chartDataView.calcTransientData();
            if (list2 != null) {
                int n4 = chartDataView.getNumSeriesPerData();
                int n5 = list2.size() / n4;
                if (n5 != 0) {
                    int n6 = chartDataView.getChartType();
                    if (chartDataView.isVisibleInLegend()) {
                        Object object = chartDataView.getName();
                        JCLegendItem[] jCLegendItemArray = new JCLegendItem();
                        if (TextRenderer.isHTML((String)object)) {
                            jCLegendItemArray.textDim = jCLegend.getTextRenderer().calcHTMLTextSize((String)object);
                            jCLegendItemArray.contents = object;
                        } else if (object != null && ((String)object).length() > 0) {
                            jCLegendItemArray.textDim = new Dimension(fontMetrics.stringWidth((String)object), fontMetrics.getHeight());
                            jCLegendItemArray.contents = object;
                        } else {
                            jCLegendItemArray.textDim = new Dimension(0, 0);
                            jCLegendItemArray.contents = null;
                        }
                        jCLegendItemArray.itemInfo = new JCDataIndex(chartDataView, null, -1, -1);
                        list.add(jCLegendItemArray);
                        if (n6 == 11) {
                            object = (PieChartInfo)chartDataView.getTransientData();
                            if (object != null) {
                                jCLegendItemArray = new JCLegendItem[list2.size() + 1];
                                int n7 = 0;
                                while (n7 < ((PieChartInfo)object).num_pies) {
                                    PieData pieData = ((PieChartInfo)object).data[n7];
                                    int n8 = 0;
                                    while (n8 < pieData.num_slices_pie) {
                                        Serializable serializable;
                                        Object object2;
                                        if (pieData.other_flag != 0 && n8 == pieData.other_slice) {
                                            if (jCLegendItemArray[list2.size()] == null) {
                                                JCLegendItem jCLegendItem = new JCLegendItem();
                                                jCLegendItem.itemInfo = new JCDataIndex(chartDataView, null, -10, -1);
                                                object2 = ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherLabel();
                                                if (TextRenderer.isHTML((String)object2)) {
                                                    jCLegendItem.textDim = jCLegend.getTextRenderer().calcHTMLTextSize((String)object2);
                                                    jCLegendItem.contents = object2;
                                                } else {
                                                    jCLegendItem.textDim = new Dimension(fontMetrics.stringWidth((String)object2), fontMetrics.getHeight());
                                                    jCLegendItem.contents = object2;
                                                }
                                                serializable = ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle();
                                                this.calcSymbolSize(jCLegendItem, (JCChartStyle)serializable, n6);
                                                jCLegendItemArray[list2.size()] = jCLegendItem;
                                            }
                                        } else {
                                            int n9 = pieData.percents[n8].index;
                                            if (n9 >= 0 && jCLegendItemArray[n9] == null && ((ChartDataViewSeries)(object2 = (ChartDataViewSeries)list2.get(n9))).isVisible() && ((ChartDataViewSeries)object2).isVisibleInLegend()) {
                                                serializable = new JCLegendItem();
                                                serializable.itemInfo = new JCDataIndex(chartDataView, (ChartDataViewSeries)object2, n9, -1);
                                                String string = ((ChartDataViewSeries)object2).getLabel();
                                                if (TextRenderer.isHTML(string)) {
                                                    serializable.textDim = jCLegend.getTextRenderer().calcHTMLTextSize(string);
                                                    serializable.contents = string;
                                                } else {
                                                    serializable.textDim = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
                                                    serializable.contents = string;
                                                }
                                                this.calcSymbolSize((JCLegendItem)serializable, ((ChartDataViewSeries)object2).getStyle(), n6);
                                                jCLegendItemArray[n9] = serializable;
                                            }
                                        }
                                        ++n8;
                                    }
                                    ++n7;
                                }
                                int n10 = 0;
                                while (n10 < jCLegendItemArray.length) {
                                    if (jCLegendItemArray[n10] != null) {
                                        list.add(jCLegendItemArray[n10]);
                                    }
                                    ++n10;
                                }
                            }
                        } else {
                            int n11 = 0;
                            while (n11 < n5) {
                                int n12 = n11 * n4;
                                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list2.get(n12);
                                JCLegendItem jCLegendItem = new JCLegendItem();
                                jCLegendItem.itemInfo = new JCDataIndex(chartDataView, chartDataViewSeries, n12, -1);
                                String string = null;
                                int n13 = 0;
                                int n14 = 0;
                                string = chartDataViewSeries.getLabel();
                                if (TextRenderer.isHTML(string)) {
                                    Dimension dimension = jCLegend.getTextRenderer().calcHTMLTextSize(string);
                                    jCLegendItem.contents = string;
                                    n14 = dimension.width;
                                    n13 = dimension.height;
                                } else {
                                    n14 = fontMetrics.stringWidth(string);
                                    n13 = fontMetrics.getHeight();
                                    jCLegendItem.contents = string;
                                }
                                boolean bl = true;
                                int n15 = n12;
                                int n16 = 0;
                                while (n16 < n4) {
                                    if (!((ChartDataViewSeries)list2.get(n15)).isVisibleInLegend()) {
                                        bl = false;
                                        break;
                                    }
                                    ++n16;
                                    ++n15;
                                }
                                if (bl && chartDataViewSeries.isVisibleInLegend()) {
                                    jCLegendItem.textDim = new Dimension(n14, n13);
                                    this.calcSymbolSize(jCLegendItem, chartDataViewSeries.getStyle(), n6);
                                    list.add(jCLegendItem);
                                }
                                ++n11;
                            }
                        }
                    }
                }
            }
            ++n3;
        }
        return this.legendItems;
    }

    protected void calcSymbolSize(JCLegendItem jCLegendItem, JCChartStyle jCChartStyle, int n) {
        Image image = null;
        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
        if (!((n != 9 && n != 10 || jCFillStyle.getPattern() != 12 && jCFillStyle.getPattern() != 11) && (n != 8 && n != 12 && n != 11 && n != 4 || jCFillStyle.getPattern() != 11) || (image = jCFillStyle.getImage()) == null)) {
            if (jCFillStyle.getPattern() == 12) {
                jCLegendItem.drawType = 2;
            } else if (jCFillStyle.getPattern() == 11) {
                jCLegendItem.drawType = 3;
            }
            jCLegendItem.symbolDim = new Dimension(image.getWidth(null), image.getHeight(null));
        } else {
            jCLegendItem.drawType = n == 8 || n == 9 || n == 12 || n == 10 || n == 11 || n == 4 ? 1 : 4;
            JCLegend jCLegend = this.chart.getLegend();
            jCLegendItem.symbolDim = new Dimension(jCLegend.getSymbolSize(), jCLegend.getSymbolSize());
        }
        jCLegendItem.symbol = image;
    }

    void cacheViewProperties(CachedViewProps cachedViewProps, ChartDataView chartDataView, List list) {
        cachedViewProps.view = chartDataView;
        cachedViewProps.visible = chartDataView.isVisible();
        cachedViewProps.visibleInLegend = chartDataView.isVisibleInLegend();
        cachedViewProps.chartType = chartDataView.getChartType();
        cachedViewProps.seriesPerData = chartDataView.getNumSeriesPerData();
        cachedViewProps.inverted = chartDataView.getXAxis().vertical;
        cachedViewProps.outlineColor = chartDataView.getOutlineColor();
        if (list == null) {
            cachedViewProps.seriesList = null;
            cachedViewProps.seriesProps = null;
            return;
        }
        cachedViewProps.seriesList = list;
        cachedViewProps.seriesProps = new CachedSeriesProps[list.size()];
        int n = 0;
        while (n < list.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n);
            cachedViewProps.seriesProps[n] = new CachedSeriesProps();
            cachedViewProps.seriesProps[n].series = chartDataViewSeries;
            cachedViewProps.seriesProps[n].visible = chartDataViewSeries.isVisible();
            cachedViewProps.seriesProps[n].visibleInLegend = chartDataViewSeries.isVisibleInLegend();
            ++n;
        }
    }

    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    public void drawLegendItemSymbol(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        block40: {
            int n;
            int n2;
            ChartDataView chartDataView;
            Color color;
            int n3;
            block39: {
                CachedViewProps cachedViewProps = null;
                boolean bl = false;
                n3 = 0;
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = false;
                boolean bl5 = false;
                color = null;
                chartDataView = ((JCDataIndex)jCLegendItem.itemInfo).getDataView();
                if (chartDataView != null) {
                    int n4 = 0;
                    while (n4 < this.cachedView.length) {
                        if (this.cachedView[n4].view == chartDataView) {
                            cachedViewProps = this.cachedView[n4];
                            bl = cachedViewProps.inverted;
                            n3 = cachedViewProps.chartType;
                            bl2 = true;
                            bl3 = true;
                            bl4 = false;
                            color = cachedViewProps.outlineColor;
                            if (n3 == 6) {
                                JCHLOCChartFormat jCHLOCChartFormat = (JCHLOCChartFormat)chartDataView.getChartFormat();
                                bl2 = jCHLOCChartFormat.isShowingOpen();
                                bl3 = jCHLOCChartFormat.isShowingClose();
                                bl4 = jCHLOCChartFormat.isOpenCloseFullWidth();
                            }
                            if (n3 != 7) break;
                            bl5 = ((JCCandleChartFormat)chartDataView.getChartFormat()).isComplex();
                            break;
                        }
                        ++n4;
                    }
                }
                JCLegend jCLegend = this.chart.getLegend();
                if (graphics.getColor() != jCLegend.getForeground()) {
                    graphics.setColor(jCLegend.getForeground());
                }
                if (graphics.getFont() != font) {
                    graphics.setFont(font);
                }
                if (color == null) {
                    color = this.chart.getChartArea().getForeground();
                }
                n2 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
                n = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
                int n5 = Math.min(jCLegendItem.symbolDim.width, jCLegendItem.symbolDim.height);
                ChartDataViewSeries chartDataViewSeries = ((JCDataIndex)jCLegendItem.itemInfo).getSeries();
                if (chartDataViewSeries == null) break block39;
                JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                JCLineStyle jCLineStyle2 = new JCLineStyle(1, jCLineStyle.getColor(), jCLineStyle.getPattern(), jCLineStyle.getCap(), jCLineStyle.getJoin(), jCLineStyle.getCustomPatternArray(), jCLineStyle.getCustomLegendPatternArray());
                switch (chartDataView.getChartType()) {
                    case 0: 
                    case 2: 
                    case 3: {
                        if (jCLineStyle2.updateGraphics(graphics, jCLegendItem.symbolDim.width - 1)) {
                            ((Graphics2D)graphics).draw(new Line2D.Double(n2, n + jCLegendItem.symbolDim.height / 2, n2 + jCLegendItem.symbolDim.width - 1, n + jCLegendItem.symbolDim.height / 2));
                            jCLineStyle2.resetGraphics(graphics);
                        }
                    }
                    case 1: {
                        jCChartStyle.getSymbolStyle().draw(graphics, n2 + jCLegendItem.symbolDim.width / 2, n + jCLegendItem.symbolDim.height / 2, jCLegendItem.symbolDim.width);
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    case 5: 
                    case 6: {
                        if (jCLineStyle2.updateGraphics(graphics)) {
                            int n6;
                            int n7;
                            int n8;
                            int n9;
                            if (bl) {
                                n9 = n2;
                                n8 = n2 + (jCLegendItem.symbolDim.width - 1);
                                n6 = n7 = n + n5 / 2;
                            } else {
                                n9 = n8 = n2 + jCLegendItem.symbolDim.width / 2;
                                n6 = n;
                                n7 = n + n5;
                            }
                            ((Graphics2D)graphics).draw(new Line2D.Double(n9, n6, n8, n7));
                            if (n3 != 5) {
                                if (bl2) {
                                    if (bl) {
                                        n9 = n8 = n2 + 2;
                                        n6 = n + 1;
                                        n7 = bl4 ? n + n5 - 2 : n + n5 / 2;
                                    } else {
                                        n9 = n2 + 2;
                                        n8 = bl4 ? n2 - 3 + jCLegendItem.symbolDim.width : n2 + jCLegendItem.symbolDim.width / 2;
                                        n6 = n7 = n + (int)Math.round(2.0 * (double)n5 / 3.0);
                                    }
                                    ((Graphics2D)graphics).draw(new Line2D.Double(n9, n6, n8, n7));
                                }
                                if (bl3) {
                                    if (bl) {
                                        n9 = n8 = n2 - 3 + jCLegendItem.symbolDim.width;
                                        n6 = bl4 ? n + 1 : n + n5 / 2;
                                        n7 = n + n5 - 2;
                                    } else {
                                        n9 = bl4 ? n2 + 2 : n2 + jCLegendItem.symbolDim.width / 2;
                                        n8 = n2 - 3 + jCLegendItem.symbolDim.width;
                                        n6 = n7 = n + n5 / 3;
                                    }
                                    ((Graphics2D)graphics).draw(new Line2D.Double(n9, n6, n8, n7));
                                }
                                jCLineStyle2.resetGraphics(graphics);
                                break;
                            }
                        }
                        break block40;
                    }
                    case 7: {
                        JCLineStyle jCLineStyle3;
                        Serializable serializable;
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15 = n14 = jCLegendItem.symbolDim.width % 2 == 0 ? jCLegendItem.symbolDim.width : jCLegendItem.symbolDim.width - 1;
                        if (bl) {
                            n13 = n2;
                            n12 = n2 + 2;
                            n10 = n11 = n + n5 / 2;
                        } else {
                            n13 = n12 = n2 + n14 / 2;
                            n10 = n;
                            n11 = n + n5 / 3;
                        }
                        if (jCLineStyle2.updateGraphics(graphics)) {
                            ((Graphics2D)graphics).draw(new Line2D.Double(n13, n10, n12, n11));
                            if (bl) {
                                n13 = n2 - 3 + n14;
                                n12 = n2 + (n14 - 1);
                                n10 = n11 = n + n5 / 2;
                            } else {
                                n13 = n12 = n2 + n14 / 2;
                                n10 = n + n5 * 2 / 3;
                                n11 = n + n5;
                            }
                            ((Graphics2D)graphics).draw(new Line2D.Double(n13, n10, n12, n11));
                            jCLineStyle2.resetGraphics(graphics);
                        }
                        if (bl) {
                            n13 = n2 + 3;
                            n10 = n + 3;
                            n12 = n14 - 7;
                            n11 = n5 - 7;
                        } else {
                            n13 = n2 + 3;
                            n10 = n + n5 / 3;
                            n12 = n14 - 6;
                            n11 = (int)Math.round((double)n5 / 3.0);
                        }
                        JCChartStyle jCChartStyle2 = jCChartStyle;
                        JCChartStyle jCChartStyle3 = jCChartStyle;
                        if (bl5) {
                            serializable = (JCCandleChartFormat)chartDataView.getChartFormat();
                            int n16 = ((JCDataIndex)jCLegendItem.itemInfo).getSeriesIndex();
                            jCChartStyle2 = ((JCCandleChartFormat)serializable).getRisingCandleStyle(n16 / cachedViewProps.seriesPerData);
                            jCChartStyle3 = ((JCCandleChartFormat)serializable).getCandleOutlineStyle(n16 / cachedViewProps.seriesPerData);
                            jCChartStyle2.getFillStyle().fillRect(graphics, n13, n10, n12, n11);
                        }
                        if ((jCLineStyle3 = new JCLineStyle(1, ((JCLineStyle)(serializable = jCChartStyle3.getLineStyle())).getColor(), ((JCLineStyle)serializable).getPattern(), ((JCLineStyle)serializable).getCap(), ((JCLineStyle)serializable).getJoin(), jCLineStyle.getCustomPatternArray(), jCLineStyle.getCustomLegendPatternArray())).updateGraphics(graphics)) {
                            ((Graphics2D)graphics).draw(new Rectangle2D.Double(n13, n10, n12, n11));
                            jCLineStyle3.resetGraphics(graphics);
                            break;
                        }
                        break block40;
                    }
                    default: {
                        if (jCLineStyle2.updateGraphics(graphics)) {
                            ((Graphics2D)graphics).draw(new Line2D.Double(n2, n - jCLegendItem.symbolDim.height / 2, n2 + jCLegendItem.symbolDim.width, n - jCLegendItem.symbolDim.height / 2));
                            jCLineStyle2.resetGraphics(graphics);
                            break;
                        }
                        break block40;
                    }
                }
                break block40;
            }
            if (chartDataView != null) {
                switch (n3) {
                    case 11: {
                        ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle().getFillStyle().fillOutlineRect(graphics, n2, n, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1, color);
                    }
                }
            }
        }
    }

    public void drawLegendItemText(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    public Color getOutlineColor(JCLegendItem jCLegendItem) {
        return this.chart.getChartArea().getForeground();
    }

    public void setFillGraphics(Graphics graphics, JCLegendItem jCLegendItem) {
        ChartDataView chartDataView = ((JCDataIndex)jCLegendItem.itemInfo).getDataView();
        ChartDataViewSeries chartDataViewSeries = ((JCDataIndex)jCLegendItem.itemInfo).getSeries();
        if (chartDataViewSeries != null) {
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            jCChartStyle.getFillStyle().updateGraphics(graphics);
        } else if (chartDataView != null && chartDataView.getChartType() == 11) {
            ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle().getFillStyle().updateGraphics(graphics);
        }
    }

    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        JCDataIndex jCDataIndex = (JCDataIndex)jCLegendItem.itemInfo;
        return jCLegendItem.symbolDim == null && (jCDataIndex == null || jCDataIndex.getSeries() == null);
    }
}

