/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.ImageMapShape;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.Mapper;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.PieChartInfo;
import com.klg.jclass.chart.PieData;
import com.klg.jclass.chart.PiePercent;
import com.klg.jclass.chart.PiePosition;
import com.klg.jclass.chart.PieSortAscending;
import com.klg.jclass.chart.PieSortDescending;
import com.klg.jclass.chart.PieSortPoint;
import com.klg.jclass.chart.PieTagModel;
import com.klg.jclass.chart.ProcessShapeModel;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PieChartDraw
extends ChartDraw {
    public static final int COORD_DEFAULT_VALUE = -2;
    public static final int COORD_ZERO_SLICE = -1;
    public static final int INDEX_HOLE = -2;
    public static final int INDEX_NOT_DRAWN = -1;
    public static final int HIT_NOWHERE = 0;
    public static final int HIT_TOP = 1;
    public static final int HIT_EDGE = 2;
    public static final String ERRMSG_BIG_ERROR = "Big Error!";
    protected PieChartInfo pieInfo = null;
    JCPieChartFormat pcf = null;
    protected int delta_y = 0;
    protected JCLineStyle outlineStyle = null;
    protected int shapeOp = 0;
    protected Picker picker = null;
    protected ProcessShapeModel processShape = null;
    protected Mapper mapper = null;
    protected int num_pies = 0;
    int num_lines = 0;
    protected int num_pies_line = 0;
    protected int box_width = 0;
    protected int box_height = 0;
    int pie_offset = 0;
    int first_point = 0;
    int graph_left = 0;
    int graph_top = 0;
    transient ChartText[] cLabels;
    int label_height = 0;
    int explode_offset = 0;
    protected boolean recalcTransientData = false;

    public void recalc() {
        int n;
        super.recalc();
        this.calcTransientData();
        this.pieInfo = (PieChartInfo)this.dataObject.getTransientData();
        Rectangle rectangle = this.chartArea.getPlotRect();
        this.graph_left = rectangle.x;
        this.graph_top = rectangle.y;
        int n2 = Math.max(rectangle.width - 1, 0);
        int n3 = Math.max(rectangle.height - 1, 0);
        int n4 = this.dataObject.getNumPointLabels();
        String[] stringArray = new String[n4];
        this.cLabels = new ChartText[n4];
        this.label_height = 0;
        int n5 = 0;
        while (n5 < n4) {
            stringArray[n5] = this.dataObject.getPointLabel(n5);
            if (stringArray[n5] != null) {
                this.cLabels[n5] = new ChartText();
                this.cLabels[n5].setText(stringArray[n5]);
                this.cLabels[n5].setParentChart((JCChart)this.chartArea.getParent());
                this.cLabels[n5].setParentRegion(this.chartArea);
                n = this.cLabels[n5].getHeight();
                this.label_height = Math.max(this.label_height, n);
            } else {
                this.cLabels[n5] = null;
            }
            ++n5;
        }
        n = this.dataObject.getNumSeries();
        if (this.num_pies == 0) {
            return;
        }
        int[] nArray = this.pieLayout(this.num_pies, rectangle);
        this.num_lines = nArray[0];
        this.num_pies_line = nArray[1];
        this.box_width = n2 / this.num_pies_line;
        this.box_height = n3 / this.num_lines;
        this.explode_offset = this.pcf.getExplodeList() == null ? 0 : this.pcf.getExplodeOffset();
        int n6 = Math.max(this.box_width - this.label_height * 2 - this.explode_offset * 2 - 2, 0);
        int n7 = Math.max(this.box_height - this.label_height * 2 - this.explode_offset * 2 - 2, 0);
        double d = JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation()));
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = (double)this.chartArea.getDepth() / 100.0;
        int n8 = 0;
        n8 = (double)n6 * (d3 + d4 * d2) < (double)n7 ? n6 : (int)((double)n7 / (d3 + d4 * d2));
        int n9 = (int)((double)n8 * d3);
        this.chartArea.setDeltaX(0);
        this.delta_y = (int)((double)n8 * d4 * d2);
        this.chartArea.setDeltaY(this.delta_y);
        if (n8 != (n8 | 1)) {
            n8 = (n8 | 1) - 2;
        }
        if (n9 != (n9 | 1)) {
            n9 = (n9 | 1) - 2;
        }
        this.pieInfo.width = n8;
        this.pieInfo.height = n9;
        this.pie_offset = (int)((double)(this.box_width - n8) / 2.0);
        if (this.pie_offset < 0) {
            this.pie_offset = 0;
        }
    }

    public void draw(Graphics graphics) {
        if (!this.okToProceed(graphics)) {
            return;
        }
        int n = 0;
        int n2 = this.graph_left;
        int n3 = this.graph_top;
        int n4 = 0;
        while (n4 < this.num_lines) {
            int n5 = 0;
            while (n5 < this.num_pies_line) {
                if (n < this.num_pies) {
                    this.drawPie(graphics, n, n2, n3);
                }
                ++n;
                n2 += this.box_width;
                ++n5;
            }
            n2 = this.graph_left;
            n3 += this.box_height;
            ++n4;
        }
    }

    protected void drawSinglePie(Graphics graphics, int n, int n2, int n3) {
        if (!this.okToProceed(graphics)) {
            return;
        }
        this.drawPie(graphics, n, n2, n3);
    }

    private boolean okToProceed(Graphics graphics) {
        if (this.shapeOp != 2) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null && (rectangle.width == 0 || rectangle.height == 0)) {
                return false;
            }
            Rectangle rectangle2 = this.chartArea.getPlotRect();
            graphics.translate(rectangle2.x, rectangle2.y);
        }
        if (this.pieInfo == null) {
            this.recalc();
        }
        return this.num_pies != 0;
    }

    private void drawPie(Graphics graphics, int n, int n2, int n3) {
        Serializable serializable;
        int n4 = n2 + this.pie_offset;
        int n5 = n3 + (this.box_height - this.pieInfo.height - this.delta_y - this.label_height) / 2;
        this.outlineStyle = this.dataObject.getOutlineStyle();
        switch (this.shapeOp) {
            case 1: {
                this.picker.setPieData(this.pieInfo.data[n]);
                this.processShape = new PickShape(this.picker);
                break;
            }
            case 2: {
                this.mapper.setPieData(this.pieInfo.data[n]);
                this.processShape = new ImageMapShape(this.mapper);
                break;
            }
            default: {
                this.processShape = new RenderShape(graphics, this.outlineStyle, null);
            }
        }
        if (!this.pieInfo.data[n].zero_pie) {
            serializable = new Rectangle(this.pieInfo.pos[n].cx, this.pieInfo.pos[n].cy, this.pieInfo.width, this.pieInfo.height);
            if (this.delta_y != 0) {
                this.drawPiePlane(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n4, n5 + this.delta_y, n, false, (Rectangle)serializable);
                this.drawPieEdge(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n4, n5, n, (Rectangle)serializable);
            }
            this.drawPiePlane(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n4, n5, n, true, (Rectangle)serializable);
            this.drawPieLines(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n4, n5, n);
        }
        if (this.shapeOp == 0 && n + this.first_point < this.cLabels.length && (serializable = this.cLabels[n + this.first_point]) != null) {
            int n6 = ((ChartInteriorRegion)serializable).getWidth();
            int n7 = ((ChartInteriorRegion)serializable).getHeight();
            ((ChartInteriorRegion)serializable).setLocation(n2 + (this.box_width - n6) / 2, n5 + this.pieInfo.height + this.delta_y + this.explode_offset);
            ((ChartText)serializable).draw(graphics);
        }
        if (!this.pieInfo.data[n].zero_pie) {
            this.drawPieCircle(graphics, this.seriesList, this.pieInfo.data[n], this.pieInfo, n4, n5, n);
        }
    }

    private int[] pieLayout(int n, Rectangle rectangle) {
        int n2 = rectangle.height == 0 ? n : (int)Math.min((double)n, Math.sqrt(n) * (double)rectangle.width / (double)rectangle.height);
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = (int)Math.min((double)(rectangle.width / n2), (double)rectangle.height / Math.ceil((double)n / (double)n2));
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!bl) {
            int n4 = n2;
            n4 = bl2 ? ++n4 : --n4;
            if (n4 > n) {
                if (bl3 || bl4) {
                    bl = true;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (n4 == 0) {
                bl = true;
                continue;
            }
            int n5 = (int)Math.min((double)(rectangle.width / n4), (double)rectangle.height / Math.ceil((double)n / (double)n4));
            if (n5 > n3) {
                n2 = n4;
                n3 = n5;
                if (bl2) {
                    bl3 = true;
                    continue;
                }
                bl4 = true;
                continue;
            }
            if (bl3 || bl4) {
                bl = true;
                continue;
            }
            if (bl2) {
                bl2 = false;
                continue;
            }
            bl = true;
        }
        int n6 = n / n2;
        if ((double)n6 != (double)n / (double)n2) {
            // empty if block
        }
        int[] nArray = new int[]{++n6, n2};
        return nArray;
    }

    private int computeOtherSlice(List list, int n, int n2, PieData pieData) {
        double d;
        Point[] pointArray;
        int n3 = Math.min(n2, this.pcf.getMinSlices());
        double d2 = this.pcf.getThresholdValue() / 100.0;
        double d3 = this.dataObject.getHoleValue();
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            pointArray = (Point[])list.get(n4);
            double d5 = pointArray.getX(n);
            d = pointArray.getY(n);
            pieData.sortPoints[n4].index = n4;
            if (d == d3 || d5 == d3 || !pointArray.isVisible()) {
                d = -1.0;
                pieData.sortPoints[n4].index = -2;
            } else if (d < 0.0) {
                d = 0.0;
            } else {
                d4 += d;
            }
            pieData.sortPoints[n4].y = d;
            ++n4;
        }
        pieData.zero_pie = d4 == 0.0;
        pointArray = this.pcf.getExplodeList();
        if (pointArray != null) {
            int n5 = 0;
            while (n5 < pointArray.length) {
                if (n == pointArray[n5].x) {
                    if (pointArray[n5].y == -10) {
                        pieData.exploded[pieData.exploded.length - 1] = true;
                    } else if (pointArray[n5].y < n2) {
                        pieData.exploded[pointArray[n5].y] = true;
                    }
                }
                ++n5;
            }
        }
        switch (this.pcf.sortOrder) {
            case 1: {
                if (pieData.sortPoints == null) break;
                Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending());
                break;
            }
            case 2: {
                if (pieData.sortPoints == null) break;
                Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortDescending());
                break;
            }
        }
        int n6 = 0;
        while (n6 < n2) {
            pieData.percents[n6].pct = pieData.sortPoints[n6].y >= 0.0 ? (pieData.zero_pie ? 0.0 : pieData.sortPoints[n6].y / d4) : 0.0;
            pieData.percents[n6].index = pieData.sortPoints[n6].index;
            ++n6;
        }
        if (n2 == n3) {
            pieData.num_slices_pie = n2;
            pieData.other_flag = 0;
            return pieData.other_flag;
        }
        pieData.other_slice = -1;
        boolean bl = false;
        d = 0.0;
        int n7 = 0;
        int n8 = n2;
        boolean bl2 = true;
        switch (this.pcf.sortOrder) {
            case 1: {
                int n9 = 0;
                while (n9 < n2) {
                    if (n2 - n9 < n3) break;
                    if (pieData.sortPoints[n9].y >= 0.0) {
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                bl2 = d + pieData.percents[n9].pct < d2;
                                break;
                            }
                            case 0: {
                                bl2 = pieData.percents[n9].pct < d2;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        pieData.percents[n9].pct += d;
                        d = pieData.percents[n9].pct;
                        bl = true;
                        n7 = n9;
                    }
                    ++n9;
                }
                if (!bl) break;
                if (pieData.percents[n7].pct > 0.0) {
                    n8 = n2 - n7;
                    pieData.other_slice = n8 - 1;
                    pieData.percents[n2].pct = pieData.percents[n7].pct;
                    pieData.percents[n2].index = n2;
                } else {
                    n8 = n2 - n7 - 1;
                    bl = false;
                }
                int n10 = n7 + 1;
                while (n10 <= n2) {
                    pieData.percents[n10 - n7 - 1].pct = pieData.percents[n10].pct;
                    pieData.percents[n10 - n7 - 1].index = pieData.percents[n10].index;
                    ++n10;
                }
                break;
            }
            case 2: {
                n7 = n2 - 1;
                int n11 = n2 - 1;
                while (n11 >= 0) {
                    if (n11 + 1 < n3) break;
                    if (pieData.sortPoints[n11].y >= 0.0) {
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                bl2 = d + pieData.percents[n11].pct < d2;
                                break;
                            }
                            case 0: {
                                bl2 = pieData.percents[n11].pct < d2;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (!bl2) break;
                    pieData.percents[n11].pct += d;
                    d = pieData.percents[n11].pct;
                    n7 = n11--;
                    bl = true;
                }
                if (!bl) break;
                if (pieData.percents[n7].pct > 0.0) {
                    pieData.percents[n7].index = n2;
                    n8 = n7 + 1;
                    pieData.other_slice = n7;
                    break;
                }
                n8 = n7;
                bl = false;
                break;
            }
            case 0: {
                if (pieData.sortPoints != null) {
                    Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending());
                }
                pieData.percents[n2].pct = 0.0;
                pieData.percents[n2].index = n2;
                int n12 = 0;
                while (n12 < n2) {
                    if (n8 < n3) break;
                    double d6 = 0.0;
                    if (pieData.sortPoints[n12].y >= 0.0) {
                        d6 = pieData.zero_pie ? 0.0 : pieData.sortPoints[n12].y / d4;
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                bl2 = d + d6 < d2;
                                break;
                            }
                            case 0: {
                                bl2 = d6 < d2;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        pieData.percents[n8].pct += d6;
                        d = pieData.percents[n8].pct;
                        n7 = 0;
                        while (n7 < n8) {
                            if (pieData.percents[n7].pct == d6) {
                                ++n7;
                                break;
                            }
                            ++n7;
                        }
                        while (n7 <= n8) {
                            pieData.percents[n7 - 1].pct = pieData.percents[n7].pct;
                            pieData.percents[n7 - 1].index = pieData.percents[n7].index;
                            ++n7;
                        }
                        if (d6 > 0.0) {
                            bl = true;
                        }
                        --n8;
                    }
                    ++n12;
                }
                if (!bl) break;
                pieData.other_slice = n8++;
                break;
            }
            default: {
                System.out.println(ERRMSG_BIG_ERROR);
            }
        }
        pieData.num_slices_pie = n8;
        pieData.other_flag = bl ? 1 : 0;
        return pieData.other_flag;
    }

    public void setShapeOperation(int n) {
        this.shapeOp = n;
    }

    public void resetShapeOperation() {
        this.shapeOp = 0;
    }

    private void tagData(PieTagModel pieTagModel, int n, int n2) {
        int n3 = -1;
        ChartDataViewSeries chartDataViewSeries = null;
        if (pieTagModel.getPieData().other_flag != 0 && n == pieTagModel.getPieData().other_slice) {
            n3 = -10;
        } else {
            n3 = pieTagModel.getPieData().percents[n].index;
            chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n);
        }
        pieTagModel.setDataIndex(new JCDataIndex(this.dataObject, chartDataViewSeries, n3, n2));
    }

    private void drawPiePlane(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3, boolean bl, Rectangle rectangle) {
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        double d = this.pcf.getStartAngle();
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < pieData.num_slices_pie) {
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n4);
            if (this.shapeOp == 1) {
                this.tagData(this.picker, n4, n3);
            } else if (this.shapeOp == 2) {
                this.tagData(this.mapper, n4, n3);
            } else if (this.shapeOp == 0) {
                ((RenderShape)this.processShape).setFillStyle(jCFillStyle);
            }
            double d3 = pieData.percents[n4].pct * 360.0;
            if (n4 == pieData.lastDrawnSlice) {
                if (d2 >= 360.0) {
                    d3 = 0.0;
                } else {
                    d3 = d - this.pcf.getStartAngle();
                    if (d3 < 0.0 || d3 == 0.0 && d2 == 0.0) {
                        d3 += 360.0;
                    }
                }
            }
            if (d3 != 0.0) {
                if (pieData.exploded[pieData.percents[n4].index]) {
                    double d4 = d3 / 2.0;
                    this.calcExplodeOffset(d, d4, this.explode_offset, pieChartInfo.pos[n3].offset[n4]);
                }
                Point point = pieChartInfo.pos[n3].offset[n4];
                this.processShape.updateFillOrientation(rectangle, 5);
                if (defineShape != null) {
                    JCDataIndex jCDataIndex = null;
                    jCDataIndex = n4 == pieData.other_slice ? new JCDataIndex(this.dataObject, null, -10, n3) : new JCDataIndex(n3, (ChartDataViewSeries)list.get(pieData.percents[n4].index));
                    defineShape.beginShape(jCDataIndex);
                }
                if (bl) {
                    this.processShape.fillArc(n + point.x, n2 + point.y, pieChartInfo.width, pieChartInfo.height, d, -d3);
                } else {
                    this.processShape.fillArcShadow(n + point.x, n2 + point.y, pieChartInfo.width, pieChartInfo.height, d, -d3);
                }
                if (defineShape != null) {
                    defineShape.endShape(true);
                }
                this.processShape.resetFillOrientation();
                d -= d3;
                d2 += d3;
                if (d < 0.0) {
                    d += 360.0;
                }
            }
            ++n4;
        }
    }

    private boolean isSliceVisible() {
        return true;
    }

    private Point2D.Double createPoint(double d, double d2, double d3, double d4, double d5) {
        return new Point2D.Double(d + Math.cos(d3) * d4, d2 - Math.sin(d3) * d5);
    }

    private Point computeExplodeOffset(PieChartInfo pieChartInfo, int n, int n2, double d, double d2) {
        double d3 = d2 / 2.0;
        this.calcExplodeOffset(d, d3, this.explode_offset, pieChartInfo.pos[n].offset[n2]);
        return (Point)pieChartInfo.pos[n].offset[n2].clone();
    }

    private void drawSidePanel(Graphics graphics, JCFillStyle jCFillStyle, Rectangle rectangle, int n, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4, double d) {
        Serializable serializable;
        int n5 = pieChartInfo.width;
        int n6 = pieChartInfo.height;
        double d2 = (double)n5 / 2.0;
        double d3 = (double)n6 / 2.0;
        double d4 = (double)n2 + d2;
        double d5 = (double)n3 + d3;
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        if (this.shapeOp == 1) {
            this.tagData(this.picker, n, n4);
        } else if (this.shapeOp == 2) {
            this.tagData(this.mapper, n, n4);
        } else if (this.shapeOp == 0) {
            ((RenderShape)this.processShape).setFillStyle(jCFillStyle);
        }
        Point2D.Double[] doubleArray = new Point2D.Double[4];
        doubleArray[0] = new Point2D.Double(d4, d5);
        doubleArray[1] = new Point2D.Double(doubleArray[0].x, doubleArray[0].y + (double)this.delta_y);
        d = JCChartUtil.convertAngle(1, 2, d);
        doubleArray[3] = this.createPoint(d4, d5, d, d2, d3);
        doubleArray[2] = new Point2D.Double(doubleArray[3].x, doubleArray[3].y + (double)this.delta_y);
        Shape shape = null;
        if (this.shapeOp == 2) {
            serializable = new Polygon();
            int n7 = 0;
            while (n7 < doubleArray.length) {
                serializable.addPoint((int)Math.round(doubleArray[n7].x), (int)Math.round(doubleArray[n7].y));
                ++n7;
            }
            shape = serializable;
        } else {
            serializable = new GeneralPath();
            ((Path2D.Float)serializable).moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
            int n8 = 1;
            while (n8 < doubleArray.length) {
                ((Path2D.Float)serializable).lineTo((float)doubleArray[n8].x, (float)doubleArray[n8].y);
                ++n8;
            }
            ((Path2D)((Object)serializable)).closePath();
            shape = serializable;
        }
        this.processShape.updateFillOrientation(rectangle, 5);
        if (defineShape != null) {
            serializable = null;
            serializable = n == pieData.other_slice ? new JCDataIndex(this.dataObject, null, -10, n4) : new JCDataIndex(n4, (ChartDataViewSeries)this.seriesList.get(pieData.percents[n].index));
            defineShape.beginShape(serializable);
        }
        this.processShape.fillPolygonShadow(shape);
        if (defineShape != null) {
            defineShape.endShape(true);
        }
        this.processShape.resetFillOrientation();
        this.processShape.drawLine(doubleArray[0].x, doubleArray[0].y, doubleArray[1].x, doubleArray[1].y);
        this.processShape.drawLine(doubleArray[2].x, doubleArray[2].y, doubleArray[3].x, doubleArray[3].y);
        this.processShape.drawLine(doubleArray[1].x, doubleArray[1].y, doubleArray[2].x, doubleArray[2].y);
    }

    private void drawFrontPanel(Graphics graphics, JCFillStyle jCFillStyle, Rectangle rectangle, int n, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4, double d, double d2) {
        Serializable serializable;
        int n5 = pieChartInfo.width;
        int n6 = pieChartInfo.height;
        double d3 = (double)n5 / 2.0;
        double d4 = (double)n6 / 2.0;
        double d5 = (double)n2 + d3;
        double d6 = (double)n3 + d4;
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        if (this.shapeOp == 1) {
            this.tagData(this.picker, n, n4);
        } else if (this.shapeOp == 2) {
            this.tagData(this.mapper, n, n4);
        } else if (this.shapeOp == 0) {
            ((RenderShape)this.processShape).setFillStyle(jCFillStyle);
        }
        Point2D.Double[] doubleArray = new Point2D.Double[4];
        double d7 = JCChartUtil.convertAngle(1, 2, d);
        doubleArray[0] = this.createPoint(d5, d6, d7, d3, d4);
        doubleArray[1] = new Point2D.Double(doubleArray[0].x, doubleArray[0].y + (double)this.delta_y);
        d7 = JCChartUtil.convertAngle(1, 2, d2);
        doubleArray[3] = this.createPoint(d5, d6, d7, d3, d4);
        doubleArray[2] = new Point2D.Double(doubleArray[3].x, doubleArray[3].y + (double)this.delta_y);
        Shape shape = null;
        if (this.shapeOp == 2) {
            serializable = new Polygon();
            int n7 = 0;
            while (n7 < doubleArray.length) {
                serializable.addPoint((int)Math.round(doubleArray[n7].x), (int)Math.round(doubleArray[n7].y));
                ++n7;
            }
            shape = serializable;
        } else {
            serializable = new GeneralPath();
            ((Path2D.Float)serializable).moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
            int n8 = 1;
            while (n8 < doubleArray.length) {
                ((Path2D.Float)serializable).lineTo((float)doubleArray[n8].x, (float)doubleArray[n8].y);
                ++n8;
            }
            ((Path2D)((Object)serializable)).closePath();
            shape = serializable;
        }
        this.processShape.updateFillOrientation(rectangle, 5);
        if (defineShape != null) {
            serializable = null;
            serializable = n == pieData.other_slice ? new JCDataIndex(this.dataObject, null, -10, n4) : new JCDataIndex(n4, (ChartDataViewSeries)this.seriesList.get(pieData.percents[n].index));
            defineShape.beginShape(serializable);
        }
        this.processShape.fillPolygonShadow(shape);
        if (defineShape != null) {
            defineShape.endShape(true);
        }
        this.processShape.resetFillOrientation();
        this.processShape.drawLine(doubleArray[0].x, doubleArray[0].y, doubleArray[1].x, doubleArray[1].y);
        this.processShape.drawLine(doubleArray[2].x, doubleArray[2].y, doubleArray[3].x, doubleArray[3].y);
        this.processShape.drawArc(n2, n3 + this.delta_y, pieChartInfo.width, pieChartInfo.height, d, d2 - d);
    }

    private void drawPieCircle(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3) {
        double d = this.pcf.getStartAngle();
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < pieData.num_slices_pie) {
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n4);
            double d4 = pieData.percents[n4].pct * 360.0;
            if (n4 == pieData.lastDrawnSlice) {
                if (!pieData.exploded[pieData.percents[n4].index]) {
                    d3 = 0.0;
                }
                if (d2 >= 360.0) {
                    d4 = 0.0;
                } else {
                    d4 = d - d3 - this.pcf.getStartAngle();
                    if (d4 < 0.0 || d4 == 0.0 && d2 == 0.0) {
                        d4 += 360.0;
                    }
                }
            }
            if (d4 != 0.0) {
                if (pieData.exploded[pieData.percents[n4].index]) {
                    if (d3 != 0.0) {
                        this.processShape.drawArc(n, n2, pieChartInfo.width, pieChartInfo.height, d, -d3);
                        d -= d3;
                        d2 += d3;
                        if (d < 0.0) {
                            d += 360.0;
                        }
                        d3 = 0.0;
                    }
                    Point point = pieChartInfo.pos[n3].offset[n4];
                    this.processShape.drawArc(n + point.x, n2 + point.y, pieChartInfo.width, pieChartInfo.height, d, -d4);
                    d -= d4;
                    d2 += d4;
                    if (d < 0.0) {
                        d += 360.0;
                    }
                } else {
                    d3 += d4;
                }
            }
            ++n4;
        }
        if (d3 != 0.0) {
            this.processShape.drawArc(n, n2, pieChartInfo.width, pieChartInfo.height, d, -d3);
        }
    }

    private void drawPieEdge(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3, Rectangle rectangle) {
        Point point;
        int n4;
        int n5;
        Object object;
        boolean bl;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        double d3 = this.pcf.getStartAngle();
        if ((d3 = JCChartUtil.boundAngle(1, d3)) > 90.0) {
            d3 -= 360.0;
        }
        pieData.sortPoints = new PieSortPoint[pieData.num_slices_pie + 1];
        int n7 = 0;
        while (n7 < pieData.num_slices_pie) {
            d2 = pieData.percents[n7].pct * 360.0;
            d = d3 - d2;
            if (d <= -270.0) {
                d += 360.0;
            }
            pieData.sortPoints[n7] = new PieSortPoint(d3, n7);
            if ((d3 > 90.0 && d3 < 270.0 || d3 > -270.0 && d3 < -90.0) && (d < 90.0 && d > -90.0 || d > 270.0)) {
                n6 = n7;
            }
            d3 = d;
            ++n7;
        }
        pieData.sortPoints[n7] = new PieSortPoint(d3, n7);
        double d4 = pieData.sortPoints[n7 - 1].y;
        if (n6 != Integer.MAX_VALUE) {
            d = pieData.sortPoints[n6].y;
            d2 = pieData.percents[n6].pct * 360.0;
            bl = this.isSliceVisible();
            if (bl && d2 != 0.0) {
                Point point2;
                object = this.getPieSliceFillStyle(pieData, n6);
                n5 = n;
                int n8 = n2;
                if (pieData.exploded[pieData.percents[n6].index]) {
                    point2 = this.computeExplodeOffset(pieChartInfo, n3, n6, d - d2, -d2);
                    n5 += point2.x;
                    n8 += point2.y;
                }
                this.drawSidePanel(graphics, (JCFillStyle)object, rectangle, n6, pieData, pieChartInfo, n5, n8, n3, d - d2);
                n5 = n;
                n8 = n2;
                if (pieData.exploded[pieData.percents[n6].index]) {
                    point2 = this.computeExplodeOffset(pieChartInfo, n3, n6, d, d2);
                    n5 += point2.x;
                    n8 += point2.y;
                }
                this.drawSidePanel(graphics, (JCFillStyle)object, rectangle, n6, pieData, pieChartInfo, n5, n8, n3, d);
            }
        }
        object = pieData.sortPoints[0];
        pieData.sortPoints[0] = new PieSortPoint(Double.MAX_VALUE, 0);
        Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortDescending());
        pieData.sortPoints[0] = object;
        n5 = 0;
        while (n5 < pieData.num_slices_pie) {
            n7 = pieData.sortPoints[++n5].index - 1;
            d = pieData.sortPoints[n5].y;
            if (d < -90.0) break;
            d2 = pieData.percents[n7].pct * 360.0;
            if (d2 == 0.0) continue;
            if (d2 < 0.0) {
                d2 += 360.0;
            }
            if (!(bl = this.isSliceVisible())) continue;
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
            int n9 = n;
            n4 = n2;
            if (pieData.exploded[pieData.percents[n7].index]) {
                Point point3 = this.computeExplodeOffset(pieChartInfo, n3, n7, d + d2, d2);
                n9 += point3.x;
                n4 += point3.y;
            }
            if (d < 0.0) {
                d3 = d + d2;
                if (d3 > 0.0) {
                    d3 = 0.0;
                }
                this.drawFrontPanel(graphics, jCFillStyle, rectangle, n7, pieData, pieChartInfo, n9, n4, n3, d3, d);
            }
            if (n7 == n6) continue;
            this.drawSidePanel(graphics, jCFillStyle, rectangle, n7, pieData, pieChartInfo, n9, n4, n3, d);
        }
        Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending());
        int n10 = 0;
        n10 = 0;
        while (n10 < pieData.num_slices_pie + 1) {
            n7 = pieData.sortPoints[n10].index;
            if (n7 != pieData.num_slices_pie) {
                d3 = pieData.sortPoints[n10].y;
                if (d3 > -90.0) break;
                d2 = pieData.percents[n7].pct * 360.0;
                if (d2 != 0.0) {
                    if (d2 < 0.0) {
                        d2 += 360.0;
                    }
                    if (bl = this.isSliceVisible()) {
                        JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
                        n4 = n;
                        int n11 = n2;
                        if (pieData.exploded[pieData.percents[n7].index]) {
                            point = this.computeExplodeOffset(pieChartInfo, n3, n7, d3, d2);
                            n4 += point.x;
                            n11 += point.y;
                        }
                        if (d3 > -180.0) {
                            d = d3 - d2;
                            if (d < -180.0) {
                                d = -180.0;
                            }
                            this.drawFrontPanel(graphics, jCFillStyle, rectangle, n7, pieData, pieChartInfo, n4, n11, n3, d3, d);
                        }
                        if (n7 != n6) {
                            this.drawSidePanel(graphics, jCFillStyle, rectangle, n7, pieData, pieChartInfo, n4, n11, n3, d3);
                        }
                    }
                }
            }
            ++n10;
        }
        if (pieData.num_slices_pie > 0) {
            double d5;
            if (n10 < pieData.num_slices_pie + 1) {
                d2 = pieData.percents[n7].pct * 360.0;
                d = d3 - d2;
                d5 = d3 > 0.0 ? 0.0 : d3;
            } else {
                n10 = 0;
                while (n10 < pieData.num_slices_pie + 1) {
                    n7 = pieData.sortPoints[n10].index;
                    if (n7 != pieData.num_slices_pie) {
                        d3 = pieData.sortPoints[n10].y;
                        d2 = pieData.percents[n7].pct * 360.0;
                        if (d2 != 0.0) {
                            d = d3 - d2;
                            if (d <= -270.0) {
                                d += 360.0;
                            }
                            if (d2 > 180.0) break;
                        }
                    }
                    ++n10;
                }
                d5 = 0.0;
            }
            if (n10 < pieData.num_slices_pie + 1 && (bl = this.isSliceVisible())) {
                JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n7);
                if (d < -180.0) {
                    d = -180.0;
                }
                n4 = n;
                int n12 = n2;
                if (pieData.exploded[pieData.percents[n7].index]) {
                    point = this.computeExplodeOffset(pieChartInfo, n3, n7, d3, d2);
                    n4 += point.x;
                    n12 += point.y;
                }
                this.drawFrontPanel(graphics, jCFillStyle, rectangle, n7, pieData, pieChartInfo, n4, n12, n3, d5, d);
            }
        }
    }

    private void drawPieLines(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n, int n2, int n3) {
        double d = (double)pieChartInfo.width / 2.0;
        double d2 = (double)pieChartInfo.height / 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = (double)n + d;
        double d6 = (double)n2 + d2;
        double d7 = 0.0;
        double d8 = 0.0;
        pieChartInfo.pos[n3].cx = (int)Math.round(d5);
        pieChartInfo.pos[n3].cy = (int)Math.round(d6);
        int n4 = -1;
        double d9 = this.pcf.getStartAngle();
        double d10 = 0.0;
        int n5 = pieData.lastDrawnSlice;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        while (n6 < pieData.num_slices_pie) {
            double d11 = -1.0;
            double d12 = -1.0;
            bl = n6 == 0 ? false : pieData.exploded[pieData.percents[n5].index];
            double d13 = pieData.percents[n6].pct * 360.0;
            if (n6 == pieData.lastDrawnSlice) {
                if (d10 >= 360.0) {
                    d13 = 0.0;
                } else {
                    d13 = d9 - this.pcf.getStartAngle();
                    if (d13 < 0.0 || d13 == 0.0 && d10 == 0.0) {
                        d13 += 360.0;
                    }
                }
            }
            if (d13 != 0.0) {
                Point point;
                if (d10 == 0.0) {
                    d12 = d5 + Math.cos(JCChartUtil.degToRad(d9)) * d;
                    d11 = d6 - Math.sin(JCChartUtil.degToRad(d9)) * d2;
                    d3 = d12;
                    d4 = d11;
                    bl2 = pieData.exploded[pieData.percents[n6].index];
                } else {
                    d12 = d7;
                    d11 = d8;
                }
                d9 -= d13;
                d10 += d13;
                if (d9 < 0.0) {
                    d9 += 360.0;
                }
                d7 = d5 + Math.cos(JCChartUtil.degToRad(d9)) * d;
                d8 = d6 - Math.sin(JCChartUtil.degToRad(d9)) * d2;
                if (pieData.exploded[pieData.percents[n6].index]) {
                    point = pieChartInfo.pos[n3].offset[n6];
                    this.processShape.drawLine(d5 + (double)point.x, d6 + (double)point.y, d12 + (double)point.x, d11 + (double)point.y);
                } else if (bl) {
                    this.processShape.drawLine(d5, d6, d12, d11);
                }
                if (pieData.exploded[pieData.percents[n6].index]) {
                    point = pieChartInfo.pos[n3].offset[n6];
                    this.processShape.drawLine(d5 + (double)point.x, d6 + (double)point.y, d7 + (double)point.x, d8 + (double)point.y);
                } else {
                    this.processShape.drawLine(d5, d6, d7, d8);
                }
                n5 = n6;
            }
            pieChartInfo.pos[n3].coord[n6].x = (int)Math.round(d12);
            pieChartInfo.pos[n3].coord[n6].y = (int)Math.round(d11);
            if (d12 >= 0.0) {
                int n7 = n6 - 1;
                while (n7 >= 0 && pieChartInfo.pos[n3].coord[n7].x == -1) {
                    pieChartInfo.pos[n3].coord[n7].x = (int)Math.round(d12);
                    pieChartInfo.pos[n3].coord[n7].y = (int)Math.round(d11);
                    --n7;
                }
                n4 = n6;
            }
            ++n6;
        }
        if (!bl2 && pieData.exploded[pieData.percents[n5].index]) {
            this.processShape.drawLine(d5, d6, d3, d4);
        }
        n6 = n4 + 1;
        while (n6 < pieData.num_slices_pie) {
            pieChartInfo.pos[n3].coord[n6].x = pieChartInfo.pos[n3].coord[0].x;
            pieChartInfo.pos[n3].coord[n6].y = pieChartInfo.pos[n3].coord[0].y;
            ++n6;
        }
    }

    private JCFillStyle getPieSliceFillStyle(PieData pieData, int n) {
        JCFillStyle jCFillStyle = null;
        if (n == pieData.other_slice && pieData.other_flag != 0) {
            jCFillStyle = this.pcf.getOtherStyle().getFillStyle();
        } else {
            int n2 = pieData.percents[n].index;
            if (n2 >= 0) {
                jCFillStyle = ((ChartDataViewSeries)this.seriesList.get(n2)).getStyle().getFillStyle();
            }
        }
        return jCFillStyle;
    }

    protected void calcTransientData() {
        int n;
        int n2;
        int n3;
        if (!this.dataObject.isChanged() && this.dataObject.getTransientData() != null && !this.recalcTransientData) {
            return;
        }
        this.recalcTransientData = false;
        this.seriesList = this.dataObject.getSeries();
        this.pcf = (JCPieChartFormat)this.dataObject.getChartFormat();
        int n4 = this.dataObject.getNumSeries();
        Point point = this.dataObject.getFirstLast();
        if (point == null) {
            this.num_pies = 0;
            return;
        }
        this.num_pies = Math.max(point.y - point.x + 1, 0);
        if (this.num_pies == 0) {
            return;
        }
        PieChartInfo pieChartInfo = null;
        pieChartInfo = new PieChartInfo();
        pieChartInfo.pos = new PiePosition[this.num_pies];
        pieChartInfo.data = new PieData[this.num_pies];
        pieChartInfo.num_pies = this.num_pies;
        int n5 = 0;
        while (n5 < this.num_pies) {
            pieChartInfo.pos[n5] = new PiePosition();
            pieChartInfo.pos[n5].coord = new Point[n4 + 1];
            pieChartInfo.pos[n5].offset = new Point[n4 + 1];
            n3 = 0;
            while (n3 <= n4) {
                pieChartInfo.pos[n5].coord[n3] = new Point(-2, -2);
                pieChartInfo.pos[n5].offset[n3] = new Point(0, 0);
                ++n3;
            }
            pieChartInfo.pos[n5].order = new short[n4 + 1];
            pieChartInfo.data[n5] = new PieData();
            pieChartInfo.data[n5].sortPoints = new PieSortPoint[n4];
            n2 = 0;
            while (n2 < n4) {
                pieChartInfo.data[n5].sortPoints[n2] = new PieSortPoint();
                ++n2;
            }
            pieChartInfo.data[n5].percents = new PiePercent[n4 + 1];
            pieChartInfo.data[n5].exploded = new boolean[n4 + 1];
            n = 0;
            while (n < n4 + 1) {
                pieChartInfo.data[n5].percents[n] = new PiePercent();
                pieChartInfo.data[n5].exploded[n] = false;
                ++n;
            }
            ++n5;
        }
        this.first_point = ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
        pieChartInfo.other_flag = 0;
        n3 = 0;
        while (n3 < this.num_pies) {
            n2 = this.computeOtherSlice(this.seriesList, n3 + this.first_point, n4, pieChartInfo.data[n3]);
            n = pieChartInfo.data[n3].other_slice;
            int n6 = pieChartInfo.data[n3].num_slices_pie;
            int n7 = 0;
            while (n7 < n6) {
                pieChartInfo.pos[n3].order[n7] = (short)pieChartInfo.data[n3].percents[n7].index;
                if (pieChartInfo.data[n3].percents[n7].pct > 0.0) {
                    pieChartInfo.data[n3].lastDrawnSlice = n7;
                }
                ++n7;
            }
            while (n7 <= n4) {
                pieChartInfo.pos[n3].order[n7] = -1;
                ++n7;
            }
            if (n2 > 0) {
                pieChartInfo.pos[n3].order[pieChartInfo.data[n3].other_slice] = -10;
            }
            pieChartInfo.other_flag |= n2;
            ++n3;
        }
        this.dataObject.setTransientData(pieChartInfo);
        this.dataObject.setChanged(false, 0);
    }

    protected void setRecalcFlag() {
        this.recalcTransientData = true;
    }

    public JCDataIndex pick(Point point, int n) {
        int n2;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        point.translate(-rectangle.x, -rectangle.y);
        JCDataIndex jCDataIndex = null;
        PieData pieData = new PieData();
        pieData.sortPoints = null;
        pieData.percents = null;
        boolean bl = false;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n3 = this.seriesList.size();
        if (n3 == 0) {
            return jCDataIndex;
        }
        pieData.sortPoints = new PieSortPoint[n3];
        int n4 = 0;
        while (n4 < n3) {
            pieData.sortPoints[n4] = new PieSortPoint();
            ++n4;
        }
        pieData.percents = new PiePercent[n3 + 1];
        pieData.exploded = new boolean[n3 + 1];
        int n5 = 0;
        while (n5 < n3 + 1) {
            pieData.percents[n5] = new PiePercent();
            pieData.exploded[n5] = false;
            ++n5;
        }
        double d = 0.0;
        if (this.pcf.getExplodeList() == null) {
            d = JCChartUtil.degToRad(Math.max(0.0, (double)this.chartArea.getElevation()));
        }
        double d2 = Math.cos(d);
        int n6 = 0;
        int n7 = 0;
        if (this.pieInfo == null || (n6 = this.pieInfo.width) == 0 || (n7 = this.pieInfo.height) == 0) {
            return jCDataIndex;
        }
        int n8 = (this.box_width - n6) / 2;
        if (n8 < 0) {
            n8 = 0;
        }
        double d3 = (double)n6 / 2.0;
        double d4 = (double)n7 / 2.0;
        int n9 = point.x / this.box_width;
        if (n9 >= this.num_pies_line) {
            n9 = this.num_pies_line - 1;
        }
        if ((n2 = point.y / this.box_height) >= this.num_lines) {
            n2 = this.num_lines - 1;
        }
        int n10 = n2 * this.num_pies_line + n9 + ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
        int n11 = 0;
        int n12 = 0;
        if (n10 < this.num_pies + ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint() && point.x >= (n11 += n9 * this.box_width) && point.x <= n11 + this.box_width && point.y >= (n12 += n2 * this.box_height) && point.y <= n12 + this.box_height) {
            int n13 = this.computeOtherSlice(this.seriesList, n10, n3, pieData);
            this.setShapeOperation(1);
            this.picker = new Picker(point.x, point.y, this.pieInfo.data[n10]);
            Graphics graphics = this.chartArea.getGraphics();
            graphics.translate(rectangle.x, rectangle.y);
            this.drawSinglePie(graphics, n10, n11, n12);
            this.resetShapeOperation();
            if (n13 != 0 && this.picker.set == -10) {
                if (this.picker.point >= 0) {
                    jCDataIndex = new JCDataIndex(this.picker.point, null, -10);
                    jCDataIndex.distance = this.picker.distance;
                }
            } else if (this.picker.set >= 0 && this.picker.point >= 0) {
                jCDataIndex = new JCDataIndex(this.picker.point, (ChartDataViewSeries)this.seriesList.get(this.picker.set), this.picker.set);
                jCDataIndex.distance = this.picker.distance;
            }
        }
        return jCDataIndex;
    }

    public Point unpick(int n, int n2) {
        PieData pieData = this.pieInfo.data[n];
        Point point = new Point();
        double d = this.find_point(n2, n, point);
        if (point.x < 0 || point.y < 0) {
            return null;
        }
        int n3 = this.findSliceIndex(n2, n);
        if (pieData.exploded[pieData.percents[n3].index]) {
            double d2 = (double)this.pieInfo.width / 2.0;
            double d3 = (double)this.pieInfo.height / 2.0;
            int n4 = (int)Math.round(Math.cos(d) * (double)this.explode_offset);
            int n5 = (int)Math.round(-Math.sin(d) * (double)this.explode_offset);
            point.x += n4;
            point.y += n5;
        }
        return point;
    }

    private int findSliceIndex(int n, int n2) {
        int n3 = this.seriesList.size();
        int n4 = 0;
        while (n4 < n3 + 1) {
            int n5 = n2 - ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
            short s = this.pieInfo.pos[n5].order[n4];
            if (s == n) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private double find_point(int n, int n2, Point point) {
        int n3 = this.seriesList.size();
        if (n != -10 && !((ChartDataViewSeries)this.seriesList.get(n)).isVisible()) {
            point.x = -1;
            point.y = -1;
            return Double.MAX_VALUE;
        }
        double d = JCChartUtil.degToRad(Math.max(0, this.chartArea.getElevation()));
        double d2 = Math.cos(d);
        int n4 = -1;
        int n5 = -1;
        double d3 = Double.MAX_VALUE;
        int n6 = 0;
        while (n6 < n3 + 1) {
            int n7 = n2 - ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
            short s = this.pieInfo.pos[n7].order[n6];
            if (s == -1) {
                point.x = -1;
                point.y = -1;
                return Double.MAX_VALUE;
            }
            if (s != -2 && s == n) {
                double d4;
                double d5;
                double d6 = this.pieInfo.pos[n7].coord[n6].x;
                double d7 = this.pieInfo.pos[n7].coord[n6].y;
                if (d6 == -2.0) {
                    point.x = -1;
                    point.y = -1;
                    return Double.MAX_VALUE;
                }
                if (n6 == n3 || this.pieInfo.pos[n7].order[n6 + 1] == -1) {
                    d5 = this.pieInfo.pos[n7].coord[0].x;
                    d4 = this.pieInfo.pos[n7].coord[0].y;
                } else {
                    d5 = this.pieInfo.pos[n7].coord[n6 + 1].x;
                    d4 = this.pieInfo.pos[n7].coord[n6 + 1].y;
                }
                d7 = (d7 - (double)this.pieInfo.pos[n7].cy) / d2 + (double)this.pieInfo.pos[n7].cy;
                d4 = (d4 - (double)this.pieInfo.pos[n7].cy) / d2 + (double)this.pieInfo.pos[n7].cy;
                double d8 = Math.atan2((double)this.pieInfo.pos[n7].cy - d7, d6 - (double)this.pieInfo.pos[n7].cx);
                double d9 = Math.atan2((double)this.pieInfo.pos[n7].cy - d4, d5 - (double)this.pieInfo.pos[n7].cx);
                d3 = d8 - d9;
                if (d3 < 0.0) {
                    d3 += Math.PI * 2;
                }
                if ((d3 = d8 - d3 / 2.0) <= -Math.PI) {
                    d3 += Math.PI * 2;
                }
                if (d3 == 1.5707963267948966) {
                    n4 = this.pieInfo.pos[n7].cx;
                    n5 = this.pieInfo.pos[n7].cy - this.pieInfo.height / 2;
                    break;
                }
                if (d3 == -1.5707963267948966) {
                    n4 = this.pieInfo.pos[n7].cx;
                    n5 = this.pieInfo.pos[n7].cy + this.pieInfo.height / 2;
                    break;
                }
                double d10 = (double)this.pieInfo.width / 2.0;
                double d11 = Math.tan(d3);
                d6 = Math.sqrt(d10 * d10 / (1.0 + d11 * d11));
                if (d3 > 1.5707963267948966 || d3 < -1.5707963267948966) {
                    d6 = -d6;
                }
                d7 = d6 * d11 * d2;
                n4 = (int)((double)this.pieInfo.pos[n7].cx + d6);
                n5 = (int)((double)this.pieInfo.pos[n7].cy - d7);
                break;
            }
            ++n6;
        }
        point.x = n4;
        point.y = n5;
        return d3;
    }

    private void calcExplodeOffset(double d, double d2, double d3, Point point) {
        double d4 = d - d2;
        if (d4 < 0.0) {
            d4 += 360.0;
        }
        if (d4 >= 0.0 && d4 <= 90.0) {
            point.x = (int)Math.round(Math.cos(JCChartUtil.degToRad(d4)) * d3);
            point.y = -((int)Math.round(Math.sin(JCChartUtil.degToRad(d4)) * d3));
        } else if (d4 > 90.0 && d4 <= 180.0) {
            point.x = -((int)Math.round(Math.sin(JCChartUtil.degToRad(d4 -= 90.0)) * d3));
            point.y = -((int)Math.round(Math.cos(JCChartUtil.degToRad(d4)) * d3));
        } else if (d4 > 180.0 && d4 <= 270.0) {
            point.x = -((int)Math.round(Math.cos(JCChartUtil.degToRad(d4 -= 180.0)) * d3));
            point.y = (int)Math.round(Math.sin(JCChartUtil.degToRad(d4)) * d3);
        } else if (d4 > 270.0 && d4 <= 360.0) {
            point.x = (int)Math.round(Math.sin(JCChartUtil.degToRad(d4 -= 270.0)) * d3);
            point.y = (int)Math.round(Math.cos(JCChartUtil.degToRad(d4)) * d3);
        }
    }
}

