/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;

public class JCIconCreator {
    protected ImageIcon icon = null;
    protected int curRow;
    protected int width;
    protected int height;
    protected int[] colorMap = new int[256];
    protected int[] pixels;

    public JCIconCreator(int n, int n2) {
        this.setSize(n, n2);
    }

    public JCIconCreator() {
        this.colorMap[32] = 0;
    }

    public synchronized void clear() {
        if (this.width != 0 && this.height != 0) {
            this.pixels = new int[this.width * this.height];
        }
        this.icon = null;
        this.curRow = 0;
    }

    public synchronized ImageIcon getIcon() {
        if (this.pixels == null) {
            this.icon = null;
            return null;
        }
        if (this.icon == null) {
            MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
            this.icon = new ImageIcon(image);
        }
        return this.icon;
    }

    public synchronized void setColor(char c, int n) {
        if (c < '\u0100') {
            this.colorMap[c] = n;
            this.icon = null;
        }
    }

    public synchronized void setColor(char c, Color color) {
        this.setColor(c, color == null ? 0 : color.getRGB());
    }

    public synchronized void setSize(int n, int n2) {
        if (n == this.width && n2 == this.height) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.pixels = (int[])(n == 0 && n2 == 0 ? null : new int[n * n2]);
        this.icon = null;
    }

    public synchronized void setPixels(String[] stringArray) {
        this.clear();
        int n = 0;
        while (n < stringArray.length && n < this.height) {
            this.setPixels(this.curRow++, stringArray[n]);
            ++n;
        }
        this.icon = null;
    }

    public synchronized void setPixels(int n, String string) {
        this.icon = null;
        if (string.length() != this.width) {
            return;
        }
        int n2 = 0;
        int n3 = n * this.width;
        while (n2 < this.width) {
            int n4;
            this.pixels[n2 + n3] = n4 = this.colorMap[string.charAt(n2)];
            ++n2;
        }
    }

    public static ImageIcon getIcon(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        return imageIcon;
    }
}

