/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.SBarChartDraw;
import java.awt.Point;

class EditHandler
extends ActionHandler {
    ChartDraw drawable = null;
    JCDataIndex di = null;

    EditHandler() {
    }

    void start(int n, int n2) {
        this.drawable = null;
        this.di = this.parent.pick(new Point(n, n2), null, -1);
        if (this.di == null || this.di.dataView == null || this.di.series == null) {
            return;
        }
        ChartDataModel chartDataModel = this.di.dataView.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof EditableChartDataModel)) {
            return;
        }
        this.drawable = this.parent.getDrawable(this.di.series.getParent());
        if (this.drawable == null) {
            return;
        }
        if (this.drawable.dataObject.getChartType() == 11) {
            this.drawable = null;
            return;
        }
        this.drawable.startEdit(this.di);
    }

    void animate(int n, int n2) {
        if (this.di == null || this.drawable == null) {
            return;
        }
        this.drawable.showEdit(this.di, n, n2);
    }

    void reanimate(int n, int n2) {
        this.animate(n, n2);
    }

    void end(int n, int n2) {
        if (this.di == null || this.drawable == null) {
            return;
        }
        int n3 = this.drawable.dataObject.getChartType();
        boolean bl = n3 == 2 || n3 == 3 || n3 == 4;
        int n4 = this.drawable.endEdit(this.di, n, n2);
        if (n4 == Integer.MIN_VALUE) {
            return;
        }
        if (n3 == 10 && ((JCBarChartFormat)this.drawable.dataObject.getChartFormat()).is100Percent()) {
            double d = this.drawable.dataObject.getYAxis().toData(n4);
            double d2 = d * ((SBarChartDraw)this.drawable).ytotal[this.di.point] / 100.0;
            this.di.series.editPoint(this.di.point, d2);
        } else if (bl) {
            JCAxis jCAxis = this.di.series.getParent().getYAxis();
            double d = Double.MAX_VALUE;
            double d3 = jCAxis.applyPixelToDataScaling(n4);
            if (jCAxis.isLogarithmic()) {
                d = jCAxis.isReversed() ? JCChartUtil.log10(jCAxis.max.value) + d3 : d3 + JCChartUtil.log10(jCAxis.min.value);
                d = Math.pow(10.0, d);
            } else {
                d = jCAxis.isReversed() ? jCAxis.max.value + d3 : d3 + jCAxis.min.value;
            }
            this.di.series.editPoint(this.di.point, d);
        } else {
            this.di.series.editPoint(this.di.point, this.di.series.getParent().getYAxis().toData(n4));
        }
        JCChart jCChart = this.getChart();
        if (jCChart != null) {
            jCChart.sendEvent(null);
        }
    }
}

