/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;

public class JCAxisTitle
extends ChartText {
    protected DerivedInt placement = new DerivedInt(16, true);

    public JCAxisTitle() {
        this.setVisible(false);
    }

    public JCAxisTitle(String string) {
        this.setText(string);
    }

    void setParentAxis(JCAxis jCAxis) {
        super.setParentAxis(jCAxis);
        this.fixPlacement(jCAxis);
    }

    public void setText(String string, boolean bl) {
        super.setText(string, bl);
        if (this.getWidth() == 0) {
            this.setChanged(true, 2);
        }
    }

    public void setPlacement(int n) {
        if (n == this.placement.value) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 17: 
            case 18: 
            case 33: 
            case 34: {
                if (this.parentAxis != null && !this.parentAxis.vertical) {
                    throw new IllegalArgumentException("Invalid title Placement for horizontal axis in JCAxisTitle");
                }
                this.placement.value = n;
                this.placement.isDefault = false;
                break;
            }
            case 16: 
            case 32: {
                if (this.parentAxis != null && this.parentAxis.vertical) {
                    throw new IllegalArgumentException("Invalid title Placement for vertical axis in JCAxisTitle");
                }
                this.placement.value = n;
                this.placement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid title Placement in JCAxisTitle");
            }
        }
        this.setChanged(true, 2);
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    void fixPlacement(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        if (this.placement.isDefault) {
            this.placement.value = !this.parentAxis.vertical && this.rotation != 0 ? jCAxis.getAnnotationAnchor() : (this.parentAxis.otherAxis != null && this.parentAxis.otherAxis.getAnnotationAnchor() == 16 ? (this.parentAxis.getAnnotationAnchor() == 1 ? 33 : 34) : (this.parentAxis.getAnnotationAnchor() == 1 ? 17 : 18));
        }
        if (jCAxis.vertical) {
            switch (this.placement.value) {
                case 1: 
                case 2: 
                case 17: 
                case 18: 
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    this.placement.value = jCAxis.getAnnotationAnchor();
                    break;
                }
            }
        } else {
            switch (this.placement.value) {
                case 16: 
                case 32: {
                    break;
                }
                default: {
                    this.placement.value = jCAxis.getAnnotationAnchor();
                }
            }
        }
    }

    public void layout() {
        if (this.visible) {
            if (this.parentAxis.vertical) {
                int n = this.parentAxis.getTop() + (this.parentAxis.getHeight() - this.getHeight()) / 2;
                int n2 = this.parentAxis.getLeft();
                int n3 = this.parentAxis.getLeft() + this.parentAxis.getWidth() - this.getWidth();
                Extents extents = this.parentAxis.getExtents();
                switch (this.placement.value) {
                    case 18: {
                        this.setLocation(n2, this.parentAxis.getTop() - extents.minor);
                        break;
                    }
                    case 2: {
                        this.setLocation(n2, n);
                        break;
                    }
                    case 34: {
                        this.setLocation(n2, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                        break;
                    }
                    case 17: {
                        this.setLocation(n3, this.parentAxis.getTop() - extents.minor);
                        break;
                    }
                    case 1: {
                        this.setLocation(n3, n);
                        break;
                    }
                    case 33: {
                        this.setLocation(n3, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                    }
                }
            } else {
                int n = this.parentAxis.getLeft() + (this.parentAxis.getWidth() - this.getWidth()) / 2;
                switch (this.placement.value) {
                    case 16: {
                        this.setLocation(n, this.parentAxis.getTop() + 1);
                        break;
                    }
                    case 32: {
                        this.setLocation(n, this.parentAxis.getTop() + this.parentAxis.getHeight() - this.getHeight());
                    }
                }
            }
        }
    }
}

