/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.InvalidLicenseException;
import com.sitraka.licensing.StringSort;
import com.sitraka.licensing.ValidateSignature;
import com.sitraka.licensing.util.Debug;
import com.sitraka.licensing.util.Platform;
import com.sitraka.licensing.util.PropertyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LicenseProperties
extends Properties {
    private boolean fValid = false;
    private boolean everValidated = false;
    private static final char SEPARATOR = ',';
    private static final char COLON_SEPARATOR = ':';
    private static final char SLASH = '/';
    private static final String LOCALHOST = "localhost";
    private static final String LOCAL_IP_ADDRESS = "127.0.0.1";
    private static final String EXTENSION = ".license";
    public static final int VALID = 1;
    public static final int HOSTNAME_INVALID = 2;
    public static final int NUMBER_CPU_EXCEEDED = 3;
    public static final int OS_INVALID = 4;
    public static final int NULL_PARAMETER = 11;
    public static final int HOSTS_PROPERTY_NOT_FOUND = 12;
    public static final int GETLOCALHOST_FAILED = 13;
    public static final int OS_PROPERTY_NOT_FOUND = 14;
    public static final int UNABLE_TO_IDENTIFY_OS = 15;
    public static String errorMessage = null;

    public static String getStandardFilename(String filename) {
        String fn = filename;
        if (!filename.endsWith(EXTENSION)) {
            int lastDotIndex = filename.lastIndexOf(".");
            fn = lastDotIndex == -1 ? filename + EXTENSION : filename.substring(0, lastDotIndex) + EXTENSION;
        }
        return fn;
    }

    public void loadFromStream(InputStream stream) throws IOException, InvalidLicenseException {
        this.load(stream);
        if (!this.validate()) {
            throw new InvalidLicenseException(errorMessage);
        }
    }

    public void loadFromClasspath(String properties) throws NullPointerException, IOException, InvalidLicenseException {
        try {
            URL url = this.getClass().getClassLoader().getResource(properties);
            InputStream stream = url.openStream();
            this.load(stream);
            stream.close();
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        if (!this.validate()) {
            throw new InvalidLicenseException(errorMessage);
        }
    }

    public void loadFromURL(URL properties) throws IOException, InvalidLicenseException {
        InputStream stream = properties.openStream();
        this.load(stream);
        stream.close();
        if (!this.validate()) {
            throw new InvalidLicenseException(errorMessage);
        }
    }

    public void loadFromFile(File properties) throws FileNotFoundException, IOException, InvalidLicenseException {
        if (!properties.exists()) {
            throw new FileNotFoundException();
        }
        FileInputStream stream = new FileInputStream(properties);
        this.load(stream);
        stream.close();
        if (!this.validate()) {
            throw new InvalidLicenseException(errorMessage);
        }
    }

    public boolean isValid() {
        if (!this.everValidated) {
            this.validate();
        }
        return this.fValid;
    }

    public String getProduct() {
        return this.getProperty("product");
    }

    public String getSerialNumber() {
        return this.getProperty("serial_number");
    }

    public String getMaximumUsers() {
        return this.getProperty("maximum_users");
    }

    public String getType() {
        return this.getProperty("type");
    }

    public boolean containsProduct(String product_line, String product_id) {
        String searchStr = this.getProductString(product_line, product_id);
        if (searchStr == null) {
            return false;
        }
        return this.containsProduct(searchStr);
    }

    public boolean containsProduct(String product_id) {
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.indexOf(product_id) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean isEvalCopy(String expiryDateProperty) {
        if (expiryDateProperty == null) {
            return false;
        }
        String dateString = this.getProperty(expiryDateProperty, null);
        if (dateString == null) {
            return false;
        }
        if ((dateString = dateString.trim()).length() == 0 || dateString.equals("")) {
            return false;
        }
        long date = PropertyUtils.readShortDate(this, expiryDateProperty);
        return date > 0L;
    }

    public boolean isDateExpired(String expiryDateProperty) {
        if (expiryDateProperty == null) {
            return false;
        }
        String dateString = this.getProperty(expiryDateProperty, null);
        if (dateString == null) {
            return false;
        }
        if ((dateString = dateString.trim()).length() == 0 || dateString.equals("")) {
            return false;
        }
        long date = PropertyUtils.readShortDate(this, expiryDateProperty);
        if (date > 0L) {
            Calendar cal = null;
            Date expiry = new Date(date);
            cal = Calendar.getInstance();
            cal.setTime(expiry);
            return !this.isLicenseCurrent(cal);
        }
        return false;
    }

    public int validateOperatingSystem(String operatingSystemProperty) {
        if (operatingSystemProperty == null) {
            return 11;
        }
        String operatingSystemList = this.getProperty(operatingSystemProperty, null);
        if (operatingSystemList == null) {
            Debug.println("LicenseProperties", "validateOperatingSystem(): Unable to get OS from license properties file.");
            return 14;
        }
        if ((operatingSystemList = operatingSystemList.toLowerCase()).indexOf("(any)", 0) >= 0) {
            return 1;
        }
        String actualOS = System.getProperty("os.name");
        if (actualOS == null) {
            return 15;
        }
        actualOS = actualOS.toLowerCase();
        Debug.println("LicenseProperties", "validateOperatingSystem(): actualOS = " + actualOS);
        String operatingSystem = null;
        int firstIndex = 0;
        int lastIndex = 0;
        while (firstIndex < operatingSystemList.length()) {
            lastIndex = operatingSystemList.indexOf(44, firstIndex);
            if (lastIndex < 0) {
                lastIndex = operatingSystemList.length();
            }
            operatingSystem = operatingSystemList.substring(firstIndex, lastIndex);
            Debug.println("LicenseProperties", "validateOperatingSystem(): licensed OS = " + operatingSystem);
            if (operatingSystem.indexOf(actualOS, 0) >= 0) {
                return 1;
            }
            firstIndex = lastIndex + 1;
        }
        return 4;
    }

    public int validateHost(String hostProperty) {
        if (hostProperty == null) {
            return 11;
        }
        String hostString = this.getProperty(hostProperty, null);
        if (hostString == null) {
            return 12;
        }
        hostString = hostString.trim();
        int returnCode = 0;
        String hostName = null;
        int firstIndex = 0;
        int lastIndex = 0;
        while (firstIndex < hostString.length()) {
            lastIndex = hostString.indexOf(44, firstIndex);
            if (lastIndex < 0) {
                lastIndex = hostString.length();
            }
            if ((returnCode = this.validateHostInfo(hostName = hostString.substring(firstIndex, lastIndex))) == 1 || returnCode == 3) break;
            firstIndex = lastIndex + 1;
        }
        return returnCode;
    }

    private int validateHostInfo(String hostName) {
        if (hostName == null) {
            return 11;
        }
        if (hostName.compareTo("(unlimited)") == 0) {
            return 1;
        }
        String nameLicensedHost = null;
        String numberCPU = null;
        InetAddress hostAddress = null;
        InetAddress licensedHost = null;
        int index = hostName.lastIndexOf(58);
        if (index > 0) {
            nameLicensedHost = hostName.substring(0, index).toLowerCase();
            numberCPU = hostName.substring(index + 1, hostName.length());
            Debug.println("LicenseProperties", "validateHostInfo(): nameLicensedHost = " + nameLicensedHost + ", numberCPU = " + numberCPU);
        } else {
            nameLicensedHost = hostName.toLowerCase();
            Debug.println("LicenseProperties", "validateHostInfo(): nameLicensedHost = " + nameLicensedHost);
        }
        InetAddress[] allAddresses = null;
        try {
            hostAddress = InetAddress.getLocalHost();
            int charIndex = hostAddress.toString().indexOf(47);
            allAddresses = InetAddress.getAllByName(hostAddress.toString().substring(charIndex + 1));
        }
        catch (UnknownHostException e) {
            Debug.println("LicenseProperties", "validateHostInfo(): UnknownHostException " + e.getMessage());
            return 13;
        }
        int returnCode = 2;
        try {
            licensedHost = InetAddress.getByName(nameLicensedHost);
        }
        catch (UnknownHostException e) {
            return returnCode;
        }
        if (licensedHost != null) {
            Debug.println("LicenseProperties", "licensedHost=" + licensedHost.toString());
            int i = 0;
            while (i < allAddresses.length) {
                if (licensedHost.equals(allAddresses[i])) {
                    int nCPU;
                    returnCode = 1;
                    if (numberCPU == null || this.isNumberProcessorsValid(nCPU = Integer.parseInt(numberCPU))) break;
                    returnCode = 3;
                    break;
                }
                ++i;
            }
        }
        return returnCode;
    }

    private boolean isNumberProcessorsValid(int nCPU) {
        int actualNumberCPU = Platform.getNumberProcessors();
        return nCPU >= actualNumberCPU;
    }

    public boolean validate() {
        this.fValid = false;
        errorMessage = "";
        try {
            Enumeration<?> enumeration = this.propertyNames();
            String[] propertyStr = new String[((Hashtable)this).size()];
            String signature = null;
            String temp = null;
            int i = 0;
            while (enumeration.hasMoreElements()) {
                temp = (String)enumeration.nextElement();
                if (temp.indexOf("sitraka.license.signature") == -1) {
                    propertyStr[i] = temp;
                } else {
                    propertyStr[i] = "";
                    signature = temp;
                }
                ++i;
            }
            StringSort.sort(propertyStr);
            int i2 = 0;
            while (i2 < propertyStr.length) {
                if (!propertyStr[i2].equals("")) {
                    int n = i2;
                    propertyStr[n] = propertyStr[n] + this.getProperty(propertyStr[i2]);
                }
                ++i2;
            }
            if (signature != null) {
                signature = this.getProperty(signature);
                this.fValid = ValidateSignature.validateSignature(propertyStr, signature);
            }
        }
        catch (RuntimeException e) {
            Debug.println("LicenseProperties", "validate(): RuntimeException caught -- " + e.getMessage());
        }
        if (!this.fValid) {
            errorMessage = errorMessage + "Invalid Digital Signature";
        }
        if (this.getProperty("serial_number") == null) {
            if (errorMessage.length() != 0) {
                errorMessage = errorMessage + ",";
            }
            errorMessage = errorMessage + "Serial Number Property not specified";
            this.fValid = false;
        }
        if (this.getProperty("product") == null) {
            if (errorMessage.length() != 0) {
                errorMessage = errorMessage + ",";
            }
            errorMessage = errorMessage + "Product Property not specified";
            this.fValid = false;
        }
        this.everValidated = true;
        return this.fValid;
    }

    private String getProductString(String product_line, String product_id) {
        String searchStr = null;
        if (product_line != null) {
            searchStr = product_line;
            if (product_id != null) {
                searchStr = searchStr + "." + product_id;
            }
        } else if (product_id != null) {
            searchStr = product_id;
        }
        return searchStr;
    }

    private boolean isLicenseCurrent(Calendar expiry) {
        long limit;
        if (expiry == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now < (limit = expiry.getTime().getTime());
    }

    public Vector getValidHostNames() {
        int temp;
        InetAddress[] allAddresses = null;
        try {
            InetAddress hostAddress = InetAddress.getLocalHost();
            temp = hostAddress.toString().indexOf(47);
            allAddresses = InetAddress.getAllByName(hostAddress.toString().substring(temp + 1));
        }
        catch (UnknownHostException e) {
            Debug.println("LicenseProperties", "Unable to get local host addresses.");
            return null;
        }
        String subStr = null;
        String addrStr = null;
        Vector<String> validHostVector = new Vector<String>();
        int i = 0;
        while (i < allAddresses.length) {
            addrStr = allAddresses[i].toString().toLowerCase();
            subStr = addrStr.substring(0, temp = addrStr.indexOf(47));
            if (!subStr.equals(LOCALHOST)) {
                validHostVector.addElement(subStr);
            }
            if (!(subStr = addrStr.substring(temp + 1)).equals(LOCAL_IP_ADDRESS)) {
                validHostVector.addElement(subStr);
            }
            ++i;
        }
        return validHostVector;
    }
}

