/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego;

import com.openit.lego.logging.Logger;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public abstract class ResourceHandler {
    private ResourceBundle messages;
    protected static ResourceHandler handler = null;
    private String graphicsDir;

    public ResourceHandler(Locale locale) {
        Logger.verbose("Config locale currently set to " + locale);
        String className = this.getClass().getName();
        String resourceBaseDir = className.substring(0, className.lastIndexOf(46));
        String bundle = resourceBaseDir + ".lang.messages";
        this.graphicsDir = "/" + resourceBaseDir.replace('.', '/') + "/graphics/";
        try {
            Logger.verbose("Trying to load messages from file '" + bundle + "'");
            this.messages = ResourceBundle.getBundle(bundle, locale);
            Logger.verbose("Resourcebundle/messagefile '" + this.getMessage("bundle.ID") + "' loaded. Description: " + this.getMessage("bundle.description"));
            handler = this;
        }
        catch (MissingResourceException mre) {
            Logger.error("Unable to find any valid message file: " + mre);
            mre.printStackTrace();
        }
        catch (NullPointerException npe) {
            Logger.error("Something bad happened while loading message file: " + npe);
            npe.printStackTrace();
        }
    }

    public String getMessage(String key) {
        String myString = "";
        try {
            myString = this.messages.getString(key);
        }
        catch (MissingResourceException mre) {
            Logger.warning("Failed to load string from key '" + key + "'; does not even exist in default message-file");
            myString = "#####";
        }
        return myString;
    }

    public String getMessage(String key, Object[] variables) {
        String message = this.getMessage(key);
        StringBuffer buf = new StringBuffer(message);
        int index = buf.length();
        for (int i = variables.length - 1; i >= 0 && (index = message.lastIndexOf("$$", index - 1)) != -1; --i) {
            buf.replace(index, index + 2, variables[i] != null ? variables[i].toString() : "");
        }
        return buf.toString();
    }

    public String getMessage(String key, Object var) {
        return this.getMessage(key, new Object[]{var});
    }

    public char getMnemonic(String key) {
        String myString = this.getMessage(key);
        char myChar = myString.charAt(0);
        return myChar;
    }

    public Image getImage(String imageName) {
        Logger.debug("Trying to load image '" + this.graphicsDir + imageName + "'");
        URL url = (1.class$com$openit$lego$ResourceHandler == null ? (1.class$com$openit$lego$ResourceHandler = 1.class$("com.openit.lego.ResourceHandler")) : 1.class$com$openit$lego$ResourceHandler).getResource(this.graphicsDir + imageName);
        if (url == null) {
            Logger.error("Unable to get image " + imageName);
            return null;
        }
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public ImageIcon getImageIcon(String imageName) {
        Image image = this.getImage(imageName);
        if (image == null) {
            return null;
        }
        Logger.debug("Converting '" + imageName + "' to imageicon");
        return new ImageIcon(image);
    }

    static class 1 {
        static /* synthetic */ Class class$com$openit$lego$ResourceHandler;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

