/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.net;

import com.openit.lego.logging.Logger;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class CGIUtils {
    public static int GET = 1;
    public static int POST = 2;
    protected static final String DELIMITER = "&";

    public static final String escapeHTMLMarkupChars(String name) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '\"') {
                str.append("&quot;");
                continue;
            }
            if (name.charAt(i) == '&') {
                str.append("&amp;");
                continue;
            }
            if (name.charAt(i) == '<') {
                str.append("&lt;");
                continue;
            }
            if (name.charAt(i) == '>') {
                str.append("&gt;");
                continue;
            }
            str.append(name.charAt(i));
        }
        return str.toString();
    }

    public static final String deEscapeHTMLMarkupChars(String name) {
        int lastPos = 0;
        int newPos = 0;
        StringBuffer str = new StringBuffer();
        while ((newPos = name.indexOf(38, lastPos)) > -1) {
            str.append(name.substring(lastPos, newPos));
            if (name.startsWith("&quot;", newPos)) {
                str.append('\"');
                lastPos = newPos + 6;
                continue;
            }
            if (name.startsWith("&amp;", newPos)) {
                str.append('&');
                lastPos = newPos + 5;
                continue;
            }
            if (name.startsWith("&lt;", newPos)) {
                str.append('<');
                lastPos = newPos + 4;
                continue;
            }
            if (name.startsWith("&gt;", newPos)) {
                str.append('>');
                lastPos = newPos + 4;
                continue;
            }
            str.append(DELIMITER);
            lastPos = newPos + 1;
        }
        if (lastPos < name.length()) {
            str.append(name.substring(lastPos));
        }
        return str.toString();
    }

    public static final String buildURLArg(String name, int value) {
        return CGIUtils.buildURLArg(name, String.valueOf(value));
    }

    public static final String buildURLArg(String name, String value) {
        StringBuffer str = new StringBuffer(name + "=");
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == ' ') {
                str.append('+');
                continue;
            }
            if (value.charAt(i) < '0' || value.charAt(i) > '9' && value.charAt(i) < 'A' || value.charAt(i) > 'Z' && value.charAt(i) < 'a' || value.charAt(i) > 'z' && value.charAt(i) < '\u0080') {
                str.append("%" + (value.charAt(i) < '\u0010' ? "0" : "") + Integer.toString(value.charAt(i), 16));
                continue;
            }
            if (value.charAt(i) > '\u007f') {
                String temp = Integer.toString(value.charAt(i), 16);
                if (temp.length() > 2) {
                    str.append("%" + temp.substring(2));
                    continue;
                }
                str.append("%" + temp);
                continue;
            }
            str.append(value.charAt(i));
        }
        return str.toString() + DELIMITER;
    }

    /*
     * WARNING - void declaration
     */
    public static String callCGI(String script, String cmd, int method, Applet applet) {
        void var5_5;
        BufferedReader br;
        String result = null;
        if (method == GET) {
            br = CGIUtils.getCGIOutput(script, cmd, applet);
        } else if (method == POST) {
            br = CGIUtils.postCGIOutput(script, cmd, applet);
        } else {
            Logger.error("(callCGI) Unknown method: " + method);
            return null;
        }
        if (var5_5 == null) {
            return null;
        }
        try {
            String input;
            while ((input = var5_5.readLine()) != null) {
                Logger.debug("input: " + input);
                if (input.length() == 0) continue;
                if (input.regionMatches(0, "Open iT ", 0, 8)) {
                    input = input.substring(8);
                }
                if (input.regionMatches(true, 0, "error:", 0, 6) || input.regionMatches(true, 0, "fatal:", 0, 6)) {
                    Logger.error(input.substring(7));
                    return null;
                }
                if (input.regionMatches(true, 0, "warning:", 0, 8)) {
                    Logger.warning(input.substring(9));
                    continue;
                }
                result = input;
                break;
            }
            var5_5.close();
        }
        catch (IOException ioe) {
            Logger.error("IOException: " + ioe);
            return null;
        }
        return result;
    }

    public static final String buildDebugVerboseFlags(String cmd) {
        StringBuffer cmdWithFlags = new StringBuffer(cmd == null ? "" : cmd);
        if (Logger.getLevel() >= 6) {
            cmdWithFlags.append(CGIUtils.buildURLArg("debug", "true"));
        }
        if (Logger.getLevel() >= 5) {
            cmdWithFlags.append(CGIUtils.buildURLArg("verbose", "true"));
        }
        return cmdWithFlags.toString();
    }

    public static final BufferedReader getCGIOutput(String script, String cmd, Applet applet) {
        BufferedReader br = null;
        String cmdFlagged = CGIUtils.buildDebugVerboseFlags(cmd);
        try {
            String url = script + (cmdFlagged == null ? "" : "?" + cmdFlagged);
            URL dataURL = new URL(CGIUtils.getDocumentBase(applet), url);
            Logger.debug("dataURL='" + dataURL + "'");
            URLConnection uc = dataURL.openConnection();
            boolean appletViewer = false;
            String ct = uc.getContentType();
            Logger.debug("Content type: '" + ct + "'");
            if (ct == null) {
                Logger.debug("No Content-Type in HTTP input");
            } else if (ct.equals("content/unknown")) {
                appletViewer = true;
            } else if (!ct.startsWith("text/plain")) {
                Logger.error("Illegal input from server, Content-Type: " + ct);
                return null;
            }
            try {
                String desiredEncoding = "JISAutoDetect";
                br = new BufferedReader(new InputStreamReader(uc.getInputStream(), desiredEncoding));
                Logger.verbose("Able to read stream from server with encoding set to '" + desiredEncoding + "'");
            }
            catch (UnsupportedEncodingException uee) {
                Logger.verbose("Unable to read stream from server with encoding set to Japanese. Trying again with no set encoding");
                br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            }
            if (appletViewer) {
                String input;
                while ((input = br.readLine()) != null && !input.equals("")) {
                    Logger.debug("Skipping input: " + input);
                }
            }
        }
        catch (MalformedURLException mue) {
            Logger.error("MalformedURLException: " + mue);
            return null;
        }
        catch (IOException ioe) {
            Logger.error("IOException: " + ioe);
            return null;
        }
        return br;
    }

    private static URL getDocumentBase(Applet applet) throws MalformedURLException {
        URL documentBase = null;
        documentBase = applet.getParameter("dev_documentbase") != null ? new URL(applet.getParameter("dev_documentbase")) : applet.getDocumentBase();
        return documentBase;
    }

    public static final BufferedReader postCGIOutput(String script, String cmd, Applet applet) {
        BufferedReader br = null;
        String cmdFlagged = CGIUtils.buildDebugVerboseFlags(cmd);
        try {
            URL dataURL = new URL(CGIUtils.getDocumentBase(applet), script);
            Logger.debug("dataURL='" + dataURL + "'");
            URLConnection uc = dataURL.openConnection();
            uc.setDoOutput(true);
            uc.setDoInput(true);
            uc.setAllowUserInteraction(false);
            uc.setUseCaches(false);
            uc.setRequestProperty("Content-Type", "application/x-psm");
            uc.setRequestProperty("Content-Length", String.valueOf(cmdFlagged.length()));
            DataOutputStream dos = new DataOutputStream(uc.getOutputStream());
            Logger.debug("Content-Length:" + String.valueOf(cmdFlagged.length()));
            Logger.debug("cmdFlagged='" + cmdFlagged + "'");
            dos.writeBytes(cmdFlagged);
            dos.flush();
            dos.close();
            String ct = uc.getContentType();
            Logger.debug("Content type: '" + ct + "'");
            if (ct == null) {
                Logger.debug("No Content-Type in HTTP input");
            } else if (!ct.equals("text/plain")) {
                Logger.error("Illegal input from server, Content-Type: " + ct);
                return null;
            }
            br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
        }
        catch (MalformedURLException mue) {
            Logger.error("MalformedURLException: " + mue);
            return null;
        }
        catch (IOException ioe) {
            Logger.error("IOException: " + ioe);
            return null;
        }
        return br;
    }
}

