/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SwingUtils {
    public static final Color COL_BG_DEFAULT = new Color(204, 204, 204);
    public static final Color COL_FG_DEFAULT = Color.black;

    public static final void addGBy(Container parent, GridBagConstraints constraints, Component component, int y, double weightY) {
        constraints.gridx = 0;
        constraints.gridy = y;
        constraints.weightx = 1.0;
        constraints.weighty = weightY;
        parent.add(component, constraints);
        parent.setBackground(COL_BG_DEFAULT);
        GridBagLayout gridLayout = (GridBagLayout)parent.getLayout();
    }

    public static final void addGBxy(Container parent, GridBagConstraints constraints, Component component, int x, int y, double weightX, double weightY) {
        SwingUtils.addGBxy(parent, constraints, component, x, y, weightX, weightY, 1, 1);
    }

    public static final void addGBxy(Container parent, GridBagConstraints constraints, Component component, int x, int y, double weightX, double weightY, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.weightx = weightX;
        constraints.weighty = weightY;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        parent.add(component, constraints);
        parent.setBackground(COL_BG_DEFAULT);
        GridBagLayout gridLayout = (GridBagLayout)parent.getLayout();
    }

    public static final void putCardsFirst(Vector panelVector) {
        for (int i = 0; i < panelVector.size(); ++i) {
            JPanel p = (JPanel)panelVector.elementAt(i);
            ((CardLayout)p.getLayout()).first(p);
        }
    }

    public static final void putCardsLast(Vector panelVector) {
        for (int i = 0; i < panelVector.size(); ++i) {
            JPanel p = (JPanel)panelVector.elementAt(i);
            ((CardLayout)p.getLayout()).last(p);
        }
    }

    public static final void centerDialog(Window w, Frame parent) {
        Dimension dialogDim = w.getSize();
        Dimension parentDim = parent.getSize();
        Point parentPnt = parent.getLocation();
        int x = parentPnt.x + parentDim.width / 2;
        int y = parentPnt.y + parentDim.height / 2;
        w.setLocation(x -= dialogDim.width / 2, y -= dialogDim.height / 2);
    }

    public static final JPanel leftAlign(JComponent content) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)content, "West");
        return panel;
    }

    public static final JPanel rightAlign(JComponent content) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)content, "East");
        return panel;
    }

    public static final JPanel topAlign(JComponent content) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)content, "North");
        return panel;
    }

    public static final JPanel useRequiredSpace(JComponent content) {
        JPanel panel = new JPanel();
        panel.add(content);
        return panel;
    }

    public static final JPanel makeLabelledComponent(String label, JComponent content) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(label), "West");
        panel.add((Component)content, "Center");
        return panel;
    }

    public static final void showCard(JComponent container, String ID) {
        CardLayout layout = (CardLayout)container.getLayout();
        layout.show(container, ID);
    }

    public static Border getInnerBorder() {
        return SwingUtils.getBorder(3);
    }

    public static Border getOuterBorder() {
        return SwingUtils.getBorder(5);
    }

    private static Border getBorder(int size) {
        return BorderFactory.createLineBorder(SwingConstants.COL_FG_SECONDARY, size);
    }

    public static void setRaisedBevelBorder(JComboBox combobox) {
        for (int i = 0; i < combobox.getComponentCount(); ++i) {
            if (!(combobox.getComponent(i) instanceof AbstractButton)) continue;
            ((AbstractButton)combobox.getComponent(i)).setBorderPainted(false);
        }
        combobox.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public static void setRaisedBevelBorder(JButton button) {
        Border raised = BorderFactory.createRaisedBevelBorder();
        Border empty = BorderFactory.createEmptyBorder(2, 10, 2, 10);
        button.setBorder(BorderFactory.createCompoundBorder(raised, empty));
    }

    public static void initializeOpenitLookAndFeel() {
        UIManager.put("ScrollPane.background", SwingUtils.getPrimaryBackground());
        UIManager.put("Panel.background", SwingUtils.getPrimaryBackground());
        UIManager.put("Label.background", SwingUtils.getPrimaryBackground());
        UIManager.put("CheckBox.background", SwingUtils.getPrimaryBackground());
        UIManager.put("TextArea.background", SwingUtils.getPrimaryBackground());
        UIManager.put("MenuItem.background", SwingUtils.getPrimaryBackground());
        UIManager.put("ComboBox.background", SwingUtils.getPrimaryBackground());
        UIManager.put("TextField.background", SwingUtils.getPrimaryBackground());
        UIManager.put("RadioButton.background", SwingUtils.getPrimaryBackground());
        UIManager.put("TextArea.background", SwingUtils.getPrimaryBackground());
        UIManager.put("Tree.background", SwingUtils.getPrimaryBackground());
        UIManager.put("TextPane.background", SwingUtils.getPrimaryBackground());
        UIManager.put("ScrollBar.background", SwingUtils.getPrimaryBackground());
        UIManager.put("ProgressBar.background", SwingUtils.getPrimaryBackground());
        UIManager.put("OptionPane.background", SwingUtils.getPrimaryBackground());
        UIManager.put("SplitPane.background", SwingUtils.getPrimaryBackground());
        UIManager.put("TabbedPane.selected", SwingUtils.getSecondaryBackground());
        UIManager.put("TextField.inactiveBackground", SwingUtils.getSecondaryBackground());
        UIManager.put("ComboBox.disabledBackground", SwingUtils.getSecondaryBackground());
        UIManager.put("Button.background", SwingUtils.getSecondaryBackground());
        UIManager.put("MenuBar.background", SwingUtils.getSecondaryBackground());
        UIManager.put("Menu.background", SwingUtils.getSecondaryBackground());
        UIManager.put("TableHeader.background", SwingUtils.getTertiaryBackground());
        UIManager.put("Table.selectionBackground", SwingUtils.getTertiaryBackground());
        UIManager.put("List.border", SwingUtils.getInnerBorder());
        UIManager.put("ComboBox.border", SwingUtils.getInnerBorder());
        UIManager.put("TextPane.border", SwingUtils.getInnerBorder());
        UIManager.put("TextField.border", SwingUtils.getInnerBorder());
    }

    public static Color getPrimaryBackground() {
        return SwingConstants.COL_BG_PRIMARY;
    }

    public static Color getSecondaryBackground() {
        return SwingConstants.COL_BG_SECONDARY;
    }

    public static Color getTertiaryBackground() {
        return SwingConstants.COL_BG_TERTIARY;
    }
}

