/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCHLOCChartFormat;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.List;

public class FastHLOCChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    public static final int OPEN_SERIES_INDEX = 2;
    public static final int CLOSE_SERIES_INDEX = 3;
    protected JCHLOCChartFormat hlocf = null;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.hlocf = (JCHLOCChartFormat)this.dataObject.getChartFormat();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.vertical;
        int n2 = this.seriesList.size() / 4;
        if (n == -1 || n == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl = this.hlocf.isOpenCloseFullWidth();
            boolean bl2 = this.hlocf.isShowingOpen();
            boolean bl3 = this.hlocf.isShowingClose();
            boolean bl4 = this.xaxis.isLogarithmic();
            boolean bl5 = this.yaxis.isLogarithmic();
            int n = this.seriesList.size() / 4;
            int n2 = 0;
            int n3 = n;
            int n4 = n2;
            while (n4 < n3) {
                JCLineStyle jCLineStyle;
                Serializable serializable;
                int n5 = this.hlocf.getTickSize(n4);
                boolean bl6 = true;
                boolean bl7 = true;
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MAX_VALUE;
                int n8 = 4 * n4;
                int n9 = 0;
                while (n9 < 4) {
                    serializable = (ChartDataViewSeries)this.seriesList.get(n8);
                    if (!((ChartDataViewSeries)serializable).isVisible()) {
                        bl7 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl6 = false;
                        break;
                    }
                    n6 = Math.min(n6, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n7 = Math.min(n7, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n9;
                    ++n8;
                }
                if (bl6 && bl7 && (serializable = ((ChartDataViewSeries)this.seriesList.get(4 * n4)).getStyle()) != null && (jCLineStyle = ((JCChartStyle)serializable).getLineStyle()).updateGraphics(graphics)) {
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n10 = n6;
                    while (n10 <= n7) {
                        this.drawPoints(graphics, this.seriesList, n4, n10, plotPointArray, jCLineStyle, bl, bl2, bl3, n5, bl4, bl5);
                        ++n10;
                    }
                    jCLineStyle.resetGraphics(graphics);
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private final void drawPoints(Graphics graphics, List list, int n, int n2, PlotPoint[] plotPointArray, JCLineStyle jCLineStyle, boolean bl, boolean bl2, boolean bl3, int n3, boolean bl4, boolean bl5) {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = 4 * n;
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n7++);
        double d2 = chartDataViewSeries.getX(n2);
        if (bl4 && d2 <= 0.0) {
            d2 = this.holeValue;
        }
        double d3 = chartDataViewSeries.getY(n2);
        if (bl5 && d3 <= 0.0) {
            d3 = this.holeValue;
        }
        ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)list.get(n7++);
        double d4 = chartDataViewSeries2.getX(n2);
        if (bl4 && d4 <= 0.0) {
            d4 = this.holeValue;
        }
        double d5 = chartDataViewSeries2.getY(n2);
        if (bl5 && d5 <= 0.0) {
            d5 = this.holeValue;
        }
        plotPointArray[0].valid = false;
        plotPointArray[1].valid = false;
        this.financialClip(d2, d3, d4, d5, this.xlim, this.ylim, plotPointArray, this.inverted, false);
        if (plotPointArray[0].valid && plotPointArray[1].valid) {
            graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
            if (defineShape != null) {
                if (!this.inverted) {
                    n4 = (int)plotPointArray[0].px;
                    n5 = (int)plotPointArray[0].py;
                    n6 = (int)plotPointArray[1].py;
                } else {
                    n4 = (int)plotPointArray[0].py;
                    n5 = (int)plotPointArray[0].px;
                    n6 = (int)plotPointArray[1].px;
                }
                if (!plotPointArray[0].drawPoint) {
                    chartDataViewSeries = null;
                }
                if (!plotPointArray[1].drawPoint) {
                    chartDataViewSeries2 = null;
                }
            }
        }
        ChartDataViewSeries chartDataViewSeries3 = null;
        int n8 = Integer.MAX_VALUE;
        if (n3 > 0 && bl2) {
            chartDataViewSeries3 = (ChartDataViewSeries)list.get(n7++);
            double d6 = chartDataViewSeries3.getX(n2);
            if (bl4 && d6 <= 0.0) {
                d6 = this.holeValue;
            }
            d = chartDataViewSeries3.getY(n2);
            if (bl5 && d <= 0.0) {
                d = this.holeValue;
            }
            if (d6 != this.holeValue && d != this.holeValue) {
                int n9 = this.xaxis.toPixel(d6, this.drawFront);
                d2 = this.xaxis.toData(n9 - n3, this.drawFront);
                d3 = d;
                d4 = bl ? this.xaxis.toData(n9 + n3, this.drawFront) : d6;
                d5 = d;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                this.financialClip(d2, d3, d4, d5, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                    graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
                    if (defineShape != null) {
                        n8 = !this.inverted ? (int)plotPointArray[0].py : (int)plotPointArray[0].px;
                        if (!plotPointArray[0].drawPoint && !plotPointArray[1].drawPoint) {
                            chartDataViewSeries3 = null;
                        }
                    }
                }
            }
        } else {
            ++n7;
        }
        ChartDataViewSeries chartDataViewSeries4 = null;
        int n10 = Integer.MAX_VALUE;
        if (n3 > 0 && bl3) {
            chartDataViewSeries4 = (ChartDataViewSeries)list.get(n7++);
            d = chartDataViewSeries4.getX(n2);
            if (bl4 && d <= 0.0) {
                d = this.holeValue;
            }
            double d7 = chartDataViewSeries4.getY(n2);
            if (bl5 && d7 <= 0.0) {
                d7 = this.holeValue;
            }
            if (d != this.holeValue && d7 != this.holeValue) {
                int n11 = this.xaxis.toPixel(d, this.drawFront);
                d2 = bl ? this.xaxis.toData(n11 - n3, this.drawFront) : d;
                d3 = d7;
                d4 = this.xaxis.toData(n11 + n3, this.drawFront);
                d5 = d7;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                this.financialClip(d2, d3, d4, d5, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                    graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
                    if (defineShape != null) {
                        n10 = !this.inverted ? (int)plotPointArray[0].py : (int)plotPointArray[0].px;
                        if (!plotPointArray[0].drawPoint && !plotPointArray[1].drawPoint) {
                            chartDataViewSeries4 = null;
                        }
                    }
                }
            }
        } else {
            ++n7;
        }
        if (defineShape != null) {
            this.defineHLOCShapes(defineShape, graphics, this.inverted, n2, chartDataViewSeries, chartDataViewSeries2, chartDataViewSeries3, chartDataViewSeries4, n5, n6, n8, n10, n4, n3);
        }
    }

    protected void defineHLOCShapes(DefineShape defineShape, Graphics graphics, boolean bl, int n, ChartDataViewSeries chartDataViewSeries, ChartDataViewSeries chartDataViewSeries2, ChartDataViewSeries chartDataViewSeries3, ChartDataViewSeries chartDataViewSeries4, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        if (n7 < 5) {
            n7 = 5;
        }
        ChartDataViewSeries[] chartDataViewSeriesArray = new ChartDataViewSeries[4];
        int[] nArray = new int[4];
        int n10 = 0;
        while (n10 < 4) {
            n9 = Integer.MAX_VALUE;
            n8 = 0;
            if (n2 != Integer.MAX_VALUE && n2 < n9) {
                n9 = n2;
                n8 = 1;
            }
            if (n3 != Integer.MAX_VALUE && n3 < n9) {
                n9 = n3;
                n8 = 2;
            }
            if (n4 != Integer.MAX_VALUE && n4 < n9) {
                n9 = n4;
                n8 = 3;
            }
            if (n5 != Integer.MAX_VALUE && n5 < n9) {
                n9 = n5;
                n8 = 4;
            }
            nArray[n10] = n9;
            if (n8 == 1) {
                chartDataViewSeriesArray[n10] = chartDataViewSeries;
                n2 = Integer.MAX_VALUE;
            } else if (n8 == 2) {
                chartDataViewSeriesArray[n10] = chartDataViewSeries2;
                n3 = Integer.MAX_VALUE;
            } else if (n8 == 3) {
                chartDataViewSeriesArray[n10] = chartDataViewSeries3;
                n4 = Integer.MAX_VALUE;
            } else if (n8 == 4) {
                chartDataViewSeriesArray[n10] = chartDataViewSeries4;
                n5 = Integer.MAX_VALUE;
            }
            ++n10;
        }
        n9 = Integer.MAX_VALUE;
        n8 = Integer.MAX_VALUE;
        int n11 = Integer.MAX_VALUE;
        int n12 = Integer.MAX_VALUE;
        int n13 = 0;
        while (n13 < nArray.length && nArray[n13] != Integer.MAX_VALUE) {
            n11 = nArray[n13];
            n9 = n13 == 0 ? n11 : n8;
            n12 = n13 + 1 < nArray.length && nArray[n13 + 1] != Integer.MAX_VALUE ? nArray[n13 + 1] : nArray[n13];
            n8 = n13 + 1 < nArray.length && chartDataViewSeriesArray[n13 + 1] != null ? n11 + (n12 - n11) / 2 : n12;
            if (chartDataViewSeriesArray[n13] != null) {
                if (n8 > n9) {
                    defineShape.beginShape(new JCDataIndex(n, chartDataViewSeriesArray[n13]));
                    if (!bl) {
                        graphics.fillRect(n6 - n7, n9, n7 * 2 + 1, n8 - n9);
                    } else {
                        graphics.fillRect(n9, n6 - n7, n8 - n9, n7 * 2 + 1);
                    }
                    defineShape.endShape(false);
                }
            } else {
                n8 = n11;
            }
            ++n13;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        int n4 = -1;
        int n5 = -1;
        JCDataIndex jCDataIndex = null;
        double d = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        double d2 = this.xlim.max;
        double d3 = this.xlim.min;
        double d4 = this.ylim.max;
        double d5 = this.ylim.min;
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        boolean bl3 = this.hlocf.isShowingOpen();
        boolean bl4 = this.hlocf.isShowingClose();
        boolean bl5 = this.hlocf.isOpenCloseFullWidth();
        int n6 = !this.xaxis.vertical && !this.xaxis.reversed || this.xaxis.vertical && this.xaxis.reversed ? -1 : 1;
        double d6 = this.dataObject.getHoleValue();
        int n7 = this.seriesList.size() / 4;
        int n8 = 0;
        int n9 = n7;
        try {
            int n10 = n8;
            while (n10 < n9) {
                int n11 = this.hlocf.getTickSize(n10);
                double d7 = n11 == 0 ? 0.0 : Math.abs(this.xaxis.toData(0) - this.xaxis.toData(n11));
                boolean bl6 = true;
                boolean bl7 = true;
                int n12 = Integer.MAX_VALUE;
                int n13 = Integer.MAX_VALUE;
                int n14 = 4 * n10;
                int n15 = 0;
                while (n15 < 4) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n14);
                    if (!chartDataViewSeries.isVisible()) {
                        bl7 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl6 = false;
                        break;
                    }
                    n12 = Math.min(n12, chartDataViewSeries.getFirstPoint());
                    n13 = Math.min(n13, chartDataViewSeries.getLastPoint());
                    ++n15;
                    ++n14;
                }
                if (bl6 && bl7) {
                    int n16 = 4 * n10;
                    double[] dArray = ((ChartDataViewSeries)this.seriesList.get(n16 + 0)).getX();
                    double[] dArray2 = ((ChartDataViewSeries)this.seriesList.get(n16 + 0)).getY();
                    double[] dArray3 = ((ChartDataViewSeries)this.seriesList.get(n16 + 1)).getX();
                    double[] dArray4 = ((ChartDataViewSeries)this.seriesList.get(n16 + 1)).getY();
                    double[] dArray5 = ((ChartDataViewSeries)this.seriesList.get(n16 + 2)).getX();
                    double[] dArray6 = ((ChartDataViewSeries)this.seriesList.get(n16 + 2)).getY();
                    double[] dArray7 = ((ChartDataViewSeries)this.seriesList.get(n16 + 3)).getX();
                    double[] dArray8 = ((ChartDataViewSeries)this.seriesList.get(n16 + 3)).getY();
                    double d8 = 0.0;
                    double d9 = 0.0;
                    int n17 = n12;
                    while (n17 <= n13) {
                        boolean bl8 = false;
                        boolean bl9 = !(dArray[n17] == d6 || dArray2[n17] == d6 || dArray3[n17] == d6 || dArray4[n17] == d6 || bl && dArray[n17] <= 0.0 || bl2 && dArray2[n17] <= 0.0 || bl && dArray3[n17] <= 0.0 || bl2 && dArray4[n17] <= 0.0);
                        boolean bl10 = !(dArray5[n17] == d6 || dArray6[n17] == d6 || bl && dArray5[n17] <= 0.0 || bl2 && dArray6[n17] <= 0.0);
                        boolean bl11 = !(dArray7[n17] == d6 || dArray8[n17] == d6 || bl && dArray7[n17] <= 0.0 || bl2 && dArray8[n17] <= 0.0);
                        int n18 = bl9 ? 0 : 2;
                        block15: while (n18 < 4) {
                            double d10;
                            switch (n18) {
                                case 0: {
                                    d8 = dArray[n17];
                                    d9 = dArray2[n17];
                                    break;
                                }
                                case 1: {
                                    d8 = dArray3[n17];
                                    d9 = dArray4[n17];
                                    break;
                                }
                                case 2: {
                                    if (!bl3 || !bl10 || n11 == 0) {
                                        ++n18;
                                        continue block15;
                                    }
                                    if (!bl8) {
                                        d8 = dArray5[n17];
                                        d9 = dArray6[n17];
                                        if (bl5) {
                                            d8 += (double)(-n6) * d7;
                                        }
                                        bl8 = true;
                                        break;
                                    }
                                    d8 = dArray5[n17] + (double)n6 * d7;
                                    bl8 = false;
                                    break;
                                }
                                case 3: {
                                    if (!bl4 || !bl11 || n11 == 0) {
                                        ++n18;
                                        continue block15;
                                    }
                                    if (!bl8) {
                                        d8 = dArray7[n17];
                                        d9 = dArray8[n17];
                                        if (bl5) {
                                            d8 += (double)n6 * d7;
                                        }
                                        bl8 = true;
                                        break;
                                    }
                                    d8 = dArray7[n17] - (double)n6 * d7;
                                    bl8 = false;
                                }
                            }
                            if (d8 > d2 || d3 > d8 || d9 > d4 || d5 > d9) {
                                if (bl8) continue;
                                ++n18;
                                continue;
                            }
                            switch (n) {
                                case 1: {
                                    int n19 = this.xaxis.toPixel(d8, this.drawFront);
                                    d10 = this.inverted ? (double)Math.abs(n19 - n3) : (double)Math.abs(n19 - n2);
                                    break;
                                }
                                case 2: {
                                    int n20 = this.yaxis.toPixel(d9, this.drawFront);
                                    d10 = this.inverted ? (double)Math.abs(n20 - n2) : (double)Math.abs(n20 - n3);
                                    break;
                                }
                                default: {
                                    int n19 = this.xaxis.toPixel(d8, this.drawFront);
                                    int n20 = this.yaxis.toPixel(d9, this.drawFront);
                                    double d11 = d10 = this.inverted ? Math.sqrt((n20 - n2) * (n20 - n2) + (n19 - n3) * (n19 - n3)) : Math.sqrt((n19 - n2) * (n19 - n2) + (n20 - n3) * (n20 - n3));
                                }
                            }
                            if (d > d10) {
                                n4 = n10 * 4 + n18;
                                n5 = n17;
                                d = d10;
                            }
                            if (bl8) continue;
                            ++n18;
                        }
                        ++n17;
                    }
                }
                ++n10;
            }
            if (n4 >= 0 && n5 >= 0) {
                jCDataIndex = new JCDataIndex(n5, (ChartDataViewSeries)this.seriesList.get(n4), n4);
                jCDataIndex.distance = (int)d;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.getDrawingOrder() / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n2 = n * 4;
        int n3 = jCDataIndex.seriesIndex - n2;
        double d = ((ChartDataViewSeries)this.seriesList.get(n2 + n3)).getX(jCDataIndex.point);
        double d2 = ((ChartDataViewSeries)this.seriesList.get(n2 + n3)).getY(jCDataIndex.point);
        this.start = this.inverted ? new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d) + this.r.y) : new Point(this.xaxis.toPixel(d) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        return jCDataIndex.dataView.getXAxis().vertical ? n - this.r.x : n2 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 4;
    }
}

