/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.BarPoint;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class BarChartDraw
extends ChartDraw
implements Serializable {
    public static final int SIDE_0 = 1;
    public static final int SIDE_1 = 2;
    public static final int SIDE_2 = 4;
    public static final int SIDE_3 = 8;
    public static final int OUTLINE_SENSITIVITY = 3;
    protected Point firstLast = null;
    JCLineStyle outlineStyle = null;
    protected int x_reversed = 0;
    protected int y_reversed = 0;
    protected int delta_x = 0;
    protected int delta_y = 0;
    double xAxisPos = Double.MAX_VALUE;
    double[] xGridLineList = null;
    JCLineStyle gridLineStyle = null;
    boolean fastAction = false;
    boolean inAction = false;
    double yOrigin = 0.0;
    protected transient BarPoint[][] pts = null;
    double bar_base;
    int top;
    int bottom;
    int left;
    int right;
    protected boolean is_3d = false;
    boolean drawOutline = true;
    Rectangle r = null;
    boolean editInverted = false;
    Point start = null;
    Point end = null;

    public void recalc() {
        super.recalc();
        JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)this.dataObject.getChartFormat();
        if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
            this.pts = null;
            return;
        }
        this.delta_x = this.chartArea.getDeltaX();
        this.delta_y = this.chartArea.getDeltaY();
        this.is_3d = this.delta_x != 0 || this.delta_y != 0;
        int n = jCBarChartFormat.clusterOverlap;
        if (this.is_3d && n > 0) {
            n = 0;
        }
        MinMax minMax = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        MinMax minMax2 = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(minMax, minMax2);
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        double d = 1.0 - (double)n / 100.0;
        double d2 = this.numActiveDataSeries;
        d2 = (d2 - 1.0) * d + 1.0;
        this.bar_base = this.dataObject.step * (double)jCBarChartFormat.clusterWidth / (d2 * 100.0);
        double d3 = d2 * this.bar_base / 2.0;
        double d4 = d * this.bar_base;
        this.inverted = this.xaxis.vertical;
        minMax.min -= d3;
        minMax.max += d3;
        this.xaxis.setLimits(minMax);
        this.xaxis.calcTransformation();
        this.xaxis.layoutAnnotations();
        this.xaxis.checkAnnotations();
        minMax2.min = JCChartUtil.min(this.yaxis.origin.value, minMax2.min);
        minMax2.max = JCChartUtil.max(this.yaxis.origin.value, minMax2.max);
        this.yaxis.setLimits(minMax2);
        this.yaxis.calcTransformation();
        minMax = this.xaxis.dataLimits;
        minMax2 = this.yaxis.dataLimits;
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        this.drawOutline = Math.abs(this.xaxis.toPixel(this.xaxis.min.value + this.bar_base, this.drawFront) - this.xaxis.toPixel(this.xaxis.min.value, this.drawFront)) > 3;
        int n2 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
        int n3 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
        this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
        this.right = this.left + n2 - 1;
        this.top = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
        this.bottom = this.top + n3 - 1;
        this.firstLast = this.dataObject.getFirstLast();
        if (this.firstLast == null) {
            return;
        }
        this.seriesList = this.dataObject.getSeries();
        int n4 = this.seriesList.size();
        int n5 = this.dataObject.getVisibleDataSeries();
        this.holeValue = this.dataObject.getHoleValue();
        this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n4];
        this.yOrigin = this.yaxis.origin.value;
        int n6 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
        this.x_reversed = this.xaxis.reversed ? 1 : 0;
        int n7 = this.y_reversed = this.yaxis.reversed ? 1 : 0;
        int n8 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : 0 ^ this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : 0 ^ this.x_reversed);
        this.fastAction = this.chartArea.getFastAction();
        this.inAction = this.chartArea.getInAction();
        if (!this.fastAction || !this.inAction) {
            this.xAxisPos = this.xaxis.getRealPlacementLocation();
            this.xGridLineList = this.xaxis.getGridLineList();
            if (this.xGridLineList == null) {
                this.xGridLineList = new double[0];
            }
            this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
        }
        boolean bl3 = true;
        int n9 = this.firstLast.x;
        while (n9 <= this.firstLast.y) {
            int n10 = 0;
            int n11 = 0;
            while (n11 < this.seriesList.size()) {
                BarPoint[] barPointArray = this.pts[n9 - this.firstLast.x];
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11);
                if (chartDataViewSeries.isVisible()) {
                    double d5 = chartDataViewSeries.getX(n9);
                    double d6 = chartDataViewSeries.getX(n9) - d3;
                    double d7 = d6 + (double)n10 * d4;
                    double d8 = d7 + this.bar_base;
                    ++n10;
                    if (!(d7 < this.xaxis.min.value && d8 <= this.xaxis.min.value || d7 >= this.xaxis.max.value && d8 > this.xaxis.max.value)) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        double d9;
                        barPointArray[n11] = new BarPoint();
                        barPointArray[n11].x = d7;
                        if (minMax != null && (d8 <= minMax.min || d7 >= minMax.max)) {
                            barPointArray[n11].x = this.holeValue;
                        }
                        if (d5 == this.holeValue || bl && d5 <= 0.0) {
                            barPointArray[n11].x = this.holeValue;
                        }
                        barPointArray[n11].y = (d9 = chartDataViewSeries.getY(n9)) == this.holeValue || bl2 && d9 <= 0.0 ? this.holeValue : d9;
                        BarPoint barPoint = barPointArray[n11];
                        barPoint.front = null;
                        barPoint.top = null;
                        barPoint.side = null;
                        if (this.inverted) {
                            n15 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                            n14 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n13 = n14 - this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront);
                            n12 = n15 - n6;
                        } else {
                            n15 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n14 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                            n12 = this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront) - n15;
                            n13 = n6 - n14;
                        }
                        if (this.is_3d && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                            int n16;
                            Point[] pointArray = new Point[4];
                            Point[] pointArray2 = new Point[4];
                            pointArray[0] = new Point(0, 0);
                            pointArray[1] = new Point(this.delta_x, this.delta_y);
                            pointArray[2] = new Point(0, 0);
                            pointArray[3] = new Point(-this.delta_x, -this.delta_y);
                            pointArray2[0] = new Point(0, 0);
                            pointArray2[1] = new Point(this.delta_x, this.delta_y);
                            pointArray2[2] = new Point(0, 0);
                            pointArray2[3] = new Point(-this.delta_x, -this.delta_y);
                            if (this.inverted) {
                                pointArray2[0].x = n12 >= 0 ? (this.delta_x > 0 ? n15 : n6) : (this.delta_x > 0 ? n6 : n15);
                                n16 = n8 != 0 ? n14 : n14 - n13;
                                pointArray[0].x = n15 - n12;
                                pointArray[0].y = n16;
                                pointArray[2].x = n12;
                                pointArray2[0].y = n14 - n13;
                                pointArray2[2].y = n13;
                                barPoint.top = pointArray;
                                barPoint.side = pointArray2;
                            } else {
                                pointArray[0].y = n13 >= 0 ? (this.delta_y <= 0 ? n14 : n6) : (this.delta_y <= 0 ? n6 : n14);
                                pointArray2[0].x = n16 = n8 != 0 ? n15 : n15 + n12;
                                pointArray2[0].y = n14 + n13;
                                pointArray2[2].y = -n13;
                                pointArray[0].x = n15;
                                pointArray[2].x = n12;
                                barPoint.top = pointArray;
                                barPoint.side = pointArray2;
                            }
                        }
                        if (this.inverted) {
                            n15 = n6;
                            n14 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n12 = this.yaxis.toPixel(barPoint.y, this.drawFront) - n15;
                            n13 = n14 - this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront);
                            n14 -= n13;
                        }
                        if (n12 < 0) {
                            n12 = -n12;
                            n15 -= n12;
                        }
                        if (n13 < 0) {
                            n13 = -n13;
                            n14 -= n13;
                        }
                        if (this.inverted) {
                            n13 = Math.max(1, n13);
                        } else {
                            n12 = Math.max(1, n12);
                        }
                        barPoint.front = new Rectangle(n15, n14, n12, n13);
                    }
                }
                ++n11;
            }
            ++n9;
        }
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        if (this.firstLast == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.pts == null) {
            try {
                this.recalc();
                if (this.pts == null) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        this.outlineStyle = this.dataObject.getOutlineStyle();
        if (this.is_3d) {
            boolean bl;
            boolean bl2;
            int n3;
            int n4;
            int n5;
            n2 = 0;
            boolean bl3 = false;
            int n6 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : 0 ^ this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : 0 ^ this.x_reversed);
            n = 0;
            int n7 = 0;
            int n8 = this.seriesList.size() - 1;
            if (n6 != 0) {
                n5 = this.firstLast.y;
                n4 = n8;
                n3 = -1;
                bl2 = n5 >= this.firstLast.x;
                n = this.xGridLineList.length - 1;
            } else {
                n5 = this.firstLast.x;
                n4 = n7;
                n3 = 1;
                bl2 = n5 <= this.firstLast.y;
                n = 0;
            }
            BarPoint barPoint = null;
            int n9 = n5;
            while (bl2) {
                bl = n6 != 0 ? n4 >= n7 : n4 <= n8;
                int n10 = n4;
                while (bl) {
                    BarPoint barPoint2 = null;
                    try {
                        barPoint2 = this.pts[n9 - this.firstLast.x][n10];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (!(barPoint2 == null || this.fastAction && this.inAction)) {
                        int n11 = 0;
                        int n12 = 0;
                        if (this.inverted) {
                            n12 = barPoint2.front.y + barPoint2.front.height;
                            n11 = barPoint2.front.y;
                        } else {
                            n11 = barPoint2.front.x;
                            n12 = barPoint2.front.x + barPoint2.front.width;
                        }
                        if (n2 == 0) {
                            int n13 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n11, n12);
                            if (n13 == 1) {
                                n2 = 1;
                            } else if (n13 == 2) {
                                bl3 = true;
                                n2 = 1;
                            }
                        }
                        if (this.xaxis.gridVisible) {
                            n = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n11, n12, barPoint2.y, this.yOrigin, this.xGridLineList, n, n3, this.gridLineStyle);
                        }
                    }
                    if (barPoint2 != null && barPoint2.x != this.holeValue && barPoint2.y != this.holeValue && !((ChartDataViewSeries)this.seriesList.get(n10)).getStyle().getFillStyle().isCustomStackable()) {
                        this.draw_3dbar(graphics, n9, n10, barPoint2.top, barPoint2.side, this.calcFillOrientation(barPoint2.y, 0.0, this.inverted, this.yaxis.reversed), this.drawOutline);
                        barPoint = barPoint2;
                        if (bl3) {
                            this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, barPoint2.y, this.yOrigin);
                            bl3 = false;
                        }
                    }
                    bl = n6 != 0 ? n10 > n7 : n10 < n8;
                    n10 += n3;
                }
                bl2 = n6 != 0 ? n9 > this.firstLast.x : n9 < this.firstLast.y;
                n9 += n3;
            }
            if (!this.fastAction || !this.inAction) {
                bl = true;
                if (barPoint != null) {
                    bl = this.isDrawFinalGridAndTrough(barPoint, this.isDrawOverBar(this.inverted, this.y_reversed, this.delta_y, this.delta_x, this.xAxisPos, barPoint.y, this.yOrigin), this.inverted, this.xaxis.toPixel(this.xaxis.max.value, this.drawFront), this.xaxis.toPixel(this.xaxis.min.value, this.drawFront));
                }
                if (bl) {
                    this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, n6, n2 != 0, this.xGridLineList, n, n3, this.gridLineStyle);
                }
            }
        }
        n2 = 0;
        while (n2 < this.seriesList.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
            if (chartDataViewSeries.isVisible()) {
                JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                n = this.firstLast.x;
                while (n <= this.firstLast.y) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n - this.firstLast.x][n2];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                        if (jCFillStyle.isCustomStackable()) {
                            jCFillStyle.fillImageRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, barPoint.y >= 0.0, this.inverted);
                        } else {
                            jCFillStyle.updateFillOrientation(new Rectangle(barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height), this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.yaxis.reversed));
                            if (defineShape != null) {
                                defineShape.beginShape(new JCDataIndex(n, (ChartDataViewSeries)this.seriesList.get(n2)));
                            }
                            jCFillStyle.fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                            if (defineShape != null) {
                                defineShape.endShape(true);
                            }
                            if (this.drawOutline) {
                                jCFillStyle.drawOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineStyle);
                            }
                            jCFillStyle.resetFillOrientation();
                        }
                    }
                    ++n;
                }
            }
            ++n2;
        }
    }

    void draw_3dbar(Graphics graphics, int n, int n2, Point[] pointArray, Point[] pointArray2, int n3, boolean bl) {
        Polygon polygon;
        JCFillStyle jCFillStyle = ((ChartDataViewSeries)this.seriesList.get(n2)).getStyle().getFillStyle();
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        if (pointArray != null) {
            polygon = JCChartUtil.pointsToPolygon(pointArray);
            jCFillStyle.updateFillOrientation(polygon.getBounds(), n3);
            if (defineShape != null) {
                defineShape.beginShape(new JCDataIndex(n, (ChartDataViewSeries)this.seriesList.get(n2)));
            }
            if (this.delta_y <= 0) {
                jCFillStyle.fillPolygonHighlight(graphics, polygon);
            } else {
                jCFillStyle.fillPolygonShadow(graphics, polygon);
            }
            if (defineShape != null) {
                defineShape.endShape(true);
            }
            if (bl) {
                jCFillStyle.drawOutlinePolygon(graphics, polygon, this.outlineStyle);
            }
            jCFillStyle.resetFillOrientation();
        }
        if (pointArray2 != null) {
            polygon = JCChartUtil.pointsToPolygon(pointArray2);
            jCFillStyle.updateFillOrientation(polygon.getBounds(), n3);
            if (defineShape != null) {
                defineShape.beginShape(new JCDataIndex(n, (ChartDataViewSeries)this.seriesList.get(n2)));
            }
            if (this.delta_x <= 0) {
                jCFillStyle.fillPolygonHighlight(graphics, polygon);
            } else {
                jCFillStyle.fillPolygonShadow(graphics, polygon);
            }
            if (defineShape != null) {
                defineShape.endShape(true);
            }
            if (bl) {
                jCFillStyle.drawOutlinePolygon(graphics, polygon, this.outlineStyle);
            }
            jCFillStyle.resetFillOrientation();
        }
    }

    protected int calcFillOrientation(double d, double d2, boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2 && d >= d2 || bl2 && d < d2) {
                return 2;
            }
            return 1;
        }
        if (!bl2 && d >= d2 || bl2 && d < d2) {
            return 3;
        }
        return 4;
    }

    public JCDataIndex pick(Point point, int n) {
        int n2;
        int n3;
        int n4;
        boolean bl;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        int n7 = Integer.MAX_VALUE;
        if (this.firstLast == null || this.pts == null) {
            return null;
        }
        boolean bl2 = bl = this.delta_x != 0 || this.delta_y != 0;
        if (bl) {
            boolean bl3;
            int n8;
            n4 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : 0 ^ this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : 0 ^ this.x_reversed);
            int n9 = 0;
            int n10 = this.seriesList.size() - 1;
            if (n4 != 0) {
                n3 = this.firstLast.y;
                n2 = n10;
                n8 = -1;
                bl3 = n3 >= this.firstLast.x;
            } else {
                n3 = this.firstLast.x;
                n2 = n9;
                n8 = 1;
                bl3 = n3 <= this.firstLast.y;
            }
            int n11 = n3;
            while (bl3) {
                boolean bl4 = n4 != 0 ? n2 >= n9 : n2 <= n10;
                int n12 = n2;
                while (bl4) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n11 - this.firstLast.x][n12];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (barPoint != null) {
                        int n13 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.top, this.inverted, n);
                        int n14 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.side, this.inverted, n);
                        if (n13 <= n7 || n14 <= n7) {
                            n5 = n12;
                            n6 = n11;
                            n7 = Math.min(n14, n13);
                        }
                    }
                    bl4 = n4 != 0 ? n12 > n9 : n12 < n10;
                    n12 += n8;
                }
                bl3 = n4 != 0 ? n11 > this.firstLast.x : n11 < this.firstLast.y;
                n11 += n8;
            }
        }
        n4 = this.firstLast.x;
        while (n4 <= this.firstLast.y) {
            n3 = n4 - this.firstLast.x;
            if (this.pts[n3] != null) {
                n2 = 0;
                while (n2 < this.pts[n3].length) {
                    if (((ChartDataViewSeries)this.seriesList.get(n2)).isVisible()) {
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n3][n2];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                            int n15 = 0;
                            if (barPoint.front != null && (n15 = JCChartUtil.distanceToFrontRect(point2.x, point2.y, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.inverted, n)) <= n7) {
                                n5 = n2;
                                n6 = n4;
                                n7 = n15;
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n4;
        }
        if (n5 >= 0 && n6 >= 0) {
            jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
            jCDataIndex.distance = n7;
        }
        return jCDataIndex;
    }

    public Point unpick(int n, int n2) {
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n - this.firstLast.x][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (barPoint == null) {
            return null;
        }
        double d = barPoint.y;
        double d2 = barPoint.x;
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = barPoint.front.y + barPoint.front.height / 2;
            } else {
                n4 = this.yaxis.toPixel(d, this.drawFront);
                n3 = barPoint.front.x + barPoint.front.width / 2;
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.getXAxis().vertical;
        this.end = null;
        this.start = null;
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.getDrawingOrder()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n2;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
        int n3 = this.editInverted ? n - this.r.x : n2 - this.r.y;
        return n3;
    }
}

