/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

class LinearAxisHandler
extends AxisHandler {
    LinearAxisHandler() {
    }

    double toData(int n) {
        if (this.parent.vertical) {
            return ((double)(this.parent.getHeight() - n) - this.shift) / this.scale;
        }
        return ((double)n - this.shift) / this.scale;
    }

    protected JCDataCoord toDataPolar(int n, int n2) {
        double d = (double)n - this.parent.polarAxisParams.xCenter;
        double d2 = (double)n2 - this.parent.polarAxisParams.yCenter;
        JCAxis jCAxis = this.getRadialAxis();
        if (jCAxis == null) {
            return null;
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Double.MAX_VALUE;
        d4 = jCAxis.isReversed() ? jCAxis.max.value - d3 / -this.scale : d3 / this.scale + jCAxis.min.value;
        double d5 = this.calcThetaAngle(d, d2);
        return new JCDataCoord(d5, d4);
    }

    protected double toScreenLocation(double d) {
        return this.scale * d + this.shift;
    }

    int toPixel(double d) {
        int n = (d = this.toScreenLocation(d) + 0.5) >= 0.0 ? (int)d : (int)Math.floor(d);
        return this.parent.vertical ? this.parent.getHeight() - n : n;
    }

    double toPixelDouble(double d) {
        d = this.toScreenLocation(d);
        return this.parent.vertical ? (double)this.parent.getHeight() - d : d;
    }

    private double polarSubtractMinimum(double d) {
        JCAxis jCAxis;
        JCAxis jCAxis2 = jCAxis = this.parent.vertical ? this.parent : this.parent.otherAxis;
        if (jCAxis.isReversed()) {
            d = jCAxis.max.value - d;
        } else {
            boolean bl = jCAxis.dataLimits.min < 0.0;
            d -= bl ? -jCAxis.min.value : jCAxis.min.value;
        }
        return d;
    }

    private double radarSubtractMinimum(double d) {
        JCAxis jCAxis;
        JCAxis jCAxis2 = jCAxis = this.parent.vertical ? this.parent : this.parent.otherAxis;
        d = jCAxis.isReversed() ? jCAxis.max.value - d : (d -= jCAxis.min.value);
        return d;
    }

    protected Point toPixelPolar(double d, double d2, boolean bl) {
        JCDataCoord jCDataCoord;
        double d3;
        JCAxis jCAxis;
        if (bl) {
            d2 = this.parent.isPolar() ? this.polarSubtractMinimum(d2) : this.radarSubtractMinimum(d2);
        }
        JCAxis jCAxis2 = jCAxis = this.parent.vertical ? this.parent.otherAxis : this.parent;
        if (jCAxis.isReversed()) {
            d *= -1.0;
        }
        int n = (d3 = (jCDataCoord = this.toScreenLocationPolar(d, d2, bl)).getX()) < this.parent.polarAxisParams.xCenter ? (int)Math.ceil(d3) : (int)Math.round(d3);
        d3 = jCDataCoord.getY();
        int n2 = d3 < this.parent.polarAxisParams.yCenter ? (int)Math.ceil(d3) : (int)Math.round(d3);
        return new Point(n, n2);
    }

    void calcParams() {
        double d;
        double d2;
        double d3;
        int n;
        double d4;
        double d5;
        double d6;
        boolean bl = this.parent.chartType == 9 || this.parent.chartType == 10;
        boolean bl2 = this.parent.chartType == 5 || this.parent.chartType == 6;
        boolean bl3 = this.parent.chartType == 7;
        boolean bl4 = this.parent.chartType == 2;
        boolean bl5 = this.parent.chartType == 2 || this.parent.chartType == 3 || this.parent.chartType == 4;
        double d7 = this.parent.dataLimits == null ? 0.0 : this.parent.dataLimits.min;
        double d8 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        double d9 = Double.MAX_VALUE;
        if (bl4 && this.parent.vertical) {
            d9 = this.parent.isReversed() ? (this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max) : Math.max(Math.abs(d7), Math.abs(d8));
        }
        if (bl5 && !this.parent.vertical) {
            d6 = 0.0;
            d5 = JCChartUtil.convertAngle(2, this.parent.chartArea.getAngleUnit(), Math.PI * 2);
        } else if (bl4 && this.parent.vertical) {
            d4 = d7;
            if (!this.parent.isReversed() && d4 < 0.0) {
                d4 = 0.0;
            }
            d6 = d4;
            d5 = d9;
        } else {
            d6 = d7;
            d5 = d8;
        }
        if (bl4 && this.parent.vertical && !this.parent.isReversed()) {
            if (d5 < 0.0) {
                d4 = d6;
                d6 = Math.abs(d5);
                d5 = Math.abs(d4);
            } else {
                d4 = Math.abs(d6);
                if (d4 > d5) {
                    d5 = d4;
                }
                if (d6 < 0.0) {
                    d6 = 0.0;
                }
            }
        }
        d4 = d5;
        double d10 = d6;
        double d11 = 0.0;
        double d12 = this.parent.numSpacing.value;
        double d13 = this.parent.tickSpacing.value;
        if (bl5) {
            if (!this.parent.vertical) {
                this.parent.min.value = 0.0;
                this.parent.setMinIsDefault(true);
                n = this.parent.chartArea.getAngleUnit();
                this.parent.max.value = d3 = JCChartUtil.convertAngle(2, n, Math.PI * 2);
                this.parent.setMaxIsDefault(true);
            } else if (bl4 && this.parent.vertical) {
                if (this.parent.min.value < 0.0 && !this.parent.isReversed()) {
                    this.parent.min.value = 0.0;
                    this.parent.setMinIsDefault(true);
                } else if (this.parent.min.value > d7) {
                    this.parent.min.value = d7 < 0.0 && !this.parent.isReversed() ? 0.0 : d7;
                    this.parent.setMinIsDefault(true);
                } else if (d7 < 0.0 && d8 < 0.0 && !this.parent.isReversed()) {
                    this.parent.min.value = 0.0;
                    this.parent.setMinIsDefault(true);
                }
                if (this.parent.max.value < d9) {
                    this.parent.max.value = d9;
                    this.parent.setMaxIsDefault(true);
                }
            } else {
                if (this.parent.min.value > d7) {
                    this.parent.min.value = d7;
                    this.parent.setMinIsDefault(true);
                }
                if (this.parent.max.value < d8) {
                    this.parent.max.value = d8;
                    this.parent.setMaxIsDefault(true);
                }
            }
        }
        n = 0;
        do {
            this.calcPrecision();
        } while (this.fixBounds());
        d3 = d4;
        double d14 = d10;
        int n2 = this.parent.getPrecision();
        d10 = JCChartUtil.precFloor(n2, d6);
        d4 = JCChartUtil.precCeil(n2, d5);
        if (d4 <= d10) {
            n2 = this.parent.getPrecision();
            if (this.parent.max.isDefault) {
                do {
                    d4 = d10 + JCChartUtil.pow10(-n2);
                    --n2;
                } while (d4 <= d10);
            } else {
                do {
                    d10 = d4 - JCChartUtil.pow10(-n2);
                    --n2;
                } while (d4 <= d10);
            }
        }
        d10 = this.parent.min.isDefault ? d10 : this.parent.min.value;
        d4 = this.parent.max.isDefault ? d4 : this.parent.max.value;
        d11 = this.calcOrigin(d10, d4);
        double d15 = this.parent.min.isDefault ? JCChartUtil.min(d10, d11) : d10;
        double d16 = this.parent.max.isDefault ? JCChartUtil.max(d4, d11) : d4;
        double d17 = 0.0;
        boolean bl6 = false;
        int n3 = 0;
        while (n3 < 2 && !bl6) {
            d10 = JCChartUtil.precFloor(this.parent.getPrecision(), d10);
            d4 = JCChartUtil.precCeil(this.parent.getPrecision(), d4);
            d10 = this.parent.min.isDefault ? d10 : this.parent.min.value;
            d4 = this.parent.max.isDefault ? d4 : this.parent.max.value;
            d2 = this.parent.min.isDefault ? JCChartUtil.min(d10, d11) : d10;
            d = this.parent.max.isDefault ? JCChartUtil.max(d4, d11) : d4;
            d10 = d2;
            d4 = d;
            d17 = 0.5 * JCChartUtil.pow10(-this.parent.getPrecision() - 1);
            d12 = this.parent.numSpacing.value;
            d13 = this.parent.tickSpacing.value;
            int n4 = this.calcMaxAnnoSize(d10, d4);
            if (this.parent.numSpacing.isDefault && this.parent.tickSpacing.isDefault || bl4 && !this.parent.vertical) {
                double d18;
                double d19;
                int n5 = 0;
                if (bl5 && this.parent.vertical) {
                    if (this.useAnnoWidthForRAxisTickCalculation()) {
                        n5 = n4 == 0 ? 0 : (int)this.parent.polarAxisParams.radius / (n4 + 2);
                    } else {
                        d19 = JCChartUtil.boundAngle(2, this.parent.polarAxisParams.rAxisAngle + this.parent.polarAxisParams.originBase);
                        d18 = Math.sin(d19) * this.parent.polarAxisParams.radius;
                        n5 = n4 == 0 ? 0 : (int)Math.abs(d18) / (n4 + 2);
                    }
                } else if (bl4) {
                    if (this.parent.polarAxisParams.radius > 0.0) {
                        d19 = 2.0 * this.parent.polarAxisParams.radius * Math.PI;
                        n5 = (int)(d19 / 40.0);
                    }
                } else {
                    n5 = n4 == 0 ? 0 : this.parent.pixelLength() / (n4 + 2);
                }
                d19 = JCChartUtil.abs(d - d2);
                if (n5 <= 0) {
                    d12 = 1.0;
                    d13 = 1.0;
                } else if (bl4 && !this.parent.vertical) {
                    int n6;
                    if (this.parent.chartArea.getAngleUnit() == 2) {
                        while (32 % n5 != 0 && n5 > 1) {
                            --n5;
                        }
                    }
                    d18 = d19 / (double)(n5 * 4);
                    if (this.parent.chartArea.getAngleUnit() != 2) {
                        n6 = (int)d18;
                        while ((d18 - (double)n6 != 0.0 || d19 % d18 != 0.0 || n6 % 5 != 0 && n6 % 10 != 0) && n5 > 1) {
                            d18 = d19 / (double)(--n5 * 4);
                            n6 = (int)d18;
                        }
                    }
                    d13 = d18;
                    n6 = n5 < 4 ? 1 : (n5 % 2 == 1 ? (n5 % 3 == 0 ? 3 : 1) : (n5 > 4 && n5 % 4 == 0 ? 4 : 2));
                    d12 = d13 * (double)n6;
                } else {
                    d18 = d19 / (double)n5;
                    DoubleCoord doubleCoord = JCChartUtil.calcTik(d18, this.parent.getPrecision());
                    d13 = doubleCoord.x;
                    d12 = doubleCoord.y;
                }
            } else if (this.parent.tickSpacing.isDefault) {
                d12 = JCChartUtil.precCorrect(this.parent.getPrecision(), d12);
                d13 = this.parent.numSpacing.value / 2.0;
            } else if (this.parent.numSpacing.isDefault) {
                d12 = 2.0 * d13;
                d12 = JCChartUtil.precCorrect(this.parent.getPrecision(), d12);
            }
            if (d12 != 0.0) {
                double d20 = (d10 - d11) / d12;
                d10 = d20 != Math.floor(d20) ? d11 + Math.floor(d20 - 1.0) * d12 : d11 + Math.floor(d20) * d12;
                d20 = (d4 - d11) / d12;
                if (JCChartUtil.abs((d4 = d20 != Math.floor(d20) ? d11 + Math.floor(d20 + 1.0) * d12 : d11 + Math.floor(d20) * d12) - d10) < d17) {
                    d4 = d10 + d12;
                }
            } else if (JCChartUtil.abs(d4 - d10) < d17) {
                d4 = d10 + 1.0;
            }
            if (JCChartUtil.abs(d10 - d2) > d17 || JCChartUtil.abs(d4 - d) > d17) {
                bl6 = true;
                if (d4 - d12 >= d16) {
                    d4 -= d12;
                } else {
                    bl6 = false;
                }
                if (d10 + d12 <= d15) {
                    d10 += d12;
                } else {
                    bl6 = false;
                }
            }
            ++n3;
        }
        if (!this.parent.vertical && (this.parent.annotationMethod == 2 || bl5)) {
            d4 = d5;
            d10 = d6;
            if (d4 <= d10) {
                n2 = 0;
                do {
                    d4 = d10 + JCChartUtil.pow10(n2);
                    d10 -= d4 - d10;
                    ++n2;
                } while (d4 <= d10);
            }
            d15 = d10;
            d16 = d4;
        }
        if (this.parent.dataLimits != null && (this.parent.annotationMethod == 3 || this.parent.isPrimary && (bl || bl2 || bl3))) {
            d2 = d14;
            d = d3;
            if (this.parent.min.isDefault) {
                d2 = d6 - this.parent.step / 2.0;
            }
            if (this.parent.max.isDefault) {
                d = d5 + this.parent.step / 2.0;
            }
            d10 = d15 = JCChartUtil.min(d14, d2);
            d4 = d16 = JCChartUtil.max(d3, d);
        }
        if (this.parent.visible) {
            if (this.parent.min.isDefault) {
                this.parent.min.value = d10;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = d4;
            }
        } else {
            if (this.parent.min.isDefault) {
                this.parent.min.value = d15;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = d16;
            }
        }
        d11 = this.calcOrigin(this.parent.min.value, this.parent.max.value);
        if (this.parent.origin.isDefault) {
            this.parent.origin.value = d11;
        }
        if (this.parent.tickSpacing.isDefault || bl4 && !this.parent.vertical) {
            this.parent.tickSpacing.value = d13;
        }
        if (this.parent.numSpacing.isDefault || bl4 && !this.parent.vertical) {
            this.parent.numSpacing.value = d12;
        }
        if (this.parent.gridSpacing.isDefault) {
            this.parent.gridSpacing.value = this.parent.numSpacing.value;
        }
    }

    void calcTransformation() {
        int n = Math.max(this.parent.pixelLength(), 1);
        int n2 = this.parent.pixelStart();
        double d = this.parent.min.value;
        double d2 = this.parent.max.value;
        double d3 = JCChartUtil.calcError(this.parent.getPrecision());
        if (this.parent.reversed) {
            n = -n;
        }
        if (Math.abs(d2 - d) < Math.min(1.0E-8, d3)) {
            this.scale = 1.0;
            this.shift = 0.0;
            return;
        }
        this.scale = (double)n / (d2 - d);
        this.shift = n < 0 ? (double)n2 - d2 * this.scale : (double)n2 - d * this.scale;
    }

    boolean fixBounds() {
        return super.fixBounds();
    }

    void drawTicks(Graphics graphics) {
        if (this.parent.annotationMethod != 0 && this.parent.tickSpacing.isDefault) {
            super.drawTicks(graphics);
            return;
        }
        double d = JCChartUtil.calcError(this.parent.getPrecision());
        if (this.parent.tickSpacing.value <= d) {
            return;
        }
        int n = this.parent.linePosition();
        double d2 = JCChartUtil.abs(this.parent.tickSpacing.value);
        d2 = d2 < d ? d * 2.0 : d2;
        double d3 = this.parent.firstInc(d2);
        if (d3 + d2 == d3) {
            return;
        }
        int n2 = this.parent.pixelLength() * 2;
        int n3 = 0;
        while (n3 < n2 && d3 <= this.parent.max.value + d) {
            this.drawTickMark(graphics, d3, n);
            d3 += d2;
            ++n3;
        }
    }

    String format(double d, int n) {
        return JCChartUtil.format(d, n);
    }

    void calcPrecision() {
        if (this.parent.precision.isDefault) {
            if (this.parent.annotationMethod == 2 || this.parent.dataLimits == null) {
                this.parent.precision.value = 0;
            } else if (!this.parent.numSpacing.isDefault) {
                this.parent.precision.value = JCChartUtil.tickBasedPrecision(this.parent.numSpacing.value);
            } else {
                double d = this.parent.min.isDefault ? this.parent.dataLimits.min : this.parent.min.value;
                double d2 = this.parent.max.isDefault ? this.parent.dataLimits.max : this.parent.max.value;
                this.parent.precision.value = d2 <= d ? JCChartUtil.nicePrecision(d2) : JCChartUtil.nicePrecision(d2 - d);
            }
        }
        int n = JCChartUtil.clamp(this.parent.getPrecision(), -this.parent.getMaxPrecision(), this.parent.getMaxPrecision());
        this.parent.setPrecisionInternal(n);
    }

    double range() {
        return this.parent.max.value - this.parent.min.value;
    }

    void translate(double d) {
        if (this.parent.reversed) {
            d = -d;
        }
        this.parent.min.value += d;
        this.parent.max.value += d;
    }

    private boolean useAnnoWidthForRAxisTickCalculation() {
        double d = JCChartUtil.getAngleRatio(2, this.parent.polarAxisParams.rAxisAngle, this.parent.polarAxisParams.originBase, false);
        return d < 0.05 || d > 0.95 || d > 0.45 && d < 0.55;
    }

    private int calcMaxAnnoSize(double d, double d2) {
        int n = -1;
        Dimension dimension = new Dimension();
        this.getAnnoExtent(dimension, d2, this.parent.getPrecision());
        this.getAnnoExtent(dimension, d, this.parent.getPrecision());
        if (this.parent.isPolar() || this.parent.isRadar()) {
            n = this.useAnnoWidthForRAxisTickCalculation() ? dimension.width : dimension.height;
        } else {
            if (this.parent.vertical) {
                this.parent.setSize(dimension.width + 1 + this.parent.tickLength / 2, this.parent.getHeight());
            } else {
                this.parent.setSize(this.parent.getWidth(), dimension.height + 1 + this.parent.tickLength / 2);
            }
            n = this.parent.vertical ? dimension.height : dimension.width;
        }
        return n;
    }

    private double calcOrigin(double d, double d2) {
        double d3 = 0.0;
        if (this.parent.origin.isDefault) {
            switch (this.parent.originPlacement.value) {
                case 3: {
                    d3 = 0.0;
                    break;
                }
                case 1: {
                    d3 = d;
                    break;
                }
                case 2: {
                    d3 = d2;
                    break;
                }
                case 0: {
                    d3 = d <= 0.0 && d2 >= 0.0 ? 0.0 : d;
                }
            }
        } else {
            d3 = this.parent.origin.value;
        }
        return d3;
    }
}

