/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.BeanTextParser;
import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.PolarRadarWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PolarRadarEditor
extends JPanel
implements PropertyEditor,
ItemListener,
FocusListener,
ActionListener {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected JTextField textOriginBase;
    protected JTextField textYAxisAngle;
    protected JComboBox comboAngleUnit;
    protected JCheckBox cbHalfRange;
    protected JCheckBox cbCircularGrid;
    protected String[] strAngleUnit = new String[]{JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key180"), JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key181"), JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key182")};
    protected int[] angleUnits = new int[]{1, 2, 3};
    PolarRadarWrapper wrap = null;

    public PolarRadarEditor() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2));
        this.textOriginBase = new JTextField("", 5);
        this.textYAxisAngle = new JTextField("", 5);
        this.comboAngleUnit = new JComboBox();
        this.textOriginBase.addActionListener(this);
        this.textOriginBase.addFocusListener(this);
        this.textYAxisAngle.addActionListener(this);
        this.textYAxisAngle.addFocusListener(this);
        this.comboAngleUnit.addActionListener(this);
        jPanel.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key175")));
        jPanel.add(this.textOriginBase);
        jPanel.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key176")));
        jPanel.add(this.textYAxisAngle);
        jPanel.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key177")));
        int n = 0;
        while (n < this.strAngleUnit.length) {
            this.comboAngleUnit.addItem(this.strAngleUnit[n]);
            ++n;
        }
        jPanel.add(this.comboAngleUnit);
        this.add("North", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        this.cbHalfRange = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key178"), false);
        if (this.cbHalfRange != null) {
            this.cbHalfRange.addItemListener(this);
            jPanel2.add(this.cbHalfRange);
        }
        if ((this.cbCircularGrid = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key179"), false)) != null) {
            this.cbCircularGrid.addItemListener(this);
            jPanel2.add(this.cbCircularGrid);
        }
        this.add("South", jPanel2);
    }

    public void setValue(Object object) {
        if (object != null) {
            try {
                this.wrap = (PolarRadarWrapper)object;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.wrap == null) {
            this.wrap = new PolarRadarWrapper();
        }
        this.switchValues();
    }

    protected void switchValues() {
        if (this.wrap == null) {
            return;
        }
        this.textOriginBase.setText("" + this.wrap.originBase);
        this.textYAxisAngle.setText("" + this.wrap.yAxisAngle);
        this.comboAngleUnit.setSelectedIndex(this.getAngleUnitIndex(this.wrap.angleUnit));
        this.cbHalfRange.setSelected(this.wrap.halfRange);
        this.cbCircularGrid.setSelected(this.wrap.circularGrid);
    }

    protected int getAngleUnitIndex(int n) {
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        while (n3 < this.angleUnits.length) {
            if (this.angleUnits[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    protected void setSelectedValue(Object object) {
        if (this.wrap == null) {
            return;
        }
        if (object == this.textOriginBase) {
            try {
                this.wrap.originBase = Double.parseDouble(this.textOriginBase.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.textYAxisAngle) {
            try {
                this.wrap.yAxisAngle = Double.parseDouble(this.textYAxisAngle.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (object == this.comboAngleUnit) {
            int n = this.comboAngleUnit.getSelectedIndex();
            if (n >= 0 && n < this.angleUnits.length) {
                this.wrap.angleUnit = this.angleUnits[n];
            }
        } else if (object == this.cbHalfRange) {
            this.wrap.halfRange = this.cbHalfRange.isSelected();
        } else if (object == this.cbCircularGrid) {
            this.wrap.circularGrid = this.cbCircularGrid.isSelected();
        }
        this.support.firePropertyChange("", null, null);
    }

    public Object getValue() {
        return this.wrap;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Vector vector = BeanTextParser.parse(string);
        if (vector.size() != 5) {
            throw new IllegalArgumentException();
        }
        PolarRadarWrapper polarRadarWrapper = null;
        try {
            polarRadarWrapper = new PolarRadarWrapper(Double.parseDouble((String)vector.elementAt(0)), Double.parseDouble((String)vector.elementAt(1)), Integer.parseInt((String)vector.elementAt(2)), Boolean.valueOf((String)vector.elementAt(3)), Boolean.valueOf((String)vector.elementAt(4)));
            this.setValue(polarRadarWrapper);
            this.support.firePropertyChange("", null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public String getAsText() {
        if (this.wrap != null) {
            return this.wrap.toString();
        }
        return null;
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        return "new com.klg.jclass.chart.beans.PolarRadarWrapper(" + this.wrap + ")";
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            this.setSelectedValue(object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox) {
            this.setSelectedValue(object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JTextField || object instanceof JComboBox) {
            this.setSelectedValue(object);
        }
    }
}

