/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.property;

import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.property.PropertyPersistorModel;
import com.klg.jclass.chart.property.PropertySaveFactory;
import com.klg.jclass.chart.property.PropertySaveModel;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;

public class ComponentPropertySave
implements PropertySaveModel {
    protected Component component = null;
    protected Component defaultComponent = null;
    protected Color compBackground;
    protected Color defBackground;
    protected Color compForeground;
    protected Color defForeground;
    protected Font compFont;
    protected Font defFont;
    protected boolean compIsOpaque;
    protected boolean defIsOpaque;
    protected boolean compIsVisible;
    protected boolean defIsVisible;
    protected Border compBorder;
    protected Border defBorder;

    public void setSource(Object object) {
        if (object instanceof Component) {
            this.component = (Component)object;
        }
    }

    public void setDefault(Object object) {
        if (object instanceof Component) {
            this.defaultComponent = (Component)object;
        }
    }

    public boolean checkProperties(PropertyPersistorModel propertyPersistorModel) {
        if (this.component == null || this.defaultComponent == null) {
            return false;
        }
        this.compBackground = this.component.getBackground();
        this.defBackground = this.defaultComponent.getBackground();
        this.compForeground = this.component.getForeground();
        this.defForeground = this.defaultComponent.getForeground();
        this.compFont = this.component.getFont();
        this.defFont = this.defaultComponent.getFont();
        this.compIsOpaque = ((JComponent)this.component).isOpaque();
        this.defIsOpaque = ((JComponent)this.defaultComponent).isOpaque();
        this.compIsVisible = ((JComponent)this.component).isVisible();
        this.defIsVisible = ((JComponent)this.defaultComponent).isVisible();
        this.compBorder = ((JComponent)this.component).getBorder();
        this.defBorder = ((JComponent)this.defaultComponent).getBorder();
        return !this.compBackground.equals(this.defBackground) || !this.compForeground.equals(this.defForeground) || !this.compFont.equals(this.defFont) || this.compIsOpaque != this.defIsOpaque || this.compIsVisible != this.defIsVisible || this.compBorder != this.defBorder;
    }

    public void saveProperties(PropertyPersistorModel propertyPersistorModel, String string, int n) {
        if (this.component == null || this.defaultComponent == null) {
            System.out.println("FAILURE: No component set ");
            return;
        }
        if (!this.checkProperties(propertyPersistorModel)) {
            return;
        }
        int n2 = propertyPersistorModel.writeBegin("component", n);
        boolean bl = false;
        if (!this.compBackground.equals(this.defBackground)) {
            bl = true;
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "background", n2, JCSwingTypeConverter.fromColor(this.compBackground));
        }
        if (this.compIsOpaque != this.defIsOpaque || bl && !this.compIsOpaque) {
            propertyPersistorModel.writeProperty(string, "opaque", n2, new Boolean(this.compIsOpaque));
        }
        if (!this.compForeground.equals(this.defForeground)) {
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "foreground", n2, JCSwingTypeConverter.fromColor(this.compForeground));
        }
        if (!this.compFont.equals(this.defFont)) {
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "font", n2, JCSwingTypeConverter.fromFont(this.compFont));
        }
        if (this.compIsVisible != this.defIsVisible) {
            propertyPersistorModel.writeProperty(string, "visible", n2, new Boolean(this.compIsVisible));
        }
        if (this.compBorder != this.defBorder) {
            propertyPersistorModel.writeEnd(null, n, true, true);
            this.writeBorder(propertyPersistorModel, string, n + PropertySaveFactory.tabIncrement);
            propertyPersistorModel.writeEnd("component", n, true, false);
        } else {
            propertyPersistorModel.writeEnd(null, n, true, false);
        }
    }

    public static void writeInsets(PropertyPersistorModel propertyPersistorModel, String string, int n, Insets insets) {
        int n2 = propertyPersistorModel.writeBegin("insets", n);
        propertyPersistorModel.writeProperty(string, "left", n2, new Integer(insets.left));
        propertyPersistorModel.writeProperty(string, "right", n2, new Integer(insets.right));
        propertyPersistorModel.writeProperty(string, "top", n2, new Integer(insets.top));
        propertyPersistorModel.writeProperty(string, "bottom", n2, new Integer(insets.bottom));
        propertyPersistorModel.writeEnd(null, n, true, false);
    }

    public void writeBorder(PropertyPersistorModel propertyPersistorModel, String string, int n) {
        if (this.compBorder == null || this.compBorder instanceof UIResource) {
            return;
        }
        if (propertyPersistorModel.getType().equals("HTML")) {
            String string2 = JCSwingTypeConverter.fromBorder(this.compBorder, this.component);
            if (string2 != null) {
                propertyPersistorModel.writeProperty(string, "border", n, string2);
            }
        } else if (this.compBorder instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)this.compBorder;
            int n2 = propertyPersistorModel.writeBegin("matte-border", n);
            Color color = JCSwingTypeConverter.getMatteBorderColor(matteBorder, this.component);
            if (color == null) {
                color = Color.black;
            }
            propertyPersistorModel.writeProperty(string, "color", n2, JCSwingTypeConverter.fromColor(color));
            propertyPersistorModel.writeEnd(null, n, true, true);
            ComponentPropertySave.writeInsets(propertyPersistorModel, string, n + PropertySaveFactory.tabIncrement, matteBorder.getBorderInsets(this.component));
            propertyPersistorModel.writeEnd("matte-border", n, true, false);
        } else if (this.compBorder instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)this.compBorder;
            int n3 = propertyPersistorModel.writeBegin("empty-border", n);
            propertyPersistorModel.writeEnd(null, n, true, true);
            ComponentPropertySave.writeInsets(propertyPersistorModel, string, n + PropertySaveFactory.tabIncrement, emptyBorder.getBorderInsets(this.component));
            propertyPersistorModel.writeEnd("empty-border", n, true, false);
        } else if (this.compBorder instanceof BevelBorder || this.compBorder instanceof SoftBevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)this.compBorder;
            int n4 = propertyPersistorModel.writeBegin("bevel-border", n);
            propertyPersistorModel.writeProperty(string, "soft", n4, new Boolean(bevelBorder instanceof SoftBevelBorder));
            String string3 = bevelBorder.getBevelType() == 0 ? "Raised" : "Lowered";
            propertyPersistorModel.writeProperty(string, "type", n4, string3);
            Color color = bevelBorder.getHighlightInnerColor(this.component);
            Color color2 = bevelBorder.getShadowOuterColor(this.component);
            if (color != null && color2 != null) {
                propertyPersistorModel.writeProperty(string, "highlightColor", n4, JCSwingTypeConverter.fromColor(color));
                propertyPersistorModel.writeProperty(string, "shadowColor", n4, JCSwingTypeConverter.fromColor(color2));
            }
            propertyPersistorModel.writeEnd(null, n, true, false);
        } else if (this.compBorder instanceof EtchedBorder) {
            EtchedBorder etchedBorder = (EtchedBorder)this.compBorder;
            int n5 = propertyPersistorModel.writeBegin("etched-border", n);
            String string4 = etchedBorder.getEtchType() == 0 ? "Raised" : "Lowered";
            propertyPersistorModel.writeProperty(string, "type", n5, string4);
            Color color = etchedBorder.getHighlightColor(this.component);
            Color color3 = etchedBorder.getShadowColor(this.component);
            if (color != null && color3 != null) {
                propertyPersistorModel.writeProperty(string, "highlightColor", n5, JCSwingTypeConverter.fromColor(color));
                propertyPersistorModel.writeProperty(string, "shadowColor", n5, JCSwingTypeConverter.fromColor(color3));
            }
            propertyPersistorModel.writeEnd(null, n, true, false);
        } else if (this.compBorder instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)this.compBorder;
            int n6 = propertyPersistorModel.writeBegin("line-border", n);
            Color color = lineBorder.getLineColor();
            if (color == null) {
                color = Color.black;
            }
            propertyPersistorModel.writeProperty(string, "color", n6, JCSwingTypeConverter.fromColor(color));
            if (lineBorder.getThickness() > 1) {
                propertyPersistorModel.writeProperty(string, "thickness", n6, new Integer(lineBorder.getThickness()));
            }
            propertyPersistorModel.writeEnd(null, n, true, false);
        } else if (this.compBorder instanceof TitledBorder) {
            Color color;
            Object object;
            int n7;
            TitledBorder titledBorder = (TitledBorder)this.compBorder;
            String string5 = titledBorder.getTitle();
            if (string5 == null || string5.length() == 0) {
                return;
            }
            int n8 = propertyPersistorModel.writeBegin("titled-border", n);
            propertyPersistorModel.writeProperty(string, "title", n8, propertyPersistorModel.expandText(string5));
            int n9 = titledBorder.getTitlePosition();
            if (n9 != 0) {
                String string6 = JCTypeConverter.fromEnum(n9, JCSwingTypeConverter.positionStrings, JCSwingTypeConverter.positionValues);
                propertyPersistorModel.writeProperty(string, "titlePosition", n8, string6);
            }
            if ((n7 = titledBorder.getTitleJustification()) != 0) {
                object = JCTypeConverter.fromEnum(n7, JCSwingTypeConverter.justificationStrings, JCSwingTypeConverter.justificationValues);
                propertyPersistorModel.writeProperty(string, "titleJustification", n8, object);
            }
            if ((color = titledBorder.getTitleColor()) != null) {
                propertyPersistorModel.writeProperty(string, "color", n8, JCSwingTypeConverter.fromColor(color));
            }
            if ((object = titledBorder.getTitleFont()) != null) {
                propertyPersistorModel.writeProperty(string, "font", n8, JCSwingTypeConverter.fromFont((Font)object));
            }
            propertyPersistorModel.writeEnd(null, n, true, false);
        }
    }

    protected static void writeUI(PropertyPersistorModel propertyPersistorModel, String string, String string2, int n, Object object) {
        if (object == null || object instanceof UIResource) {
            return;
        }
        propertyPersistorModel.writeProperty(string, string2, n, object);
    }

    public boolean checkLayoutHints(JCChart jCChart, JComponent jComponent) {
        Rectangle rectangle = jCChart.getLayoutHints(jComponent);
        if (rectangle == null) {
            return false;
        }
        return rectangle.x != Integer.MAX_VALUE || rectangle.y != Integer.MAX_VALUE || rectangle.width != Integer.MAX_VALUE || rectangle.height != Integer.MAX_VALUE;
    }

    public void saveLayoutHints(PropertyPersistorModel propertyPersistorModel, JCChart jCChart, JComponent jComponent, String string, int n) {
        if (!this.checkLayoutHints(jCChart, jComponent)) {
            return;
        }
        Rectangle rectangle = jCChart.getLayoutHints(jComponent);
        if (rectangle != null) {
            int n2 = propertyPersistorModel.writeBegin("layout-hints", n);
            if (rectangle.x != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "x", n2, new Integer(rectangle.x));
            }
            if (rectangle.y != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "y", n2, new Integer(rectangle.y));
            }
            if (rectangle.width != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "width", n2, new Integer(rectangle.width));
            }
            if (rectangle.height != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "height", n2, new Integer(rectangle.height));
            }
            propertyPersistorModel.writeEnd(null, n, true, false);
        }
    }
}

