/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.DefaultSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBoxMutableModel;
import com.klg.jclass.util.value.JCValueEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JCSpinBox
extends AbstractSpinBox
implements ItemSelectable {
    protected JCSpinBoxModel model;
    protected JCListenerList itemListeners = null;
    protected JCListenerList actionListeners = null;
    protected String actionCommand = "spinBoxChanged";
    protected ListDataListener listDataListener = new ListListener();
    protected boolean modelChanging = false;
    protected KeySelectionManager keySelectionManager;
    protected Object lastSelectedItem = null;
    protected boolean firstPaint = true;

    public JCSpinBox(JCSpinBoxModel jCSpinBoxModel) {
        this.setModel(jCSpinBoxModel);
        this.setOpaque(true);
        this.updateUI();
    }

    public JCSpinBox(Object[] objectArray) {
        this.setModel(new DefaultSpinBoxModel(objectArray));
        this.updateUI();
    }

    public JCSpinBox(Vector vector) {
        this.setModel(new DefaultSpinBoxModel(vector));
        this.updateUI();
    }

    public JCSpinBox() {
        this.setModel(new DefaultSpinBoxModel());
        this.updateUI();
    }

    public void paint(Graphics graphics) {
        if (!this.isEditable() && this.firstPaint) {
            this.firstPaint = false;
            Object object = this.getModel().getSelectedItem();
            if (object == null) {
                object = this.getItemAt(0);
            }
            this.setValue(object);
        }
        super.paint(graphics);
    }

    protected Object spinUp() {
        int n = this.getSelectedIndex();
        if (++n < this.getItemCount()) {
            return this.getItemAt(n);
        }
        return this.getItemAt(0);
    }

    protected Object spinDown() {
        int n = this.getSelectedIndex();
        if (--n >= 0) {
            return this.getItemAt(n);
        }
        return this.getItemAt(this.getItemCount() - 1);
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    protected void processValueChanged(JCValueEvent jCValueEvent) {
        if (this.modelChanging) {
            return;
        }
        this.model.setSelectedItem(jCValueEvent.getNewValue());
        super.processValueChanged(jCValueEvent);
    }

    protected void checkArrowButtons() {
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setModel(JCSpinBoxModel jCSpinBoxModel) {
        JCSpinBoxModel jCSpinBoxModel2 = this.model;
        if (this.model != null) {
            this.model.removeListDataListener(this.listDataListener);
        }
        this.model = jCSpinBoxModel;
        this.firePropertyChange("model", jCSpinBoxModel2, this.model);
        this.model.addListDataListener(this.listDataListener);
        if (!this.isEditable()) {
            this.setValue(this.model.getElementAt(0));
        }
        this.invalidate();
    }

    public JCSpinBoxModel getModel() {
        return this.model;
    }

    public Object getItemAt(int n) {
        return this.model.getElementAt(n);
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public boolean selectWithKeyChar(char c) {
        int n;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = new DefaultKeySelectionManager();
        }
        if ((n = this.keySelectionManager.selectionForKey(c, this.getModel())) != -1) {
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int n) {
        int n2 = this.model.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.model.getElementAt(n));
        }
    }

    public int getSelectedIndex() {
        Object object = this.model.getSelectedItem();
        int n = 0;
        int n2 = this.model.getSize();
        while (n < n2) {
            Object e = this.model.getElementAt(n);
            if (e.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setSelectedItem(Object object) {
        this.setValue(object);
    }

    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public void insertItemAt(Object object, int n) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).insertElementAt(object, n);
    }

    public void addItem(Object object) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).addElement(object);
    }

    public void removeItem(Object object) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).removeElement(object);
    }

    public void removeItemAt(int n) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).removeElementAt(n);
    }

    public void removeAllItems() {
        this.checkSpinBoxMutableModel();
        JCSpinBoxMutableModel jCSpinBoxMutableModel = (JCSpinBoxMutableModel)this.model;
        int n = jCSpinBoxMutableModel.getSize();
        if (jCSpinBoxMutableModel instanceof DefaultSpinBoxModel) {
            ((DefaultSpinBoxModel)jCSpinBoxMutableModel).removeAllElements();
        } else {
            int n2 = 0;
            while (n2 < n) {
                Object e = jCSpinBoxMutableModel.getElementAt(0);
                jCSpinBoxMutableModel.removeElement(e);
                ++n2;
            }
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners = JCListenerList.add(this.itemListeners, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners = JCListenerList.remove(this.itemListeners, itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected int preferredWidthOfView() {
        int n = 10;
        int n2 = 0;
        while (n2 < this.getItemCount()) {
            Component component;
            if (this.isEditable()) {
                this.editor.setItem(this.getItemAt(n2));
                component = this.editor.getEditorComponent();
                n = Math.max(n, component.getPreferredSize().width);
            } else {
                component = this.renderer.getComponent(this, this.getItemAt(n2));
                n = Math.max(n, component.getPreferredSize().width + 8);
            }
            ++n2;
        }
        if (this.isEditable()) {
            this.editor.setItem(this.valueModel.getValue());
        } else {
            this.renderer.getComponent(this, this.valueModel.getValue());
        }
        return n;
    }

    protected void checkSpinBoxMutableModel() {
        if (!(this.model instanceof JCSpinBoxMutableModel)) {
            throw new InternalError("Cannot use this method with a non-Mutable data model.");
        }
    }

    protected void modelChanged() {
        ItemListener itemListener;
        Enumeration enumeration;
        ItemEvent itemEvent;
        this.modelChanging = true;
        this.editor.setItem(this.model.getSelectedItem());
        this.renderer.getComponent(this, this.model.getSelectedItem());
        this.modelChanging = false;
        Object object = this.model.getSelectedItem();
        if (this.lastSelectedItem != object && this.lastSelectedItem != null) {
            itemEvent = new ItemEvent(this, 701, this.lastSelectedItem, 2);
            enumeration = JCListenerList.elements(this.itemListeners);
            while (enumeration.hasMoreElements()) {
                itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
        this.lastSelectedItem = object;
        if (object != null) {
            itemEvent = new ItemEvent(this, 701, object, 1);
            enumeration = JCListenerList.elements(this.itemListeners);
            while (enumeration.hasMoreElements()) {
                itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (!this.isEditable() && this.selectWithKeyChar(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c, JCSpinBoxModel jCSpinBoxModel) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = jCSpinBoxModel.getSelectedItem();
            if (object != null) {
                object = object.toString();
                n2 = 0;
                n = jCSpinBoxModel.getSize();
                while (n2 < n) {
                    if (object.equals(jCSpinBoxModel.getElementAt(n2).toString())) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
            }
            String string2 = ("" + c).toLowerCase();
            c = string2.charAt(0);
            n2 = ++n3;
            n = jCSpinBoxModel.getSize();
            while (n2 < n) {
                string = jCSpinBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                string = jCSpinBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, JCSpinBoxModel var2);
    }

    class ListListener
    implements ListDataListener,
    Serializable {
        ListListener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }
    }
}

