/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.InvalidLicenseException;
import com.sitraka.licensing.LicenseProperties;
import com.sitraka.licensing.util.Debug;
import com.sitraka.licensing.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeMap;

public class Licenses {
    protected File licensesFile;
    protected TreeMap map = new TreeMap();

    public Licenses(File licenses_file) throws IOException {
        this.licensesFile = licenses_file;
        if (this.licensesFile.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.licensesFile));
            this.load(is);
            ((InputStream)is).close();
        }
    }

    public Licenses(URL licenses_url) throws IOException {
        if (licenses_url != null) {
            BufferedInputStream is = new BufferedInputStream(licenses_url.openStream());
            this.load(is);
            ((InputStream)is).close();
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean addLicenseProperties(LicenseProperties license_properties) throws InvalidLicenseException {
        if (license_properties == null) {
            throw new InvalidLicenseException("license properties may not be null");
        }
        if (!license_properties.isValid()) {
            throw new InvalidLicenseException("LicenseProperties is not valid");
        }
        if (this.map.containsKey(license_properties.getSerialNumber())) {
            return false;
        }
        this.map.put(license_properties.getSerialNumber(), license_properties);
        return true;
    }

    public boolean removeLicenseProperties(LicenseProperties license_properties) {
        return this.map.remove(license_properties.getSerialNumber()) != null;
    }

    public LicenseProperties getLicenseProperties(String serialNumber) {
        return (LicenseProperties)this.map.get(serialNumber);
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public void store() throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.licensesFile));
        PrintWriter out = new PrintWriter(os);
        Iterator i = this.iterator();
        out.println("<licenses>");
        while (i.hasNext()) {
            LicenseProperties lp = (LicenseProperties)i.next();
            out.println("<license>");
            out.flush();
            lp.store(os, "license properties");
            ((OutputStream)os).flush();
            out.println("</license>");
        }
        out.println("</licenses>");
        out.flush();
        ((OutputStream)os).close();
    }

    public void load(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String[] pair = new String[2];
        LicenseProperties current_properties = null;
        String line = in.readLine();
        while (line != null) {
            if (current_properties != null) {
                if (line.startsWith("</license>")) {
                    String sn = current_properties.getSerialNumber();
                    if (sn == null) {
                        throw new IOException("LicenseProperties MUST contain a serial number");
                    }
                    this.map.put(sn, current_properties);
                    current_properties = null;
                } else {
                    Debug.println("Licenses", "processing line = " + line);
                    if (PropertyUtils.parseLine(line, pair)) {
                        String property = pair[0];
                        String value = pair[1];
                        pair[1] = null;
                        pair[0] = null;
                        Debug.println("Licenses", "Setting prop(" + property + ", " + value + ")");
                        current_properties.setProperty(property, value);
                    }
                }
            } else if (line.startsWith("<license>")) {
                current_properties = new LicenseProperties();
            } else {
                Debug.println("Licenses", "Skiping line = \"" + line + "\"");
            }
            line = in.readLine();
        }
        in.close();
    }
}

