/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

public final class ParameterCheck {
    public static void nonNull(Object anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException("Object is null");
        }
    }

    public static void notEmpty(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException("String is null");
        }
        if (aString.equals("")) {
            throw new IllegalArgumentException("String is empty");
        }
    }

    public static void noLessThan(int anInt, int minimum) {
        if (anInt < minimum) {
            throw new IllegalArgumentException("Value " + anInt + " is out of range.  It is should be no less than " + minimum);
        }
    }

    public static void greaterThan(int anInt, int minimum) {
        if (anInt <= minimum) {
            throw new IllegalArgumentException("Value " + anInt + " is out of range.  It should be greater than " + minimum);
        }
    }

    public static void noGreaterThan(int anInt, int maximum) {
        if (anInt > maximum) {
            throw new IllegalArgumentException("Value " + anInt + "is out of " + "range. It should be no greater than " + maximum);
        }
    }

    public static void lessThan(int anInt, int maximum) {
        if (anInt >= maximum) {
            throw new IllegalArgumentException("Value " + anInt + " is out of range.  " + "It should be less than " + maximum);
        }
    }

    public static void noLessThan(double aDouble, double minimum) {
        if (aDouble < minimum) {
            throw new IllegalArgumentException("Value " + aDouble + " is out of range.  " + "It should be no less than " + minimum);
        }
    }

    public static void greaterThan(double aDouble, double minimum) {
        if (aDouble <= minimum) {
            throw new IllegalArgumentException("Value " + aDouble + " is out of range.  " + "It should be greater than " + minimum);
        }
    }

    public static void noGreaterThan(double aDouble, double maximum) {
        if (aDouble > maximum) {
            throw new IllegalArgumentException("Value " + aDouble + " is out of range.  " + "It should be no greater than " + maximum);
        }
    }

    public static void lessThan(double aDouble, double maximum) {
        if (aDouble >= maximum) {
            throw new IllegalArgumentException("Value " + aDouble + " is out of range.  It should be less than " + maximum);
        }
    }

    public static void withinRange(int anInt, int minimum, int maximum) {
        ParameterCheck.noLessThan(anInt, minimum);
        ParameterCheck.noGreaterThan(anInt, maximum);
    }

    public static void withinRange(double aDouble, double minimum, double maximum) {
        ParameterCheck.noLessThan(aDouble, minimum);
        ParameterCheck.noGreaterThan(aDouble, maximum);
    }

    public static void withinCount(int anInt, int count) {
        ParameterCheck.withinRange(anInt, 0, count - 1);
    }

    public static void isTrue(boolean generalTest, String message) {
        if (!generalTest) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean generalTest, String message) {
        if (generalTest) {
            throw new IllegalArgumentException(message);
        }
    }
}

