#!/bin/sh

. /tmp/openit-cfg-shenv

# Author : Romnick C. Coros
# Last Update : March 28, 2017

#Declare variables for the current httpd.conf and the backup
OLD_HTTPD=$CONFIG_DIR/httpd/httpd.conf.pre_7-0-6-0
HTTPD=$CONFIG_DIR/httpd/httpd.conf
USESSL=$CONFIG_DIR/httpd/use_ssl

#Backup the old httpd.conf
if [ ! -f $OLD_HTTPD ];	then
	cp $HTTPD $OLD_HTTPD
fi

#Get values from the old httpd.conf
servername=`grep ServerName $OLD_HTTPD | cut -d " " -f2`
backendport=`grep "127.0.0.1:" $OLD_HTTPD | cut -d ":" -f2`
virtualhost=`grep "VirtualHost _default_:" $OLD_HTTPD | cut -d ":" -f2 | cut -d ">" -f1`
user=`grep "User " $OLD_HTTPD | cut -d " " -f2`
group=`grep "Group " $OLD_HTTPD | cut -d " " -f2`

#Get default values if not existing on old httpd.conf
port=8080
if [ -z "$backendport" ]; then
	backendport=8880
fi
if [ -z "$servername" ]; then
	servername=`hostname`
fi

#Copy the new httpd.conf to installation
	cp files/conf/httpd.conf $HTTPD

#Replace the values in the new httpd using the values from the old one
sed -i -e 's/User openit/User '$user'/g' $HTTPD
sed -i -e 's/Group openit/Group '$group'/g' $HTTPD
sed -i -e 's/SERVER_NAME/'$servername'/g' $HTTPD
sed -i -e 's/SERVER_PORT/'$port'/g' $HTTPD
sed -i -e 's/BACKEND_PORT/'$backendport'/g' $HTTPD
sed -i -e 's/SSL_PORT/'$virtualhost'/g' $HTTPD
sed -i -e 's/VIRTUAL_HOST/'$virtualhost'/g' $HTTPD

#Make sure TEMP_DIR/httpd is owned by the user
chown -R $user:$group $TEMP_DIR/httpd