/**
 * Validate a form through Ajax
 * 
 * @requires /html/js/jquery-plugins/jquery.tooltipsy.min.js, /html/css/jquery.tooltipsy.css, /html/js/jquery.toltipsy.init.js
 * @param {string} $qForm Query string of target form
 * @param {closure} $callback The callback with parameters (array required_error_ids, int status, array validationResult)
 * @returns {undefined}
 * @author Allen Linatoc
 */
window.Ajaxidate = function ($qForm, $url, $callback)
{

    var required_err_ids = [];

    var checkables = [];


    $jQuery($qForm + " input, " + $qForm + " textarea").each(
            function ()
            {

                var jqThis = $jQuery(this);



                // Check if required but no value indicated

                if (jqThis.attr('required') && $jQuery.trim(jqThis.val().toString()).length == 0)
                {
                    required_err_ids.push(jqThis.attr('id'));
                }
                else if (jqThis.attr('data-type') && jqThis.attr('name') && required_err_ids.length == 0)
                {
                    // Push JSON row

                    var jsonRow = {
                        "name": jqThis.attr('name'),
                        "type": jqThis.attr('data-type'),
                        "value": jqThis.val() ? jqThis.val() : ""
                    };

                    if (jqThis.attr('data-inclusive'))
                        jsonRow.inclusive = jqThis.attr('data-inclusive');

                    checkables.push(jsonRow);
                }

            }

    );

    var validationResult = [];
//    console.log(checkables);

    if (required_err_ids.length == 0)
    {
        if (checkables.length > 0)
        {
            var jsonString = JSON.stringify(checkables);
//            console.log(jsonString);

            $jQuery.ajax({
                url: $url,
                type: 'POST',
                data: {"ajaxidate": jsonString},
                success: function (data)
                {
                    if (data.validation_response_array)
                        validationResult = data.validation_response_array;
                    $callback(required_err_ids, data.success ? Ajaxidate.VALIDATION_SUCCESS : Ajaxidate.VALIDATION_FAILED, validationResult);
                },
                error: function ()
                {
                    $callback(required_err_ids, Ajaxidate.NETWORK_ERROR, validationResult);
                }
            });
        }
        else
        {
            $callback(required_err_ids, Ajaxidate.VALIDATION_SUCCESS, validationResult);
        }
    }
    else
    {
        $callback(required_err_ids, Ajaxidate.VALIDATION_FAILED, validationResult);
    }
};

window.Ajaxidate.NETWORK_ERROR = 3;
window.Ajaxidate.VALIDATION_FAILED = 2;
window.Ajaxidate.VALIDATION_SUCCESS = 1;
window.$jQuery = jQuery.noConflict();


/**
 * Lock a form
 *
 * @param {string} $jqForm Query string of target form
 * @param {string} $action [optional] Action, whether "readonly" or "disabled". Default is "readonly".
 */
window.Ajaxidate.lockDown = function ($jqForm, $action)
{
    if ($action == undefined)
        $action = "readonly";

    var jqFormFields = $jQuery($jqForm + ' input, ' + $jqForm + ' textarea');
    jqFormFields.attr($action, $action);

    // Disable on controls and buttons
    var jqFormControls = $jQuery($jqForm + ' input[type=button], ' + $jqForm + ' input[type=submit], ' + $jqForm + ' button');
    jqFormControls.attr('disabled', 'disabled');
};

/**
 * Unlock a form
 *
 * @param {string} $jqForm Query string of target form
 */
window.Ajaxidate.unlock = function ($jqForm)
{
    var jqFormControls = $jQuery($jqForm + ' input, ' + $jqForm + ' textarea');

    jqFormControls.removeAttr('readonly').removeAttr('disabled');

    // Enable back controls and buttons
    var jqFormControls = $jQuery($jqForm + ' input[type=button], ' + $jqForm + ' input[type=submit], ' + $jqForm + ' button');
    jqFormControls.removeAttr('disabled');
}



