// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

// Depends on csslint.js from https://github.com/stubbornella/csslint

// declare global: CSSLint

(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    mod(require("../../lib/codemirror"));
  else if (typeof define == "function" && define.amd) // AMD
    define(["../../lib/codemirror"], mod);
  else // Plain browser env
    mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.registerHelper("lint", "handleconfig", function(text) {
  var found = [];
  var messages = null, message = null, folder= null, filename=null,dir_file=null;

  var type = document.getElementById("actionType").value;
  if(type == "Add"){
    folder = document.getElementById("folderHandle").value;
  }else{
    folder = document.getElementById("folder").value;
    filename = document.getElementById("fileName").value;
  }

  // call handle file validator
  $j.ajax({
    type:"post",
//    dataType:"text",
    async: false,
    url: "/admin/validate_handlefile.php",
    data: {content: text, folder: folder},
    success: function(data){
      if(data == "Error"){
        found.push({
          from: CodeMirror.Pos(-1, 0),
          to: CodeMirror.Pos(-1, 0),
          message: "",
          severity : "error"
      })
      }else{
        messages = JSON.parse(data);
        if(type == "Edit"){
          dir_file = messages.dir_file + filename
        }
      }
    }
  });

  if(messages != null && messages.Error && messages.Error.length > 0){
    for ( var i = 0; i < messages.Error.length; i++) {
      message = messages.Error[i];
      if(dir_file != null && message.message.match("Duplicate name") != null && message.message.indexOf(dir_file) != -1){
        continue;
      }
      var startLine = message.line != "0" ? parseInt(message.line) - 1 : parseInt(message.line), endLine = message.line != "0" ? parseInt(message.line) - 1 : parseInt(message.line)//, startCol = message.startCol, endCol = message.endCol;
      found.push({
        from: CodeMirror.Pos(startLine, 0),
        to: CodeMirror.Pos(endLine, 0),
        message: message.message,
        severity : "error"
      });
    }
  }

  if(messages != null && messages.Warning && messages.Warning.length > 0){
    // warning messages.
    for ( var i = 0; i < messages.Warning.length; i++) {
      message = messages.Warning[i];
      var startLine = message.line, endLine = message.line, startCol = message.startCol, endCol = message.endCol;
      found.push({
        from: CodeMirror.Pos(startLine, startCol),
        to: CodeMirror.Pos(endLine, endCol),
        message: message.message,
        severity : "warning"
      });
    }
  }

  return found;

});

});